/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.process;

import java.util.Map;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.BoxTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessor {
    private static Logger log = LoggerFactory.getLogger(BaseProcessor.class);
    private Map<String, BoxTreeProvider> boxProviders = ServiceManager.findBoxTreeProviders();
    private Map<String, AreaTreeProvider> areaProviders = ServiceManager.findAreaTreeProviders();
    private Map<String, LogicalTreeProvider> logicalProviders = ServiceManager.findLogicalTreeProviders();
    private Map<String, AreaTreeOperator> operators = ServiceManager.findAreaTreeOperators();
    private Page page;
    private AreaTree atree;
    private LogicalAreaTree ltree;

    public Map<String, BoxTreeProvider> getBoxProviders() {
        return this.boxProviders;
    }

    public Map<String, AreaTreeProvider> getAreaProviders() {
        return this.areaProviders;
    }

    public Map<String, LogicalTreeProvider> getLogicalProviders() {
        return this.logicalProviders;
    }

    public Map<String, AreaTreeOperator> getOperators() {
        return this.operators;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public AreaTree getAreaTree() {
        return this.atree;
    }

    public void setAreaTree(AreaTree atree) {
        this.atree = atree;
    }

    public LogicalAreaTree getLogicalAreaTree() {
        return this.ltree;
    }

    public void setLogicalAreaTree(LogicalAreaTree ltree) {
        this.ltree = ltree;
    }

    public abstract AreaTree segmentPage();

    public abstract LogicalAreaTree buildLogicalTree();

    public Page renderPage(BoxTreeProvider provider, Map<String, Object> params) {
        ServiceManager.setServiceParams((ParametrizedOperation)provider, params);
        this.page = provider.getPage();
        this.atree = null;
        return this.page;
    }

    public AreaTree initAreaTree(AreaTreeProvider provider, Map<String, Object> params) {
        ServiceManager.setServiceParams((ParametrizedOperation)provider, params);
        this.atree = provider.createAreaTree(this.page);
        return this.atree;
    }

    public LogicalAreaTree initLogicalTree(LogicalTreeProvider provider, Map<String, Object> params) {
        ServiceManager.setServiceParams((ParametrizedOperation)provider, params);
        this.ltree = provider.createLogicalTree(this.atree);
        return this.ltree;
    }

    public void apply(AreaTreeOperator op, Map<String, Object> params) {
        if (this.atree != null) {
            ServiceManager.setServiceParams((ParametrizedOperation)op, params);
            op.apply(this.atree);
        } else {
            log.error("Couldn't apply " + op.getId() + ": no area tree");
        }
    }

    protected void treesCompleted() {
    }
}

