/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.BoxTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.OutputDisplay;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.impl.DefaultTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.model.Tag;
import org.fit.layout.process.GUIProcessor;
import org.fit.layout.tools.AreaTreeModel;
import org.fit.layout.tools.BoxTreeModel;
import org.fit.layout.tools.BrowserPanel;
import org.fit.layout.tools.LogicalTreeModel;
import org.fit.layout.tools.OperatorConfigWindow;
import org.fit.layout.tools.ParamsPanel;
import org.fit.layout.tools.ToolbarLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBrowser
implements Browser {
    private static Logger log = LoggerFactory.getLogger(BlockBrowser.class);
    public static BlockBrowser browser;
    public static final float TAG_PROBABILITY_THRESHOLD = 0.3f;
    private BrowserConfig config = new BrowserConfig();
    private GUIProcessor proc;
    private Page page;
    private URL currentUrl = null;
    private boolean dispFinished = false;
    private boolean areasync = true;
    private boolean logsync = true;
    private Set<String> tagTypes;
    private Set<String> tagNames;
    private List<AreaSelectionListener> areaListeners = new LinkedList<AreaSelectionListener>();
    private JFrame mainWindow = null;
    private JPanel container = null;
    private JPanel mainPanel = null;
    private JPanel contentPanel = null;
    private JPanel structurePanel = null;
    private JPanel statusPanel = null;
    private JTextField statusText = null;
    private JButton okButton = null;
    private JTabbedPane sidebarPane = null;
    private JPanel boxTreePanel = null;
    private JScrollPane boxTreeScroll = null;
    private JTree boxTree = null;
    private JScrollPane contentScroll = null;
    private JPanel contentCanvas = null;
    private JSplitPane mainSplitter = null;
    private JToolBar showToolBar = null;
    private JButton redrawButton = null;
    private JPanel areaTreePanel = null;
    private JScrollPane areaTreeScroll = null;
    private JTree areaJTree = null;
    private JToggleButton lookupButton = null;
    private JToggleButton extractButton = null;
    private JToggleButton boxLookupButton = null;
    private JButton showBoxButton = null;
    private JButton showAreaButton = null;
    private JToolBar lookupToolBar = null;
    private JPanel toolPanel = null;
    private JPanel logicalTreePanel = null;
    private JScrollPane logicalTreeScroll = null;
    private JTree logicalTree = null;
    private JButton refreshButton = null;
    private JSplitPane infoSplitter = null;
    private JPanel objectInfoPanel = null;
    private JScrollPane objectInfoScroll = null;
    private JTable infoTable = null;
    private JButton showArtAreaButton = null;
    private JButton showColumnsButton = null;
    private JTextField markednessText;
    private JPanel pathsPanel;
    private JScrollPane pathListScroll;
    private JScrollPane extractionScroll;
    private JTable extractionTable;
    private JFrame treeCompWindow;
    private JToggleButton sepLookupButton;
    private JScrollPane probabilityScroll;
    private JTable probTable;
    private JTabbedPane toolTabs;
    private JPanel sourcesTab;
    private JLabel rendererLabel;
    private JComboBox<BoxTreeProvider> rendererCombo;
    private JPanel rendererChoicePanel;
    private JPanel rendererParamsPanel;
    private JPanel segmChoicePanel;
    private JPanel segmParamsPanel;
    private JLabel lblSegmentator;
    private JComboBox<AreaTreeProvider> segmentatorCombo;
    private JCheckBox segmAutorunCheckbox;
    private JButton segmRunButton;
    private JButton btnOperators;
    private JFrame operatorWindow;
    private JPanel logicalChoicePanel;
    private JPanel logicalParamsPanel;
    private JLabel lblLogicalBuilder;
    private JComboBox<LogicalTreeProvider> logicalCombo;
    private JButton logicalRunButton;
    private JCheckBox logicalAutorunCheckbox;

    public BlockBrowser() {
        this.proc = new GUIProcessor(){

            @Override
            protected void treesCompleted() {
                BlockBrowser.this.refresh();
            }
        };
    }

    public void setLocation(String url) {
        ((ParamsPanel)this.rendererParamsPanel).setParam("url", url);
        this.displayURL(url);
    }

    public String getLocation() {
        return this.currentUrl.toString();
    }

    public void setLoadImages(boolean b) {
        this.config.setLoadImages(b);
    }

    public boolean getLoadImages() {
        return this.config.getLoadImages();
    }

    public void refresh() {
        this.boxTree.setModel(new BoxTreeModel(this.proc.getPage().getRoot()));
        if (this.proc.getAreaTree() != null) {
            this.areaJTree.setModel(new AreaTreeModel(this.proc.getAreaTree().getRoot()));
        }
        if (this.proc.getLogicalAreaTree() != null) {
            this.logicalTree.setModel(new LogicalTreeModel(this.proc.getLogicalAreaTree().getRoot()));
        }
    }

    public void addToolBar(JToolBar toolbar) {
        this.toolPanel.add(toolbar);
        this.toolPanel.updateUI();
    }

    public void addToolPanel(String title, JComponent component) {
        this.toolTabs.addTab(title, component);
    }

    public void addStructurePanel(String title, JComponent component) {
        this.sidebarPane.addTab(title, component);
    }

    public void addInfoPanel(JComponent component, double weighty) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 5, 0);
        constraints.fill = 1;
        constraints.gridy = -1;
        constraints.weightx = 1.0;
        constraints.weighty = weighty;
        constraints.gridx = 0;
        this.objectInfoPanel.add((Component)component, constraints);
    }

    public OutputDisplay getOutputDisplay() {
        return ((BrowserPanel)this.contentCanvas).getOutputDisplay();
    }

    public void updateDisplay() {
        this.contentCanvas.repaint();
    }

    public Area getSelectedArea() {
        if (this.areaJTree == null) {
            return null;
        }
        return (Area)this.areaJTree.getLastSelectedPathComponent();
    }

    public void addAreaSelectionListener(AreaSelectionListener listener) {
        this.areaListeners.add(listener);
    }

    public void setPage(Page page) {
        this.page = page;
        this.contentCanvas = this.createContentCanvas();
        this.contentCanvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Click: " + e.getX() + ":" + e.getY());
                BlockBrowser.this.canvasClick(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BlockBrowser.this.statusText.setText("");
            }
        });
        this.contentCanvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String s = "Absolute: " + e.getX() + ":" + e.getY();
                Area node = (Area)BlockBrowser.this.areaJTree.getLastSelectedPathComponent();
                if (node != null) {
                    Area area = node;
                    int rx = e.getX() - area.getX1();
                    int ry = e.getY() - area.getY1();
                    s = s + "  Relative: " + rx + ":" + ry;
                }
                BlockBrowser.this.statusText.setText(s);
            }
        });
        this.contentScroll.setViewportView(this.contentCanvas);
        this.boxTree.setModel(new BoxTreeModel(this.proc.getPage().getRoot()));
        this.dispFinished = true;
    }

    public Page getPage() {
        return this.page;
    }

    public AreaTree getAreaTree() {
        return this.proc.getAreaTree();
    }

    public LogicalAreaTree getLogicalTree() {
        return this.proc.getLogicalAreaTree();
    }

    public void setAreaTree(AreaTree areaTree) {
        this.proc.setAreaTree(areaTree);
        this.updateTagLists(areaTree);
    }

    public void setLogicalTree(LogicalAreaTree logicalTree) {
        this.proc.setLogicalAreaTree(logicalTree);
    }

    public GUIProcessor getProcessor() {
        return this.proc;
    }

    public void displayURL(String urlstring) {
        this.dispFinished = false;
        if (this.treeCompWindow != null) {
            this.treeCompWindow.setVisible(false);
            this.treeCompWindow.dispose();
            this.treeCompWindow = null;
        }
        try {
            int i;
            if (!(urlstring.startsWith("http:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
                urlstring = "http://" + urlstring;
            }
            if ((i = this.rendererCombo.getSelectedIndex()) != -1) {
                BoxTreeProvider btp = this.rendererCombo.getItemAt(i);
                this.page = this.proc.renderPage(btp, ((ParamsPanel)this.rendererParamsPanel).getParams());
                this.setPage(this.page);
                if (this.segmAutorunCheckbox.isSelected()) {
                    this.segmentPage();
                }
                if (this.logicalAutorunCheckbox.isSelected()) {
                    this.buildLogicalTree();
                }
            }
        }
        catch (Exception e) {
            System.err.println("*** Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void segmentPage() {
        if (this.segmentatorCombo.getSelectedIndex() != -1) {
            AreaTreeProvider provider = this.segmentatorCombo.getItemAt(this.segmentatorCombo.getSelectedIndex());
            this.proc.segmentPage(provider, null);
            this.setAreaTree(this.proc.getAreaTree());
        }
    }

    private void buildLogicalTree() {
        if (this.logicalCombo.getSelectedIndex() != -1) {
            LogicalTreeProvider provider = this.logicalCombo.getItemAt(this.logicalCombo.getSelectedIndex());
            this.proc.buildLogicalTree(provider, null);
            this.setLogicalTree(this.proc.getLogicalAreaTree());
        }
    }

    private JPanel createContentCanvas() {
        if (this.contentCanvas != null) {
            this.contentCanvas = new BrowserPanel(this.page);
        }
        return this.contentCanvas;
    }

    private void canvasClick(int x, int y) {
        Area node;
        if (this.lookupButton.isSelected() && (node = this.proc.getAreaTree().getAreaAt(x, y)) != null) {
            this.showAreaInTree(node);
            this.showAreaInLogicalTree(node);
        }
        if (this.boxLookupButton.isSelected() && (node = this.proc.getPage().getBoxAt(x, y)) != null) {
            this.showBoxInTree((Box)node);
        }
    }

    private void showBoxInTree(Box node) {
        int len = 0;
        for (Box b = node; b != null; b = b.getParentBox()) {
            ++len;
        }
        Object[] path = new Box[len];
        for (Box b = node; b != null; b = b.getParentBox()) {
            path[--len] = b;
        }
        TreePath select = new TreePath(path);
        this.boxTree.setSelectionPath(select);
        this.boxTree.scrollPathToVisible(new TreePath(path));
    }

    private void showAreaInTree(Area node) {
        int len = 0;
        for (Area a = node; a != null; a = (Area)a.getParentArea()) {
            ++len;
        }
        Object[] path = new Area[len];
        for (Area a = node; a != null; a = (Area)a.getParentArea()) {
            path[--len] = a;
        }
        TreePath select = new TreePath(path);
        this.areaJTree.setSelectionPath(select);
        this.areaJTree.scrollPathToVisible(new TreePath(path));
    }

    private void showAreaInLogicalTree(Area node) {
    }

    private void showAllBoxes(Box root) {
        this.getOutputDisplay().drawExtent(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.showAllBoxes(root.getChildBox(i));
        }
    }

    public void showAreas(Area root, String name) {
        if (name == null || root.toString().contains(name)) {
            this.getOutputDisplay().drawExtent(root);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.showAreas((Area)root.getChildArea(i), name);
        }
    }

    private void displayAreaInfo(Area area) {
        Vector<String> cols = this.infoTableData("Property", "Value");
        Vector<Vector<String>> vals = new Vector<Vector<String>>();
        vals.add(this.infoTableData("GP", area.getTopology().getPosition().toString()));
        vals.add(this.infoTableData("Tags", this.tagProbabilityString(area.getTags())));
        vals.add(this.infoTableData("Indent scale", area.getTopology().getMinIndent() + " - " + area.getTopology().getMaxIndent()));
        vals.add(this.infoTableData("Bounds", area.getBounds().toString()));
        vals.add(this.infoTableData("Borders", this.borderString(area)));
        vals.add(this.infoTableData("Bg separated", area.isBackgroundSeparated() ? "true" : "false"));
        vals.add(this.infoTableData("Avg. fsize", String.valueOf(area.getFontSize())));
        vals.add(this.infoTableData("Avg. fweight", String.valueOf(area.getFontWeight())));
        vals.add(this.infoTableData("Avg. fstyle", String.valueOf(area.getFontStyle())));
        vals.add(this.infoTableData("Bg color", this.colorString(area.getBackgroundColor())));
        this.displayProbabilityTable(area);
        DefaultTableModel tab = new DefaultTableModel(vals, cols);
        this.infoTable.setModel(tab);
    }

    private String borderString(Area a) {
        String bs = "";
        if (a.hasTopBorder()) {
            bs = bs + "^";
        }
        if (a.hasLeftBorder()) {
            bs = bs + "<";
        }
        if (a.hasRightBorder()) {
            bs = bs + ">";
        }
        if (a.hasBottomBorder()) {
            bs = bs + "_";
        }
        return bs;
    }

    private String colorString(Color color) {
        if (color == null) {
            return "- transparent -";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String tagString(Map<Tag, Float> tags) {
        String ret = "";
        for (Map.Entry<Tag, Float> entry : tags.entrySet()) {
            ret = ret + entry.getKey() + " ";
        }
        return ret;
    }

    private String tagProbabilityString(Map<Tag, Float> map) {
        String ret = "";
        if (map != null) {
            for (Map.Entry<Tag, Float> entry : map.entrySet()) {
                if (!(entry.getValue().floatValue() > 0.3f)) continue;
                ret = ret + entry.getKey() + " (" + String.format("%1.2f", entry.getValue()) + ") ";
            }
        }
        return ret;
    }

    private Vector<String> infoTableData(String prop, String value) {
        Vector<String> cols = new Vector<String>(2);
        cols.add(prop);
        cols.add(value);
        return cols;
    }

    private void displayProbabilityTable(Area area) {
        Vector<String> cols = new Vector<String>(this.tagNames);
        Collections.sort(cols);
        cols.insertElementAt("Type", 0);
        Vector<String> types = new Vector<String>(this.tagTypes);
        Collections.sort(types);
        Vector<Vector<String>> lines = new Vector<Vector<String>>(types.size());
        for (String type : types) {
            lines.add(this.getProbTableLine(type, cols, area.getTags()));
        }
        this.probTable.setModel(new DefaultTableModel(lines, cols));
    }

    private Vector<String> getProbTableLine(String type, List<String> names, Map<Tag, Float> data) {
        Vector<String> ret = new Vector<String>();
        boolean first = true;
        for (String name : names) {
            if (first) {
                ret.add(type);
                first = false;
                continue;
            }
            DefaultTag search = new DefaultTag(type, name);
            if (data.containsKey(search)) {
                ret.add(String.format("%1.2f", data.get(search)));
                continue;
            }
            ret.add("");
        }
        return ret;
    }

    private void showArea(Area area) {
        ((BrowserPanel)this.contentCanvas).getOutputDisplay().drawExtent(area);
        this.contentCanvas.repaint();
        this.displayAreaInfo(area);
        for (AreaSelectionListener listener : this.areaListeners) {
            listener.areaSelected(area);
        }
    }

    private void updateTagLists(AreaTree tree) {
        this.tagNames = new HashSet<String>();
        this.tagTypes = new HashSet<String>();
        this.recursiveUpdateTagLists(tree.getRoot());
    }

    private void recursiveUpdateTagLists(Area root) {
        for (Tag tag : root.getTags().keySet()) {
            this.tagNames.add(tag.getValue());
            this.tagTypes.add(tag.getType());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveUpdateTagLists((Area)root.getChildArea(i));
        }
    }

    public BrowserCanvas getBrowserCanvas() {
        return (BrowserCanvas)this.contentCanvas;
    }

    public void initPlugins() {
        ServiceLoader<BrowserPlugin> loader = ServiceLoader.load(BrowserPlugin.class);
        for (BrowserPlugin plugin : loader) {
            log.info("Init plugin: {}", (Object)plugin.getClass().getName());
            plugin.init((Browser)this);
        }
    }

    public JFrame getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = new JFrame();
            this.mainWindow.setTitle("Visual Block Browser");
            this.mainWindow.setVisible(true);
            this.mainWindow.setBounds(new Rectangle(0, 0, 1489, 256));
            this.mainWindow.setMinimumSize(new Dimension(1200, 256));
            this.mainWindow.setContentPane(this.getContainer());
            this.mainWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BlockBrowser.this.mainWindow.setVisible(false);
                    System.exit(0);
                }
            });
        }
        return this.mainWindow;
    }

    private JPanel getContainer() {
        if (this.container == null) {
            this.container = new JPanel();
            this.container.setLayout(new BorderLayout());
            this.container.add((Component)this.getToolPanel(), "North");
            this.container.add((Component)this.getMainPanel(), "Center");
        }
        return this.container;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = -1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = -1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridy = 2;
            this.mainPanel = new JPanel();
            GridBagLayout gbl_mainPanel = new GridBagLayout();
            this.mainPanel.setLayout(gbl_mainPanel);
            GridBagConstraints gbc_toolTabs = new GridBagConstraints();
            gbc_toolTabs.fill = 2;
            gbc_toolTabs.weightx = 1.0;
            gbc_toolTabs.insets = new Insets(0, 0, 5, 0);
            gbc_toolTabs.gridx = 0;
            gbc_toolTabs.gridy = 0;
            this.mainPanel.add((Component)this.getToolTabs(), gbc_toolTabs);
            this.mainPanel.add((Component)this.getMainSplitter(), gridBagConstraints11);
            this.mainPanel.add((Component)this.getStatusPanel(), gridBagConstraints3);
        }
        return this.mainPanel;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(gridLayout1);
            this.contentPanel.add((Component)this.getContentScroll(), null);
        }
        return this.contentPanel;
    }

    private JPanel getStructurePanel() {
        if (this.structurePanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.structurePanel = new JPanel();
            this.structurePanel.setPreferredSize(new Dimension(200, 408));
            this.structurePanel.setLayout(gridLayout);
            this.structurePanel.add((Component)this.getSidebarPane(), null);
        }
        return this.structurePanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 7, 0, 0);
            gridBagConstraints4.gridy = 2;
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new GridBagLayout());
            this.statusPanel.add((Component)this.getStatusText(), gridBagConstraints4);
        }
        return this.statusPanel;
    }

    private JTextField getStatusText() {
        if (this.statusText == null) {
            this.statusText = new JTextField();
            this.statusText.setEditable(false);
            this.statusText.setText("Browser ready.");
        }
        return this.statusText;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Go!");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object urlval = ((ParamsPanel)BlockBrowser.this.rendererParamsPanel).getParam("url");
                    if (urlval != null) {
                        BlockBrowser.this.displayURL(urlval.toString());
                    }
                }
            });
        }
        return this.okButton;
    }

    private JTabbedPane getSidebarPane() {
        if (this.sidebarPane == null) {
            this.sidebarPane = new JTabbedPane();
            this.sidebarPane.addTab("Area tree", null, this.getJPanel(), null);
            this.sidebarPane.addTab("Logical tree", null, this.getLogicalTreePanel(), null);
            this.sidebarPane.addTab("Box tree", null, this.getBoxTreePanel(), null);
            this.sidebarPane.addTab("Paths", null, this.getPathsPanel(), null);
        }
        return this.sidebarPane;
    }

    private JPanel getBoxTreePanel() {
        if (this.boxTreePanel == null) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.setRows(1);
            this.boxTreePanel = new JPanel();
            this.boxTreePanel.setLayout(gridLayout2);
            this.boxTreePanel.add((Component)this.getBoxTreeScroll(), null);
        }
        return this.boxTreePanel;
    }

    private JScrollPane getBoxTreeScroll() {
        if (this.boxTreeScroll == null) {
            this.boxTreeScroll = new JScrollPane();
            this.boxTreeScroll.setViewportView(this.getBoxTree());
        }
        return this.boxTreeScroll;
    }

    private JTree getBoxTree() {
        if (this.boxTree == null) {
            this.boxTree = new JTree();
            this.boxTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Box node = (Box)BlockBrowser.this.boxTree.getLastSelectedPathComponent();
                    if (node != null) {
                        System.out.println("Node:" + node);
                        ((BrowserPanel)BlockBrowser.this.contentCanvas).getOutputDisplay().drawExtent(node);
                        BlockBrowser.this.contentCanvas.repaint();
                    }
                }
            });
        }
        return this.boxTree;
    }

    private JScrollPane getContentScroll() {
        if (this.contentScroll == null) {
            this.contentScroll = new JScrollPane();
            this.contentScroll.setViewportView(this.getContentCanvas());
            this.contentScroll.getVerticalScrollBar().setUnitIncrement(10);
            this.contentScroll.addComponentListener(new ComponentAdapter(){});
        }
        return this.contentScroll;
    }

    private JPanel getContentCanvas() {
        if (this.contentCanvas == null) {
            this.contentCanvas = new JPanel();
        }
        return this.contentCanvas;
    }

    private JSplitPane getMainSplitter() {
        if (this.mainSplitter == null) {
            this.mainSplitter = new JSplitPane();
            this.mainSplitter.setDividerLocation(250);
            this.mainSplitter.setLeftComponent(this.getStructurePanel());
            this.mainSplitter.setRightComponent(this.getInfoSplitter());
        }
        return this.mainSplitter;
    }

    private JToolBar getShowToolBar() {
        if (this.showToolBar == null) {
            this.showToolBar = new JToolBar();
            this.showToolBar.add(this.getRedrawButton());
            this.showToolBar.add(this.getRefreshButton());
            this.showToolBar.add(this.getShowBoxButton());
            this.showToolBar.add(this.getShowAreaButton());
            this.showToolBar.add(this.getShowArtAreaButton());
            this.showToolBar.add(this.getShowColumnsButton());
        }
        return this.showToolBar;
    }

    private JButton getRedrawButton() {
        if (this.redrawButton == null) {
            this.redrawButton = new JButton();
            this.redrawButton.setText("Clear");
            this.redrawButton.setMnemonic(0);
            this.redrawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((BrowserPanel)BlockBrowser.this.contentCanvas).redrawPage();
                    BlockBrowser.this.contentCanvas.repaint();
                }
            });
        }
        return this.redrawButton;
    }

    private JPanel getJPanel() {
        if (this.areaTreePanel == null) {
            GridLayout gridLayout4 = new GridLayout();
            gridLayout4.setRows(1);
            gridLayout4.setColumns(1);
            this.areaTreePanel = new JPanel();
            this.areaTreePanel.setLayout(gridLayout4);
            this.areaTreePanel.add((Component)this.getJScrollPane(), null);
        }
        return this.areaTreePanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.areaTreeScroll == null) {
            this.areaTreeScroll = new JScrollPane();
            this.areaTreeScroll.setViewportView(this.getAreaJTree());
        }
        return this.areaTreeScroll;
    }

    private JTree getAreaJTree() {
        if (this.areaJTree == null) {
            this.areaJTree = new JTree();
            this.areaJTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Area node;
                    if (BlockBrowser.this.logsync && (node = (Area)BlockBrowser.this.areaJTree.getLastSelectedPathComponent()) != null) {
                        BlockBrowser.this.showArea(node);
                        BlockBrowser.this.areasync = false;
                        BlockBrowser.this.showAreaInLogicalTree(node);
                        BlockBrowser.this.areasync = true;
                    }
                }
            });
            this.areaJTree.setModel(new AreaTreeModel(null));
        }
        return this.areaJTree;
    }

    private JToggleButton getLookupButton() {
        if (this.lookupButton == null) {
            this.lookupButton = new JToggleButton();
            this.lookupButton.setSelected(true);
            this.lookupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (BlockBrowser.this.lookupButton.isSelected()) {
                        BlockBrowser.this.boxLookupButton.setSelected(false);
                        BlockBrowser.this.sepLookupButton.setSelected(false);
                        BlockBrowser.this.extractButton.setSelected(false);
                    }
                }
            });
            this.lookupButton.setText("Area");
            this.lookupButton.setToolTipText("Find areas");
        }
        return this.lookupButton;
    }

    private JToggleButton getSepLookupButton() {
        if (this.sepLookupButton == null) {
            this.sepLookupButton = new JToggleButton("Sep");
            this.sepLookupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BlockBrowser.this.lookupButton.setSelected(false);
                    BlockBrowser.this.boxLookupButton.setSelected(false);
                    BlockBrowser.this.extractButton.setSelected(false);
                }
            });
        }
        return this.sepLookupButton;
    }

    private JToggleButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JToggleButton();
            this.extractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BlockBrowser.this.extractButton.isSelected()) {
                        BlockBrowser.this.boxLookupButton.setSelected(false);
                        BlockBrowser.this.sepLookupButton.setSelected(false);
                        BlockBrowser.this.lookupButton.setSelected(false);
                    }
                }
            });
            this.extractButton.setText("Extract");
        }
        return this.extractButton;
    }

    private JToggleButton getBoxLookupButton() {
        if (this.boxLookupButton == null) {
            this.boxLookupButton = new JToggleButton();
            this.boxLookupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BlockBrowser.this.boxLookupButton.isSelected()) {
                        BlockBrowser.this.lookupButton.setSelected(false);
                        BlockBrowser.this.sepLookupButton.setSelected(false);
                        BlockBrowser.this.extractButton.setSelected(false);
                    }
                }
            });
            this.boxLookupButton.setText("Box");
            this.boxLookupButton.setToolTipText("Find boxes");
        }
        return this.boxLookupButton;
    }

    private JButton getShowBoxButton() {
        if (this.showBoxButton == null) {
            this.showBoxButton = new JButton();
            this.showBoxButton.setText("Show boxes");
            this.showBoxButton.setToolTipText("Show all boxes in the selected tree");
            this.showBoxButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Box node = (Box)BlockBrowser.this.boxTree.getLastSelectedPathComponent();
                    if (node != null) {
                        BlockBrowser.this.showAllBoxes(node);
                        BlockBrowser.this.contentCanvas.repaint();
                    }
                }
            });
        }
        return this.showBoxButton;
    }

    private JButton getShowAreaButton() {
        if (this.showAreaButton == null) {
            this.showAreaButton = new JButton();
            this.showAreaButton.setText("Show areas");
            this.showAreaButton.setToolTipText("Show all the areas in the selected area");
            this.showAreaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Area node = (Area)BlockBrowser.this.areaJTree.getLastSelectedPathComponent();
                    if (node != null) {
                        BlockBrowser.this.showAreas(node, null);
                        BlockBrowser.this.contentCanvas.repaint();
                    }
                }
            });
        }
        return this.showAreaButton;
    }

    private JToolBar getLookupToolBar() {
        if (this.lookupToolBar == null) {
            this.lookupToolBar = new JToolBar();
            this.lookupToolBar.add(this.getBoxLookupButton());
            this.lookupToolBar.add(this.getLookupButton());
            this.lookupToolBar.add(this.getSepLookupButton());
            this.lookupToolBar.add(this.getExtractButton());
        }
        return this.lookupToolBar;
    }

    private JPanel getToolPanel() {
        if (this.toolPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.toolPanel = new JPanel();
            this.toolPanel.setLayout(new ToolbarLayout());
            this.toolPanel.add(this.getShowToolBar());
            this.toolPanel.add(this.getLookupToolBar());
        }
        return this.toolPanel;
    }

    private JPanel getLogicalTreePanel() {
        if (this.logicalTreePanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridx = 0;
            this.logicalTreePanel = new JPanel();
            this.logicalTreePanel.setLayout(new GridBagLayout());
            this.logicalTreePanel.add((Component)this.getLogicalTreeScroll(), gridBagConstraints8);
        }
        return this.logicalTreePanel;
    }

    private JScrollPane getLogicalTreeScroll() {
        if (this.logicalTreeScroll == null) {
            this.logicalTreeScroll = new JScrollPane();
            this.logicalTreeScroll.setViewportView(this.getLogicalJTree());
        }
        return this.logicalTreeScroll;
    }

    private JTree getLogicalJTree() {
        if (this.logicalTree == null) {
            this.logicalTree = new JTree();
            this.logicalTree.setModel(new LogicalTreeModel(null));
        }
        return this.logicalTree;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText("Refresh");
            this.refreshButton.setToolTipText("Refresh the tree views");
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlockBrowser.this.refresh();
                }
            });
        }
        return this.refreshButton;
    }

    private JSplitPane getInfoSplitter() {
        if (this.infoSplitter == null) {
            this.infoSplitter = new JSplitPane();
            this.infoSplitter.setDividerLocation(1050);
            this.infoSplitter.setLeftComponent(this.getContentPanel());
            this.infoSplitter.setRightComponent(this.getObjectInfoPanel());
        }
        return this.infoSplitter;
    }

    private JPanel getObjectInfoPanel() {
        if (this.objectInfoPanel == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 0.5;
            gridBagConstraints10.gridx = 0;
            this.objectInfoPanel = new JPanel();
            GridBagLayout gbl_objectInfoPanel = new GridBagLayout();
            gbl_objectInfoPanel.rowWeights = new double[]{0.0, 0.0, 0.0};
            gbl_objectInfoPanel.columnWeights = new double[]{1.0};
            this.objectInfoPanel.setLayout(gbl_objectInfoPanel);
            this.objectInfoPanel.add((Component)this.getJScrollPane4(), gridBagConstraints10);
            GridBagConstraints gbc_probabilityScroll = new GridBagConstraints();
            gbc_probabilityScroll.weighty = 0.25;
            gbc_probabilityScroll.weightx = 1.0;
            gbc_probabilityScroll.insets = new Insets(0, 0, 5, 0);
            gbc_probabilityScroll.fill = 1;
            gbc_probabilityScroll.gridx = 0;
            gbc_probabilityScroll.gridy = 1;
            this.objectInfoPanel.add((Component)this.getProbabilityScroll(), gbc_probabilityScroll);
            GridBagConstraints gbc_markednessText = new GridBagConstraints();
            gbc_markednessText.insets = new Insets(0, 0, 5, 0);
            gbc_markednessText.fill = 2;
            gbc_markednessText.gridx = 0;
            gbc_markednessText.gridy = 2;
            this.objectInfoPanel.add((Component)this.getMarkednessText(), gbc_markednessText);
        }
        return this.objectInfoPanel;
    }

    private JScrollPane getJScrollPane4() {
        if (this.objectInfoScroll == null) {
            this.objectInfoScroll = new JScrollPane();
            this.objectInfoScroll.setViewportView(this.getInfoTable());
        }
        return this.objectInfoScroll;
    }

    private JTable getInfoTable() {
        if (this.infoTable == null) {
            this.infoTable = new JTable();
        }
        return this.infoTable;
    }

    private JButton getShowArtAreaButton() {
        if (this.showArtAreaButton == null) {
            this.showArtAreaButton = new JButton();
            this.showArtAreaButton.setText("Art. areas");
            this.showArtAreaButton.setToolTipText("Show artificial areas marked with <area>");
            this.showArtAreaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Area node = (Area)BlockBrowser.this.areaJTree.getLastSelectedPathComponent();
                    if (node != null) {
                        BlockBrowser.this.showAreas(node, "<area");
                        BlockBrowser.this.contentCanvas.repaint();
                    }
                }
            });
        }
        return this.showArtAreaButton;
    }

    private JButton getShowColumnsButton() {
        if (this.showColumnsButton == null) {
            this.showColumnsButton = new JButton();
            this.showColumnsButton.setText("Columns");
            this.showColumnsButton.setToolTipText("Show columns marked with <column>");
            this.showColumnsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Area node = (Area)BlockBrowser.this.areaJTree.getLastSelectedPathComponent();
                    if (node != null) {
                        BlockBrowser.this.showAreas(node, "<column>");
                        BlockBrowser.this.contentCanvas.repaint();
                    }
                }
            });
        }
        return this.showColumnsButton;
    }

    private JTextField getMarkednessText() {
        if (this.markednessText == null) {
            this.markednessText = new JTextField();
            this.markednessText.setHorizontalAlignment(0);
            this.markednessText.setText("---");
            this.markednessText.setFont(new Font("Dialog", 0, 18));
            this.markednessText.setEditable(false);
            this.markednessText.setColumns(10);
        }
        return this.markednessText;
    }

    private JPanel getPathsPanel() {
        if (this.pathsPanel == null) {
            this.pathsPanel = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWidths = new int[]{0, 0};
            gbl_pathsPanel.rowHeights = new int[]{0, 0, 0};
            gbl_pathsPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pathsPanel.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
            this.pathsPanel.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_pathListScroll = new GridBagConstraints();
            gbc_pathListScroll.insets = new Insets(0, 0, 5, 0);
            gbc_pathListScroll.fill = 1;
            gbc_pathListScroll.gridx = 0;
            gbc_pathListScroll.gridy = 0;
            this.pathsPanel.add((Component)this.getPathListScroll(), gbc_pathListScroll);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 0;
            gbc_extractionScroll.gridy = 1;
            this.pathsPanel.add((Component)this.getExtractionScroll(), gbc_extractionScroll);
        }
        return this.pathsPanel;
    }

    private JScrollPane getPathListScroll() {
        if (this.pathListScroll == null) {
            this.pathListScroll = new JScrollPane();
        }
        return this.pathListScroll;
    }

    private JScrollPane getExtractionScroll() {
        if (this.extractionScroll == null) {
            this.extractionScroll = new JScrollPane();
            this.extractionScroll.setViewportView(this.getExtractionTable());
        }
        return this.extractionScroll;
    }

    private JScrollPane getProbabilityScroll() {
        if (this.probabilityScroll == null) {
            this.probabilityScroll = new JScrollPane();
            this.probabilityScroll.setViewportView(this.getProbTable());
        }
        return this.probabilityScroll;
    }

    private JTable getProbTable() {
        if (this.probTable == null) {
            this.probTable = new JTable();
            this.probTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    try {
                        Double d = Double.parseDouble(value.toString().replace(',', '.'));
                        if (d <= (double)0.3f) {
                            c.setForeground(new Color(180, 180, 180));
                        } else {
                            c.setForeground(Color.BLACK);
                        }
                    }
                    catch (NumberFormatException e) {
                        c.setForeground(Color.BLACK);
                    }
                    return c;
                }
            });
        }
        return this.probTable;
    }

    private JTable getExtractionTable() {
        if (this.extractionTable == null) {
            this.extractionTable = new JTable();
        }
        return this.extractionTable;
    }

    private JTabbedPane getToolTabs() {
        if (this.toolTabs == null) {
            this.toolTabs = new JTabbedPane(1);
            this.toolTabs.addTab("Sources", null, this.getSourcesTab(), null);
        }
        return this.toolTabs;
    }

    private JPanel getSourcesTab() {
        if (this.sourcesTab == null) {
            LogicalTreeProvider lp;
            AreaTreeProvider ap;
            this.sourcesTab = new JPanel();
            GridBagLayout gbl_sourcesTab = new GridBagLayout();
            gbl_sourcesTab.columnWeights = new double[]{1.0};
            gbl_sourcesTab.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0};
            this.sourcesTab.setLayout(gbl_sourcesTab);
            GridBagConstraints gbc_rendererChoicePanel = new GridBagConstraints();
            gbc_rendererChoicePanel.weightx = 1.0;
            gbc_rendererChoicePanel.anchor = 13;
            gbc_rendererChoicePanel.fill = 1;
            gbc_rendererChoicePanel.insets = new Insets(0, 0, 1, 0);
            gbc_rendererChoicePanel.gridx = 0;
            gbc_rendererChoicePanel.gridy = 0;
            this.sourcesTab.add((Component)this.getRendererChoicePanel(), gbc_rendererChoicePanel);
            GridBagConstraints gbc_rendererParamsPanel = new GridBagConstraints();
            gbc_rendererParamsPanel.weightx = 1.0;
            gbc_rendererParamsPanel.fill = 1;
            gbc_rendererParamsPanel.insets = new Insets(0, 0, 2, 0);
            gbc_rendererParamsPanel.gridx = 0;
            gbc_rendererParamsPanel.gridy = 1;
            this.sourcesTab.add((Component)this.getRendererParamsPanel(), gbc_rendererParamsPanel);
            GridBagConstraints gbc_segmChoicePanel = new GridBagConstraints();
            gbc_segmChoicePanel.weightx = 1.0;
            gbc_segmChoicePanel.anchor = 13;
            gbc_segmChoicePanel.fill = 1;
            gbc_segmChoicePanel.insets = new Insets(0, 0, 1, 0);
            gbc_segmChoicePanel.gridx = 0;
            gbc_segmChoicePanel.gridy = 2;
            this.sourcesTab.add((Component)this.getSegmChoicePanel(), gbc_segmChoicePanel);
            GridBagConstraints gbc_segmParamsPanel = new GridBagConstraints();
            gbc_segmParamsPanel.insets = new Insets(0, 0, 2, 0);
            gbc_segmParamsPanel.weightx = 1.0;
            gbc_segmParamsPanel.fill = 1;
            gbc_segmParamsPanel.gridx = 0;
            gbc_segmParamsPanel.gridy = 3;
            this.sourcesTab.add((Component)this.getSegmParamsPanel(), gbc_segmParamsPanel);
            GridBagConstraints gbc_logicalChoicePanel = new GridBagConstraints();
            gbc_logicalChoicePanel.insets = new Insets(0, 0, 1, 0);
            gbc_logicalChoicePanel.fill = 1;
            gbc_logicalChoicePanel.gridx = 0;
            gbc_logicalChoicePanel.gridy = 4;
            this.sourcesTab.add((Component)this.getLogicalChoicePanel(), gbc_logicalChoicePanel);
            GridBagConstraints gbc_logicalParamsPanel = new GridBagConstraints();
            gbc_logicalParamsPanel.fill = 1;
            gbc_logicalParamsPanel.gridx = 0;
            gbc_logicalParamsPanel.gridy = 5;
            this.sourcesTab.add((Component)this.getLogicalParamsPanel(), gbc_logicalParamsPanel);
            BoxTreeProvider p = (BoxTreeProvider)this.rendererCombo.getSelectedItem();
            if (p != null) {
                ((ParamsPanel)this.rendererParamsPanel).setOperation((ParametrizedOperation)p);
            }
            if ((ap = (AreaTreeProvider)this.segmentatorCombo.getSelectedItem()) != null) {
                ((ParamsPanel)this.segmParamsPanel).setOperation((ParametrizedOperation)ap);
            }
            if ((lp = (LogicalTreeProvider)this.logicalCombo.getSelectedItem()) != null) {
                ((ParamsPanel)this.logicalParamsPanel).setOperation((ParametrizedOperation)lp);
            }
        }
        return this.sourcesTab;
    }

    private JLabel getRendererLabel() {
        if (this.rendererLabel == null) {
            this.rendererLabel = new JLabel("Renderer");
        }
        return this.rendererLabel;
    }

    private JComboBox<BoxTreeProvider> getRendererCombo() {
        if (this.rendererCombo == null) {
            this.rendererCombo = new JComboBox();
            this.rendererCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BoxTreeProvider p = (BoxTreeProvider)BlockBrowser.this.rendererCombo.getSelectedItem();
                    if (p != null) {
                        ((ParamsPanel)BlockBrowser.this.rendererParamsPanel).setOperation((ParametrizedOperation)p);
                    }
                }
            });
            Vector<BoxTreeProvider> providers = new Vector<BoxTreeProvider>(this.proc.getBoxProviders().values());
            DefaultComboBoxModel<BoxTreeProvider> model = new DefaultComboBoxModel<BoxTreeProvider>(providers);
            this.rendererCombo.setModel(model);
        }
        return this.rendererCombo;
    }

    private JPanel getRendererChoicePanel() {
        if (this.rendererChoicePanel == null) {
            this.rendererChoicePanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.rendererChoicePanel.getLayout();
            flowLayout.setAlignment(0);
            this.rendererChoicePanel.add(this.getRendererLabel());
            this.rendererChoicePanel.add(this.getRendererCombo());
            this.rendererChoicePanel.add(this.getOkButton());
        }
        return this.rendererChoicePanel;
    }

    private JPanel getRendererParamsPanel() {
        if (this.rendererParamsPanel == null) {
            this.rendererParamsPanel = new ParamsPanel();
        }
        return this.rendererParamsPanel;
    }

    private JPanel getSegmChoicePanel() {
        if (this.segmChoicePanel == null) {
            this.segmChoicePanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.segmChoicePanel.getLayout();
            flowLayout.setAlignment(0);
            this.segmChoicePanel.add(this.getLblSegmentator());
            this.segmChoicePanel.add(this.getSegmentatorCombo());
            this.segmChoicePanel.add(this.getSegmRunButton());
            this.segmChoicePanel.add(this.getSegmAutorunCheckbox());
            this.segmChoicePanel.add(this.getBtnOperators());
        }
        return this.segmChoicePanel;
    }

    private JPanel getSegmParamsPanel() {
        if (this.segmParamsPanel == null) {
            this.segmParamsPanel = new ParamsPanel();
        }
        return this.segmParamsPanel;
    }

    private JLabel getLblSegmentator() {
        if (this.lblSegmentator == null) {
            this.lblSegmentator = new JLabel("Segmentator");
        }
        return this.lblSegmentator;
    }

    private JComboBox<AreaTreeProvider> getSegmentatorCombo() {
        if (this.segmentatorCombo == null) {
            this.segmentatorCombo = new JComboBox();
            this.segmentatorCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AreaTreeProvider ap = (AreaTreeProvider)BlockBrowser.this.segmentatorCombo.getSelectedItem();
                    if (ap != null) {
                        ((ParamsPanel)BlockBrowser.this.segmParamsPanel).setOperation((ParametrizedOperation)ap);
                    }
                }
            });
            Vector<AreaTreeProvider> providers = new Vector<AreaTreeProvider>(this.proc.getAreaProviders().values());
            DefaultComboBoxModel<AreaTreeProvider> model = new DefaultComboBoxModel<AreaTreeProvider>(providers);
            this.segmentatorCombo.setModel(model);
        }
        return this.segmentatorCombo;
    }

    private JButton getSegmRunButton() {
        if (this.segmRunButton == null) {
            this.segmRunButton = new JButton("Run");
            this.segmRunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlockBrowser.this.segmentPage();
                }
            });
        }
        return this.segmRunButton;
    }

    protected JCheckBox getSegmAutorunCheckbox() {
        if (this.segmAutorunCheckbox == null) {
            this.segmAutorunCheckbox = new JCheckBox("Run automatically");
        }
        return this.segmAutorunCheckbox;
    }

    private JButton getBtnOperators() {
        if (this.btnOperators == null) {
            this.btnOperators = new JButton("Operators...");
            this.btnOperators.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BlockBrowser.this.operatorWindow == null) {
                        BlockBrowser.this.operatorWindow = new OperatorConfigWindow(BlockBrowser.this.proc);
                    }
                    BlockBrowser.this.operatorWindow.setVisible(true);
                }
            });
        }
        return this.btnOperators;
    }

    private JPanel getLogicalChoicePanel() {
        if (this.logicalChoicePanel == null) {
            this.logicalChoicePanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.logicalChoicePanel.getLayout();
            flowLayout.setAlignment(0);
            this.logicalChoicePanel.add(this.getLblLogicalBuilder());
            this.logicalChoicePanel.add(this.getLogicalCombo());
            this.logicalChoicePanel.add(this.getLogicalRunButton());
            this.logicalChoicePanel.add(this.getLogicalAutorunCheckbox());
        }
        return this.logicalChoicePanel;
    }

    private JPanel getLogicalParamsPanel() {
        if (this.logicalParamsPanel == null) {
            this.logicalParamsPanel = new ParamsPanel();
        }
        return this.logicalParamsPanel;
    }

    private JLabel getLblLogicalBuilder() {
        if (this.lblLogicalBuilder == null) {
            this.lblLogicalBuilder = new JLabel("Logical builder");
        }
        return this.lblLogicalBuilder;
    }

    private JComboBox<LogicalTreeProvider> getLogicalCombo() {
        if (this.logicalCombo == null) {
            this.logicalCombo = new JComboBox();
            this.logicalCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogicalTreeProvider lp = (LogicalTreeProvider)BlockBrowser.this.logicalCombo.getSelectedItem();
                    if (lp != null) {
                        ((ParamsPanel)BlockBrowser.this.logicalParamsPanel).setOperation((ParametrizedOperation)lp);
                    }
                }
            });
            Vector<LogicalTreeProvider> providers = new Vector<LogicalTreeProvider>(this.proc.getLogicalProviders().values());
            DefaultComboBoxModel<LogicalTreeProvider> model = new DefaultComboBoxModel<LogicalTreeProvider>(providers);
            this.logicalCombo.setModel(model);
        }
        return this.logicalCombo;
    }

    private JButton getLogicalRunButton() {
        if (this.logicalRunButton == null) {
            this.logicalRunButton = new JButton("Run");
            this.logicalRunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlockBrowser.this.buildLogicalTree();
                }
            });
        }
        return this.logicalRunButton;
    }

    protected JCheckBox getLogicalAutorunCheckbox() {
        if (this.logicalAutorunCheckbox == null) {
            this.logicalAutorunCheckbox = new JCheckBox("Run automatically");
        }
        return this.logicalAutorunCheckbox;
    }

    public static void main(String[] args) {
        final String urlstring = args.length > 0 ? args[0] : "http://cssbox.sf.net";
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    browser = new BlockBrowser();
                    browser.setLoadImages(false);
                    JFrame main = browser.getMainWindow();
                    main.setSize(1600, 1000);
                    browser.initPlugins();
                    main.setVisible(true);
                    URL url = new URL(urlstring);
                    browser.setLocation(url.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

