/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import javax.script.ScriptException;
import jline.console.ConsoleReader;
import org.fit.layout.process.ScriptableProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    private static Logger log = LoggerFactory.getLogger(Console.class);
    private ScriptableProcessor proc = new ScriptableProcessor();

    public Console() {
        this.proc.put("console", this);
        this.init();
    }

    public void interactiveSession(InputStream in, PrintStream out, PrintStream err) throws IOException {
        BufferedReader rin = new BufferedReader(new InputStreamReader(in));
        OutputStreamWriter wout = new OutputStreamWriter(out);
        OutputStreamWriter werr = new OutputStreamWriter(err);
        this.proc.setIO(rin, wout, werr);
        ConsoleReader reader = new ConsoleReader(in, (OutputStream)out);
        reader.setPrompt(this.prompt());
        try {
            this.initSession();
        }
        catch (ScriptException e) {
            log.error(e.getMessage());
        }
        while (true) {
            this.proc.flushIO();
            out.println();
            String cmd = reader.readLine();
            if (cmd == null) break;
            try {
                this.proc.execCommand(cmd);
            }
            catch (ScriptException e) {
                log.error(e.getMessage());
            }
        }
        out.println();
    }

    protected String prompt() {
        return "FitLayout> ";
    }

    protected ScriptableProcessor getProcessor() {
        return this.proc;
    }

    protected void init() {
    }

    protected void initSession() throws ScriptException {
        this.proc.execInternal("init.js");
    }

    public void exit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("FitLayout interactive console");
        Console con = new Console();
        try {
            con.interactiveSession(System.in, System.out, System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

