/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.process.GUIProcessor;
import org.fit.layout.tools.ParamsPanel;

public class OperatorConfigWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GUIProcessor proc;
    private AreaTreeOperator aop;
    private AreaTreeOperator uop;
    private JPanel contentPane;
    private JList<AreaTreeOperator> usedList;
    private JList<AreaTreeOperator> availList;
    private ParamsPanel paramsPanel;

    public OperatorConfigWindow(GUIProcessor proc) {
        this.proc = proc;
        this.initWindow();
        this.updateLists();
    }

    public void initWindow() {
        this.setTitle("Area Operators");
        this.setBounds(100, 100, 800, 300);
        this.setMinimumSize(new Dimension(450, 300));
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        GridBagLayout gbl_contentPane = new GridBagLayout();
        gbl_contentPane.columnWeights = new double[]{1.0, 0.0, 1.0};
        gbl_contentPane.rowWeights = new double[]{0.0, 1.0, 1.0, 0.0};
        this.contentPane.setLayout(gbl_contentPane);
        JLabel lblUsed = new JLabel("Used");
        GridBagConstraints gbc_lblUsed = new GridBagConstraints();
        gbc_lblUsed.insets = new Insets(0, 0, 5, 5);
        gbc_lblUsed.gridx = 0;
        gbc_lblUsed.gridy = 0;
        this.contentPane.add((Component)lblUsed, gbc_lblUsed);
        JLabel availLabel = new JLabel("Available");
        GridBagConstraints gbc_availLabel = new GridBagConstraints();
        gbc_availLabel.insets = new Insets(0, 0, 5, 0);
        gbc_availLabel.gridx = 2;
        gbc_availLabel.gridy = 0;
        this.contentPane.add((Component)availLabel, gbc_availLabel);
        JScrollPane usedScroll = new JScrollPane();
        GridBagConstraints gbc_usedScroll = new GridBagConstraints();
        gbc_usedScroll.weighty = 1.0;
        gbc_usedScroll.weightx = 1.0;
        gbc_usedScroll.insets = new Insets(0, 0, 5, 5);
        gbc_usedScroll.fill = 1;
        gbc_usedScroll.gridx = 0;
        gbc_usedScroll.gridy = 1;
        this.contentPane.add((Component)usedScroll, gbc_usedScroll);
        this.usedList = new JList();
        this.usedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (OperatorConfigWindow.this.usedList.getSelectedValue() != null) {
                    OperatorConfigWindow.this.uop = (AreaTreeOperator)OperatorConfigWindow.this.usedList.getSelectedValue();
                    OperatorConfigWindow.this.paramsPanel.setOperation((ParametrizedOperation)OperatorConfigWindow.this.uop);
                }
            }
        });
        usedScroll.setViewportView(this.usedList);
        JPanel movePanel = new JPanel();
        GridBagConstraints gbc_movePanel = new GridBagConstraints();
        gbc_movePanel.weighty = 1.0;
        gbc_movePanel.insets = new Insets(0, 0, 5, 5);
        gbc_movePanel.fill = 1;
        gbc_movePanel.gridx = 1;
        gbc_movePanel.gridy = 1;
        this.contentPane.add((Component)movePanel, gbc_movePanel);
        GridBagLayout gbl_movePanel = new GridBagLayout();
        gbl_movePanel.columnWeights = new double[]{0.0};
        gbl_movePanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        movePanel.setLayout(gbl_movePanel);
        JButton btnUp = new JButton("Up");
        btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = OperatorConfigWindow.this.usedList.getSelectedIndex();
                if (i > 0) {
                    Collections.swap(OperatorConfigWindow.this.proc.getSelectedOperators(), i, i - 1);
                    OperatorConfigWindow.this.updateLists();
                }
            }
        });
        GridBagConstraints gbc_btnUp = new GridBagConstraints();
        gbc_btnUp.gridx = 0;
        gbc_btnUp.gridy = 0;
        movePanel.add((Component)btnUp, gbc_btnUp);
        JButton btnDown = new JButton("Down");
        btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = OperatorConfigWindow.this.usedList.getSelectedIndex();
                if (i != -1 && i < OperatorConfigWindow.this.proc.getSelectedOperators().size() - 1) {
                    Collections.swap(OperatorConfigWindow.this.proc.getSelectedOperators(), i + 1, i);
                    OperatorConfigWindow.this.updateLists();
                }
            }
        });
        GridBagConstraints gbc_btnDown = new GridBagConstraints();
        gbc_btnDown.insets = new Insets(5, 5, 0, 5);
        gbc_btnDown.gridx = 0;
        gbc_btnDown.gridy = 1;
        movePanel.add((Component)btnDown, gbc_btnDown);
        JButton btnLeft = new JButton("<<");
        btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTreeOperator op = (AreaTreeOperator)OperatorConfigWindow.this.availList.getSelectedValue();
                if (op != null) {
                    OperatorConfigWindow.this.proc.getSelectedOperators().add(op);
                    OperatorConfigWindow.this.updateLists();
                }
            }
        });
        GridBagConstraints gbc_btnLeft = new GridBagConstraints();
        gbc_btnLeft.insets = new Insets(10, 0, 0, 0);
        gbc_btnLeft.gridx = 0;
        gbc_btnLeft.gridy = 2;
        movePanel.add((Component)btnLeft, gbc_btnLeft);
        JButton btnRight = new JButton(">>");
        btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTreeOperator op = (AreaTreeOperator)OperatorConfigWindow.this.usedList.getSelectedValue();
                if (op != null) {
                    OperatorConfigWindow.this.proc.getSelectedOperators().remove(op);
                    OperatorConfigWindow.this.updateLists();
                }
            }
        });
        GridBagConstraints gbc_btnRight = new GridBagConstraints();
        gbc_btnRight.insets = new Insets(5, 0, 0, 0);
        gbc_btnRight.gridx = 0;
        gbc_btnRight.gridy = 3;
        movePanel.add((Component)btnRight, gbc_btnRight);
        JScrollPane availScroll = new JScrollPane();
        GridBagConstraints gbc_availScroll = new GridBagConstraints();
        gbc_availScroll.weighty = 1.0;
        gbc_availScroll.weightx = 1.0;
        gbc_availScroll.insets = new Insets(0, 0, 5, 0);
        gbc_availScroll.fill = 1;
        gbc_availScroll.gridx = 2;
        gbc_availScroll.gridy = 1;
        this.contentPane.add((Component)availScroll, gbc_availScroll);
        this.availList = new JList();
        this.availList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (OperatorConfigWindow.this.availList.getSelectedValue() != null) {
                    OperatorConfigWindow.this.aop = (AreaTreeOperator)OperatorConfigWindow.this.availList.getSelectedValue();
                }
            }
        });
        availScroll.setViewportView(this.availList);
        this.paramsPanel = new ParamsPanel();
        GridBagConstraints gbc_paramsPanel = new GridBagConstraints();
        gbc_paramsPanel.insets = new Insets(0, 0, 5, 0);
        gbc_paramsPanel.gridwidth = 3;
        gbc_paramsPanel.fill = 1;
        gbc_paramsPanel.gridx = 0;
        gbc_paramsPanel.gridy = 2;
        this.contentPane.add((Component)this.paramsPanel, gbc_paramsPanel);
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OperatorConfigWindow.this.setVisible(false);
            }
        });
        GridBagConstraints gbc_btnClose = new GridBagConstraints();
        gbc_btnClose.insets = new Insets(0, 0, 0, 5);
        gbc_btnClose.anchor = 13;
        gbc_btnClose.gridx = 2;
        gbc_btnClose.gridy = 3;
        this.contentPane.add((Component)btnClose, gbc_btnClose);
    }

    private void updateLists() {
        Vector<AreaTreeOperator> avail = new Vector<AreaTreeOperator>(this.proc.getOperators().values());
        Vector<AreaTreeOperator> used = this.proc.getSelectedOperators();
        for (AreaTreeOperator op : used) {
            avail.remove(op);
        }
        this.availList.setModel(new DefaultComboBoxModel<AreaTreeOperator>(avail));
        this.usedList.setModel(new DefaultComboBoxModel<AreaTreeOperator>(used));
        if (this.aop != null) {
            this.availList.setSelectedValue(this.aop, true);
        }
        if (this.uop != null) {
            this.usedList.setSelectedValue(this.uop, true);
        }
    }

    protected JList<AreaTreeOperator> getUsedList() {
        return this.usedList;
    }

    protected JList<AreaTreeOperator> getAvailList() {
        return this.availList;
    }

    protected ParamsPanel getParamsPanel() {
        return this.paramsPanel;
    }
}

