/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.fit.layout.api.OutputDisplay;
import org.fit.layout.model.Area;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;

public class OutputDisplayImpl
implements OutputDisplay {
    private Graphics2D g;
    private Color boxLogicalColor = Color.RED;
    private Color boxContentColor = Color.GREEN;
    private Color areaBoundsColor = Color.MAGENTA;

    public OutputDisplayImpl(Graphics2D g) {
        this.g = g;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void drawPage(Page page) {
        this.recursivelyDrawBoxes(page.getRoot());
    }

    private void recursivelyDrawBoxes(Box root) {
        this.drawBox(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelyDrawBoxes(root.getChildBox(i));
        }
    }

    public void drawBox(Box box) {
        Box.Type type = box.getType();
        if (type == Box.Type.TEXT_CONTENT) {
            this.g.setColor(box.getColor());
            Font font = new Font("Serif", 0, 12);
            String fmlspec = box.getFontFamily();
            float fontsize = box.getFontSize();
            int fs = 0;
            if (box.getFontWeight() > 0.5f) {
                fs = 1;
            }
            if (box.getFontStyle() > 0.5f) {
                fs |= 2;
            }
            font = new Font(fmlspec, fs, (int)fontsize);
            this.g.setFont(font);
            String text = box.getText();
            FontMetrics fm = this.g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(text, this.g);
            this.g.drawString(text, box.getX1() + (int)rect.getX(), box.getY1() - (int)rect.getY());
        } else if (type == Box.Type.REPLACED_CONTENT) {
            this.g.setColor(box.getColor());
            Rectangular r = box.getBounds();
            this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
        } else {
            Color bg = box.getBackgroundColor();
            if (bg != null) {
                this.g.setColor(bg);
                Rectangular r = box.getBounds();
                this.g.fillRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
            }
        }
    }

    public void drawExtent(Box box) {
        this.g.setColor(this.boxLogicalColor);
        Rectangular r = box.getBounds();
        this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
        this.g.setColor(this.boxContentColor);
        r = box.getVisualBounds();
        this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
    }

    public void drawExtent(Area area) {
        Rectangular bounds = area.getBounds();
        Color c = this.g.getColor();
        this.g.setColor(this.areaBoundsColor);
        this.g.drawRect(bounds.getX1(), bounds.getY1(), bounds.getWidth() - 1, bounds.getHeight() - 1);
        this.g.setColor(c);
    }

    public void drawRectangle(Rectangular rect, Color color) {
        Color c = this.g.getColor();
        this.g.setColor(color);
        this.g.fillRect(rect.getX1(), rect.getY1(), rect.getWidth(), rect.getHeight());
        this.g.setColor(c);
    }

    public void colorizeByTags(Area area, Set<Tag> s) {
        if (!s.isEmpty()) {
            Rectangular bounds = area.getBounds();
            Color c = this.g.getColor();
            float step = (float)bounds.getHeight() / (float)s.size();
            float y = bounds.getY1();
            for (Tag tag : s) {
                this.g.setColor(this.stringColor(tag.getValue()));
                this.g.fillRect(bounds.getX1(), (int)y, bounds.getWidth(), (int)((double)step + 0.5));
                y += step;
            }
            this.g.setColor(c);
        }
    }

    public void colorizeByClass(Area area, String cname) {
        if (cname != null && !cname.equals("") && !cname.equals("none")) {
            Rectangular bounds = area.getBounds();
            Color c = this.g.getColor();
            float step = bounds.getHeight();
            float y = bounds.getY1();
            this.g.setColor(this.stringColor(cname));
            this.g.fillRect(bounds.getX1(), (int)y, bounds.getWidth(), (int)((double)step + 0.5));
            this.g.setColor(c);
        }
    }

    protected Color stringColor(String cname) {
        if (cname == null || cname.equals("")) {
            return Color.WHITE;
        }
        String s = new String(cname);
        while (s.length() < 6) {
            s = s + s;
        }
        int r = s.charAt(0) * s.charAt(1);
        int g = s.charAt(2) * s.charAt(3);
        int b = s.charAt(4) * s.charAt(5);
        Color ret = new Color(100 + r % 150, 100 + g % 150, 100 + b % 150, 128);
        return ret;
    }
}

