/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fit.layout.api.ParametrizedOperation;

public class ParamsPanel
extends JPanel
implements ChangeListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private ParametrizedOperation op = null;
    private Vector<Component> before = new Vector();
    private Vector<Component> after = new Vector();
    private Map<String, Component> fields = new HashMap<String, Component>();
    private boolean autosave = true;

    public ParamsPanel() {
        this.setLayout(new FlowLayout(0));
        this.clear();
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
    }

    public void setOperation(ParametrizedOperation op) {
        this.op = op;
        this.clear();
        this.addFields();
        this.updateUI();
    }

    public void addBefore(Component component) {
        this.before.add(component);
    }

    public void addAfter(Component component) {
        this.after.add(component);
    }

    public void setParam(String name, Object value) {
        Component comp = this.fields.get(name);
        if (comp != null) {
            if (comp instanceof JCheckBox) {
                if (value != null && value instanceof Boolean) {
                    ((JCheckBox)comp).setSelected((Boolean)value);
                }
            } else if (comp instanceof JSpinner) {
                if (value != null && (value instanceof Integer || value instanceof Float || value instanceof Double)) {
                    ((JSpinner)comp).setValue(value);
                }
            } else if (comp instanceof JTextField && value != null) {
                ((JTextField)comp).setText(value.toString());
            }
        }
    }

    public Object getParam(String name) {
        Component comp = this.fields.get(name);
        if (comp != null) {
            if (comp instanceof JCheckBox) {
                return ((JCheckBox)comp).isSelected();
            }
            if (comp instanceof JSpinner) {
                return ((JSpinner)comp).getValue();
            }
            if (comp instanceof JTextField) {
                return ((JTextField)comp).getText();
            }
            return null;
        }
        return null;
    }

    public Map<String, Object> getParams() {
        HashMap<String, Object> ret = new HashMap<String, Object>(this.fields.size());
        for (String param : this.fields.keySet()) {
            ret.put(param, this.getParam(param));
        }
        return ret;
    }

    public void saveParams() {
        for (String param : this.fields.keySet()) {
            this.op.setParam(param, this.getParam(param));
        }
    }

    protected void clear() {
        this.removeAll();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
    }

    protected void addFields() {
        if (!this.before.isEmpty() || !this.after.isEmpty() || this.op.getParamNames().length > 0) {
            this.setMinimumSize(null);
            this.setPreferredSize(null);
        }
        for (Component comp : this.before) {
            this.add(comp);
        }
        this.addParamFields();
        for (Component comp : this.after) {
            this.add(comp);
        }
    }

    protected void addParamFields() {
        String[] params = this.op.getParamNames();
        ParametrizedOperation.ValueType[] types = this.op.getParamTypes();
        for (int i = 0; i < params.length; ++i) {
            if (types[i] != ParametrizedOperation.ValueType.BOOLEAN) {
                JLabel lbl = new JLabel(params[i]);
                this.add(lbl);
            }
            String name = params[i];
            Object value = this.op.getParam(name);
            JComponent comp = null;
            switch (types[i]) {
                case BOOLEAN: {
                    JCheckBox cb = new JCheckBox(name);
                    if (value != null && value instanceof Boolean) {
                        cb.setSelected((Boolean)value);
                    }
                    cb.addChangeListener(this);
                    comp = cb;
                    break;
                }
                case FLOAT: {
                    SpinnerNumberModel model = new SpinnerNumberModel(0.0, -1000.0, 1000.0, 0.1);
                    JSpinner js = new JSpinner(model);
                    if (value != null && (value instanceof Integer || value instanceof Float || value instanceof Double)) {
                        js.setValue(value);
                    }
                    js.addChangeListener(this);
                    comp = js;
                    break;
                }
                case INTEGER: {
                    SpinnerNumberModel imodel = new SpinnerNumberModel(0, -1000, 1000, 1);
                    JSpinner jsi = new JSpinner(imodel);
                    if (value != null && value instanceof Integer) {
                        jsi.setValue(value);
                    }
                    jsi.addChangeListener(this);
                    comp = jsi;
                    break;
                }
                case STRING: {
                    JTextField tf = new JTextField(64);
                    if (value != null) {
                        tf.setText(value.toString());
                    }
                    tf.getDocument().addDocumentListener(this);
                    comp = tf;
                }
            }
            this.fields.put(name, comp);
            this.add(comp);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.autosave) {
            this.saveParams();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.autosave) {
            this.saveParams();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.autosave) {
            this.saveParams();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.autosave) {
            this.saveParams();
        }
    }
}

