/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.process;

import java.util.Map;
import java.util.Vector;
import javax.script.ScriptException;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.process.ScriptableProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIProcessor
extends ScriptableProcessor {
    private static Logger log = LoggerFactory.getLogger(GUIProcessor.class);
    private Vector<AreaTreeOperator> selectedOperators = new Vector();
    private Vector<Map<String, Object>> operatorParams = new Vector();
    private boolean configMode = false;

    public GUIProcessor() {
        this.loadConfig();
    }

    public Vector<AreaTreeOperator> getSelectedOperators() {
        return this.selectedOperators;
    }

    public Vector<Map<String, Object>> getOperatorParams() {
        return this.operatorParams;
    }

    public void loadConfig() {
        this.configMode = true;
        try {
            this.execInternal("default_operators.js");
        }
        catch (ScriptException e) {
            log.error("Couldn't load config: " + e.getMessage());
        }
        this.configMode = false;
    }

    @Override
    public AreaTree segmentPage() {
        if (!this.getAreaProviders().isEmpty()) {
            AreaTreeProvider provider = this.getAreaProviders().values().iterator().next();
            log.warn("Using default area tree provider " + provider.getId());
            return this.segmentPage(provider, null);
        }
        return null;
    }

    public AreaTree segmentPage(AreaTreeProvider provider, Map<String, Object> params) {
        this.setAreaTree(null);
        this.initAreaTree(provider, params);
        for (int i = 0; i < this.selectedOperators.size(); ++i) {
            this.apply(this.selectedOperators.elementAt(i), this.operatorParams.elementAt(i));
        }
        this.treesCompleted();
        return this.getAreaTree();
    }

    @Override
    public LogicalAreaTree buildLogicalTree() {
        if (!this.getAreaProviders().isEmpty()) {
            LogicalTreeProvider provider = this.getLogicalProviders().values().iterator().next();
            log.warn("Using default logical area tree provider " + provider.getId());
            return this.buildLogicalTree(provider, null);
        }
        return null;
    }

    public LogicalAreaTree buildLogicalTree(LogicalTreeProvider provider, Map<String, Object> params) {
        this.setLogicalAreaTree(null);
        this.initLogicalTree(provider, params);
        this.treesCompleted();
        return this.getLogicalAreaTree();
    }

    @Override
    public Page renderPage(String providerName, Map<String, Object> params) {
        if (!this.configMode) {
            return super.renderPage(providerName, params);
        }
        return this.getPage();
    }

    @Override
    public AreaTree initAreaTree(String providerName, Map<String, Object> params) {
        if (!this.configMode) {
            return super.initAreaTree(providerName, params);
        }
        return this.getAreaTree();
    }

    @Override
    public void apply(String operatorName, Map<String, Object> params) {
        if (!this.configMode) {
            super.apply(operatorName, params);
        } else {
            AreaTreeOperator op = this.getOperators().get(operatorName);
            if (op != null) {
                ServiceManager.setServiceParams((ParametrizedOperation)op, params);
                this.selectedOperators.add(op);
                this.operatorParams.add(ServiceManager.getServiceParams((ParametrizedOperation)op));
            }
        }
    }
}

