/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.BoxTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.OutputDisplay;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.process.BaseProcessor;
import org.fit.layout.tools.ImageOutputDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableProcessor
extends BaseProcessor {
    private static Logger log = LoggerFactory.getLogger(ScriptableProcessor.class);
    private BufferedReader rin = new BufferedReader(new InputStreamReader(System.in));
    private PrintWriter wout = new PrintWriter(System.out);
    private PrintWriter werr = new PrintWriter(System.err);
    private ScriptEngine engine;

    public List<String> getOperatorIds() {
        return new ArrayList<String>(this.getOperators().keySet());
    }

    public List<String> getBoxProviderIds() {
        return new ArrayList<String>(this.getBoxProviders().keySet());
    }

    public List<String> getAreaProviderIds() {
        return new ArrayList<String>(this.getAreaProviders().keySet());
    }

    public List<String> getLogicalProviderIds() {
        return new ArrayList<String>(this.getLogicalProviders().keySet());
    }

    public void setServiceParams(String serviceName, Map<String, Object> params) {
        ParametrizedOperation op = ServiceManager.findParmetrizedService((String)serviceName);
        if (op != null) {
            ServiceManager.setServiceParams((ParametrizedOperation)op, params);
        } else {
            log.error("setServiceParams: Unknown service: {}", (Object)serviceName);
        }
    }

    public Page renderPage(String providerName, Map<String, Object> params) {
        BoxTreeProvider provider = this.getBoxProviders().get(providerName);
        if (provider != null) {
            return this.renderPage(provider, params);
        }
        log.error("Unknown box tree provider: " + providerName);
        return null;
    }

    public AreaTree initAreaTree(String providerName, Map<String, Object> params) {
        AreaTreeProvider provider = this.getAreaProviders().get(providerName);
        if (provider != null) {
            return this.initAreaTree(provider, params);
        }
        log.error("Unknown area tree provider: " + providerName);
        return null;
    }

    public void apply(String operatorName, Map<String, Object> params) {
        AreaTreeOperator op = this.getOperators().get(operatorName);
        if (op != null) {
            this.apply(op, params);
        } else {
            log.error("Unknown operator " + operatorName);
        }
    }

    public LogicalAreaTree initLogicalTree(String providerName, Map<String, Object> params) {
        LogicalTreeProvider provider = this.getLogicalProviders().get(providerName);
        if (provider != null) {
            return this.initLogicalTree(provider, params);
        }
        log.error("Unknown logical tree provider: " + providerName);
        return null;
    }

    @Override
    public AreaTree segmentPage() {
        try {
            this.setAreaTree(null);
            this.execInternal("default_segm.js");
        }
        catch (ScriptException e) {
            log.error("Couldn't execute default segmentation script: " + e.getMessage());
        }
        this.treesCompleted();
        return this.getAreaTree();
    }

    @Override
    public LogicalAreaTree buildLogicalTree() {
        try {
            this.setLogicalAreaTree(null);
            this.execInternal("default_logical.js");
        }
        catch (ScriptException e) {
            log.error("Couldn't execute default segmentation script: " + e.getMessage());
        }
        this.treesCompleted();
        return this.getLogicalAreaTree();
    }

    public void drawToImage(String path) {
        try {
            ImageOutputDisplay disp = new ImageOutputDisplay(this.getPage().getWidth(), this.getPage().getHeight());
            disp.drawPage(this.getPage());
            disp.saveTo(path);
        }
        catch (IOException e) {
            log.error("Couldn't write to " + path + ": " + e.getMessage());
        }
    }

    public void drawToImageWithAreas(String path, String areaNames) {
        try {
            ImageOutputDisplay disp = new ImageOutputDisplay(this.getPage().getWidth(), this.getPage().getHeight());
            disp.drawPage(this.getPage());
            this.showAreas(disp, this.getAreaTree().getRoot(), areaNames);
            disp.saveTo(path);
        }
        catch (IOException e) {
            log.error("Couldn't write to " + path + ": " + e.getMessage());
        }
    }

    private void showAreas(OutputDisplay disp, Area root, String nameSubstring) {
        if (nameSubstring == null || root.toString().contains(nameSubstring)) {
            disp.drawExtent(root);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.showAreas(disp, (Area)root.getChildArea(i), nameSubstring);
        }
    }

    protected ScriptEngine getEngine() {
        if (this.engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("JavaScript");
            this.engine.put("proc", this);
            try {
                this.engine.eval("if (typeof println == 'undefined') this.println = print;");
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            Map scriptObjects = ServiceManager.findScriptObjects();
            for (Map.Entry obj : scriptObjects.entrySet()) {
                this.engine.put((String)obj.getKey(), obj.getValue());
            }
        }
        return this.engine;
    }

    public void setIO(Reader in, Writer out, Writer err) {
        this.rin = new BufferedReader(in);
        this.wout = new PrintWriter(out);
        this.werr = new PrintWriter(err);
        ScriptContext ctx = this.getEngine().getContext();
        ctx.setReader(this.rin);
        ctx.setWriter(this.wout);
        ctx.setErrorWriter(this.werr);
        for (ScriptObject obj : ServiceManager.findScriptObjects().values()) {
            obj.setIO(in, out, err);
        }
    }

    public void flushIO() {
        this.wout.flush();
        this.werr.flush();
    }

    public void put(String var, Object obj) {
        this.getEngine().put(var, obj);
    }

    public boolean execInternal(String scriptName) throws ScriptException {
        InputStream is;
        if (!scriptName.startsWith("/")) {
            scriptName = "/" + scriptName;
        }
        if ((is = ScriptableProcessor.class.getResourceAsStream(scriptName)) != null) {
            this.getEngine().eval(new InputStreamReader(is));
            return true;
        }
        log.error("Couldn't access internal script " + scriptName);
        return false;
    }

    public boolean execCommand(String command) throws ScriptException {
        this.getEngine().eval(command);
        return true;
    }
}

