/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.fit.layout.model.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderStroke
implements Stroke {
    private static Logger log = LoggerFactory.getLogger(BorderStroke.class);
    private int width;
    private Border.Style style;
    private boolean reverse;

    public BorderStroke(int width, Border.Style style, boolean reverse) {
        this.width = width;
        this.style = style;
        this.reverse = reverse;
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            int x1 = (int)l.getX1();
            int y1 = (int)l.getY1();
            int x2 = (int)l.getX2();
            int y2 = (int)l.getY2();
            if (y1 == y2 && x2 > x1) {
                return this.sideShape(x1, y1, x2 - x1 + 1, this.width, false);
            }
            if (x1 == x2 && y2 > y1) {
                return this.sideShape(x1, y1, y2 - y1 + 1, this.width, true);
            }
            return this.basicStrokeShape(s);
        }
        return this.basicStrokeShape(s);
    }

    private GeneralPath sideShape(int x, int y, int len, int width, boolean vert) {
        GeneralPath ret;
        if (!vert) {
            if (this.style == Border.Style.DASHED || this.style == Border.Style.DOTTED) {
                int r = this.style == Border.Style.DASHED ? 3 : 1;
                ret = null;
                for (int i = 0; i < len; i += width * (r + 1)) {
                    int l = width * r;
                    if (i + l >= len) {
                        l = len - i;
                    }
                    ret = this.append(ret, new Rectangle(x + i, y, l, width));
                }
            } else if (this.style == Border.Style.DOUBLE && width >= 3) {
                int w = (width + 2) / 3;
                int space = width - 2 * w;
                if (!this.reverse) {
                    ret = new GeneralPath(new Rectangle(x, y, len, w));
                    ret.append(new Rectangle(x + w + space, y + w + space, len - 2 * (w + space), w), false);
                } else {
                    ret = new GeneralPath(new Rectangle(x + w + space, y, len - 2 * (w + space), w));
                    ret.append(new Rectangle(x, y + w + space, len, w), false);
                }
            } else {
                ret = new GeneralPath(new Rectangle(x, y, len, width));
            }
        } else if (this.style == Border.Style.DASHED || this.style == Border.Style.DOTTED) {
            int r = this.style == Border.Style.DASHED ? 3 : 1;
            ret = null;
            for (int i = 0; i < len; i += width * (r + 1)) {
                int l = width * r;
                if (i + l >= len) {
                    l = len - i;
                }
                ret = this.append(ret, new Rectangle(x, y + i, width, l));
            }
        } else if (this.style == Border.Style.DOUBLE && width >= 3) {
            int w = (width + 2) / 3;
            int space = width - 2 * w;
            if (!this.reverse) {
                ret = new GeneralPath(new Rectangle(x, y, w, len));
                ret.append(new Rectangle(x + w + space, y + w + space, w, len - 2 * (w + space)), false);
            } else {
                ret = new GeneralPath(new Rectangle(x, y + w + space, w, len - 2 * (w + space)));
                ret.append(new Rectangle(x + w + space, y, w, len), false);
            }
        } else {
            ret = new GeneralPath(new Rectangle(x, y, width, len));
        }
        return ret;
    }

    private GeneralPath append(GeneralPath src, Shape s) {
        if (src == null) {
            return new GeneralPath(s);
        }
        src.append(s, false);
        return src;
    }

    private Shape basicStrokeShape(Shape s) {
        log.debug("Warning: BorderStroke: fallback to BasicStroke");
        BasicStroke bas = new BasicStroke(this.width, 0, 0, this.width);
        return bas.createStrokedShape(s);
    }
}

