/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tools.io;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.Vector;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;

public class XMLOutputOperator
extends BaseOperator {
    protected boolean produceHeader;
    protected String filename;
    protected final String[] paramNames = new String[]{"filename", "produceHeader"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.BOOLEAN};
    private int idcnt = 0;

    public XMLOutputOperator() {
        this.produceHeader = false;
        this.filename = "out.xml";
    }

    public XMLOutputOperator(String filename, boolean produceHeader) {
        this.filename = filename;
        this.produceHeader = produceHeader;
    }

    public String getId() {
        return "FitLayout.Tools.XMLOutput";
    }

    public String getName() {
        return "XML serialization of the area tree";
    }

    public String getDescription() {
        return "Serializes the area tree to an XML file";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public boolean getProduceHeader() {
        return this.produceHeader;
    }

    public void setProduceHeader(boolean produceHeader) {
        this.produceHeader = produceHeader;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        try {
            PrintWriter out = new PrintWriter(this.filename);
            this.dumpTo(atree, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't create output XML file " + this.filename);
        }
    }

    public void dumpTo(AreaTree tree, PrintWriter out) {
        if (this.produceHeader) {
            out.println("<?xml version=\"1.0\"?>");
        }
        out.println("<areaTree base=\"" + this.HTMLEntities(tree.getRoot().getPage().getSourceURL().toString()) + "\">");
        this.recursiveDump(tree.getRoot(), 1, out);
        out.println("</areaTree>");
    }

    private void recursiveDump(Area a, int level, PrintWriter p) {
        String stag = "<area id=\"x" + this.idcnt++ + "\" x1=\"" + a.getX1() + "\" y1=\"" + a.getY1() + "\" x2=\"" + a.getX2() + "\" y2=\"" + a.getY2() + "\" background=\"" + this.colorString(a.getBackgroundColor()) + "\" fontsize=\"" + a.getFontSize() + "\" fontweight=\"" + a.getFontWeight() + "\" fontstyle=\"" + a.getFontStyle() + "\" tags=\"" + this.tagString(a.getTags().keySet()) + "\">";
        String etag = "</area>";
        if (a.getChildCount() > 0) {
            this.indent(level, p);
            p.println(stag);
            for (int i = 0; i < a.getChildCount(); ++i) {
                this.recursiveDump((Area)a.getChildArea(i), level + 1, p);
            }
            this.indent(level, p);
            p.println(etag);
        } else {
            this.indent(level, p);
            p.println(stag);
            this.dumpBoxes(a, p, level + 1);
            this.indent(level, p);
            p.println(etag);
        }
    }

    private void dumpBoxes(Area a, PrintWriter p, int level) {
        Vector boxes = a.getBoxes();
        for (Box box : boxes) {
            Rectangular pos = box.getVisualBounds();
            this.indent(level, p);
            String stag = "<box x1=\"" + pos.getX1() + "\" y1=\"" + pos.getY1() + "\" x2=\"" + pos.getX2() + "\" y2=\"" + pos.getY2() + "\" color=\"" + this.colorString(box.getColor()) + "\" fontfamily=\"" + box.getFontFamily() + "\" fontsize=\"" + box.getFontSize() + "\" fontweight=\"" + box.getFontWeight() + "\" fontstyle=\"" + box.getFontStyle() + "\" underline=\"" + box.getUnderline() + "\" linethrough=\"" + box.getLineThrough() + "\" replaced=\"" + (box.getType() == Box.Type.REPLACED_CONTENT ? "true" : "false") + "\">";
            p.print(stag);
            p.print(this.HTMLEntities(box.getText()));
            p.println("</box>");
        }
    }

    private void indent(int level, PrintWriter p) {
        String ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = ind + ' ';
        }
        p.print(ind);
    }

    private String colorString(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public String colorString(String spec) {
        if (spec.startsWith("rgb(")) {
            String s = spec.substring(4, spec.length() - 1);
            String[] lst = s.split(",");
            try {
                int r = Integer.parseInt(lst[0].trim());
                int g = Integer.parseInt(lst[1].trim());
                int b = Integer.parseInt(lst[2].trim());
                return String.format("#%02x%02x%02x", r, g, b);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return spec;
    }

    private String tagString(Set<Tag> tags) {
        String ret = "";
        for (Tag tag : tags) {
            ret = ret + tag + " ";
        }
        return ret.trim();
    }

    private String HTMLEntities(String s) {
        return s.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("&", "&amp;");
    }
}

