/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.sa.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.gui.RectangleSelectionListener;
import org.fit.layout.gui.TreeListener;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.impl.DefaultAreaTree;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.sa.op.GroupByExampleOperator;

public class AnnotatorPlugin
implements BrowserPlugin,
RectangleSelectionListener,
TreeListener,
AreaSelectionListener {
    private Browser browser;
    private Rectangular lastSelection = new Rectangular();
    private Area selectedParent;
    private JPanel mainPanel;
    private JToggleButton annotateButton;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolPanel("Segment Annotator", (JComponent)this.getMainPanel());
        this.browser.addTreeListener((TreeListener)this);
        this.browser.addAreaSelectionListener((AreaSelectionListener)this);
        return true;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            GridBagLayout gbl_mainPanel = new GridBagLayout();
            this.mainPanel.setLayout(gbl_mainPanel);
            JPanel toolPanel = new JPanel();
            GridBagConstraints gbc_toolPanel = new GridBagConstraints();
            gbc_toolPanel.insets = new Insets(0, 0, 5, 5);
            gbc_toolPanel.fill = 1;
            gbc_toolPanel.gridx = 0;
            gbc_toolPanel.gridy = 0;
            this.mainPanel.add((Component)toolPanel, gbc_toolPanel);
            GridBagLayout gbl_toolPanel = new GridBagLayout();
            gbl_toolPanel.columnWidths = new int[]{100, 0};
            gbl_toolPanel.rowHeights = new int[]{25, 0, 0};
            gbl_toolPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_toolPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            toolPanel.setLayout(gbl_toolPanel);
            GridBagConstraints gbc_annotateButton = new GridBagConstraints();
            gbc_annotateButton.fill = 2;
            gbc_annotateButton.insets = new Insets(0, 0, 5, 0);
            gbc_annotateButton.anchor = 18;
            gbc_annotateButton.gridx = 0;
            gbc_annotateButton.gridy = 0;
            toolPanel.add((Component)this.getAnnotateButton(), gbc_annotateButton);
            JButton addButton = new JButton("Add");
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnnotatorPlugin.this.addAreaFromSelection();
                }
            });
            GridBagConstraints gbc_addButton = new GridBagConstraints();
            gbc_addButton.fill = 2;
            gbc_addButton.gridx = 0;
            gbc_addButton.gridy = 1;
            toolPanel.add((Component)addButton, gbc_addButton);
            JScrollPane tableScrollPane = new JScrollPane();
            GridBagConstraints gbc_tableScrollPane = new GridBagConstraints();
            gbc_tableScrollPane.weightx = 1.0;
            gbc_tableScrollPane.insets = new Insets(0, 0, 5, 0);
            gbc_tableScrollPane.fill = 1;
            gbc_tableScrollPane.gridx = 1;
            gbc_tableScrollPane.gridy = 0;
            this.mainPanel.add((Component)tableScrollPane, gbc_tableScrollPane);
            JList areaList = new JList();
            tableScrollPane.setViewportView(areaList);
            JPanel propertyPanel = new JPanel();
            GridBagConstraints gbc_propertyPanel = new GridBagConstraints();
            gbc_propertyPanel.insets = new Insets(0, 0, 0, 5);
            gbc_propertyPanel.fill = 1;
            gbc_propertyPanel.gridx = 2;
            gbc_propertyPanel.gridy = 0;
            this.mainPanel.add((Component)propertyPanel, gbc_propertyPanel);
            GridBagLayout gbl_propertyPanel = new GridBagLayout();
            gbl_propertyPanel.columnWidths = new int[]{0, 0};
            gbl_propertyPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
            gbl_propertyPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_propertyPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            propertyPanel.setLayout(gbl_propertyPanel);
            JButton deleteButton = new JButton("Delete");
            GridBagConstraints gbc_deleteButton = new GridBagConstraints();
            gbc_deleteButton.insets = new Insets(0, 0, 5, 0);
            gbc_deleteButton.fill = 1;
            gbc_deleteButton.gridx = 0;
            gbc_deleteButton.gridy = 0;
            propertyPanel.add((Component)deleteButton, gbc_deleteButton);
            JButton useAsExampleButton = new JButton("Use Ex.");
            useAsExampleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AnnotatorPlugin.this.useForSegmentator();
                }
            });
            GridBagConstraints gbc_useAsExampleButton = new GridBagConstraints();
            gbc_useAsExampleButton.gridx = 0;
            gbc_useAsExampleButton.gridy = 3;
            propertyPanel.add((Component)useAsExampleButton, gbc_useAsExampleButton);
        }
        return this.mainPanel;
    }

    private JToggleButton getAnnotateButton() {
        if (this.annotateButton == null) {
            this.annotateButton = new JToggleButton("Annotate");
            this.annotateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AnnotatorPlugin.this.annotateButton.isSelected()) {
                        AnnotatorPlugin.this.startSelection();
                    } else {
                        AnnotatorPlugin.this.stopSelection();
                    }
                }
            });
        }
        return this.annotateButton;
    }

    public void pageRendered(Page page) {
        if (this.browser.getAreaTree() == null) {
            DefaultAreaTree atree = new DefaultAreaTree(this.browser.getPage());
            DefaultArea root = new DefaultArea(this.browser.getPage().getRoot());
            root.setName("Root area");
            atree.setRoot((Area)root);
            this.selectedParent = root;
            this.browser.setAreaTree((AreaTree)atree);
            this.browser.refreshView();
        }
    }

    public void areaTreeUpdated(AreaTree tree) {
    }

    public void logicalAreaTreeUpdated(LogicalAreaTree tree) {
    }

    public void areaSelected(Area area) {
        this.selectedParent = area;
    }

    public void rectangleCreated(Rectangular rect) {
        this.browser.clearSelection();
        Rectangular r = this.findSelectedRectangle(rect);
        if (r != null) {
            this.browser.setSelection(r);
        } else {
            this.browser.clearSelection();
        }
        this.lastSelection = r;
    }

    private void startSelection() {
        this.browser.addRectangleSelectionListener((RectangleSelectionListener)this);
    }

    private void stopSelection() {
        this.browser.removeRectangleSelectionListener((RectangleSelectionListener)this);
    }

    private void addAreaFromSelection() {
        if (this.lastSelection != null && this.selectedParent != null) {
            Vector boxes = this.browser.getPage().getBoxesInRegion(this.lastSelection);
            if (!boxes.isEmpty()) {
                if (this.selectedParent instanceof DefaultArea) {
                    ((DefaultArea)this.selectedParent).removeBoxes((Collection)boxes);
                    DefaultArea newarea = new DefaultArea((List)boxes);
                    ((DefaultArea)this.selectedParent).appendChild((Area)newarea);
                } else {
                    this.browser.displayErrorMessage("Cannot add areas to this type of nodes");
                }
            }
            this.browser.refreshView();
        } else {
            this.browser.displayErrorMessage("No parent area is selected.");
        }
    }

    private Rectangular findSelectedRectangle(Rectangular sel) {
        Rectangular r = null;
        Vector boxes = this.browser.getPage().getBoxesInRegion(sel);
        System.out.println("Boxes: " + boxes);
        for (Box box : boxes) {
            if (!box.isVisible()) continue;
            if (r == null) {
                r = new Rectangular(box.getVisualBounds());
                continue;
            }
            r.expandToEnclose(box.getVisualBounds());
        }
        return r;
    }

    private void useForSegmentator() {
        ParametrizedOperation op = ServiceManager.findParmetrizedService((String)"FitLayout.Segm.GroupByExample");
        if (op != null && op instanceof GroupByExampleOperator) {
            ((GroupByExampleOperator)op).setExampleTree(this.browser.getAreaTree());
            this.browser.displayInfoMessage("Segmentator configured successfully");
        } else {
            this.browser.displayErrorMessage("Group by example operator is not available. Check your build configuration.");
        }
    }
}

