/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.sa.op;

import java.util.ArrayList;
import java.util.List;
import org.fit.layout.model.Box;
import org.fit.layout.sa.op.BoxSignature;

public class AreaPattern {
    private BoxSignature rootSignature;
    private List<BoxSignature> groupSignatures;
    private int fontSize;

    public AreaPattern(BoxSignature rootSignature) {
        this.rootSignature = rootSignature;
        this.groupSignatures = new ArrayList<BoxSignature>();
    }

    public AreaPattern(BoxSignature rootSignature, List<BoxSignature> groupSignatures) {
        this.rootSignature = rootSignature;
        this.groupSignatures = groupSignatures;
    }

    public String toString() {
        return "{" + this.fontSize + "}" + this.rootSignature.toString() + this.groupSignatures.toString();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public BoxSignature getRootSignature() {
        return this.rootSignature;
    }

    public void setRootSignature(BoxSignature rootSignature) {
        this.rootSignature = rootSignature;
    }

    public List<BoxSignature> getGroupSignatures() {
        return this.groupSignatures;
    }

    public void setGroupSignatures(List<BoxSignature> groupSignatures) {
        this.groupSignatures = groupSignatures;
    }

    public void addGroupSignature(BoxSignature sig) {
        this.groupSignatures.add(sig);
    }

    public int getGroupCount() {
        return this.groupSignatures.size();
    }

    public boolean matchesRoot(Box box) {
        return this.rootSignature.matches(box);
    }

    public boolean matchesStart(Box box) {
        if (this.fontSize == AreaPattern.getStartingFontSize(box)) {
            if (!this.groupSignatures.isEmpty()) {
                BoxSignature sig = this.groupSignatures.get(0);
                return sig.matches(box);
            }
            return false;
        }
        return false;
    }

    public boolean matchesEnd(Box box) {
        if (!this.groupSignatures.isEmpty()) {
            BoxSignature sig = this.groupSignatures.get(this.groupSignatures.size() - 1);
            return sig.matches(box);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AreaPattern) {
            AreaPattern other = (AreaPattern)obj;
            if (this.fontSize != other.fontSize) {
                return false;
            }
            if (!this.rootSignature.equalsExactly(other.rootSignature)) {
                return false;
            }
            if (this.groupSignatures.size() != other.groupSignatures.size()) {
                return false;
            }
            for (int i = 0; i < this.groupSignatures.size(); ++i) {
                BoxSignature s2;
                BoxSignature s1 = this.groupSignatures.get(i);
                if (s1.equalsNoIndex(s2 = other.groupSignatures.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Box getFirstTextLeaf(Box root) {
        if (root.getChildCount() == 0) {
            if (root.getText().isEmpty()) {
                return null;
            }
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            Box ret = AreaPattern.getFirstTextLeaf(root.getChildBox(i));
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static int getStartingFontSize(Box root) {
        Box leaf = AreaPattern.getFirstTextLeaf(root);
        return leaf == null ? 0 : Math.round(leaf.getFontSize());
    }
}

