/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.sa.op;

import java.util.ArrayList;
import java.util.List;
import org.fit.layout.model.Box;

public class BoxSignature {
    private String pId;
    private String pClass;
    private String pBlock;
    private String boxName;
    private String boxId;
    private String boxClass;
    private int boxIndex;
    private int pClassIndex;
    private int pBlockIndex;

    public BoxSignature(Box src) {
        this.computeSignature(src);
    }

    public String toString() {
        String ret = "<#" + (this.pId == null ? "*" : this.pId);
        ret = ret + "|." + (this.pClass == null ? "*" : this.pClass) + ":" + this.pClassIndex;
        ret = ret + "|" + (this.pBlock == null ? "*" : this.pBlock) + ":" + this.pBlockIndex;
        ret = ret + ">/<";
        ret = ret + this.boxName;
        if (this.boxId != null) {
            ret = ret + "#" + this.boxId;
        }
        if (this.boxClass != null) {
            ret = ret + "." + this.boxClass;
        }
        ret = ret + ":" + this.boxIndex;
        ret = ret + ">";
        return ret;
    }

    public boolean matches(Box other) {
        return this.matches(new BoxSignature(other));
    }

    public boolean matches(BoxSignature sig) {
        return !(!this.boxMatches(sig.boxName, sig.boxId, sig.boxClass) || !this.parentsMatch(sig.pBlock, sig.pId, sig.pClass) || sig.pBlock != null && sig.pBlockIndex != this.pBlockIndex || sig.pClass != null && sig.pClassIndex != this.pClassIndex);
    }

    public boolean equalsExactly(BoxSignature other) {
        return this.equalsNoIndex(other) && this.boxIndex == other.boxIndex;
    }

    public boolean equalsNoIndex(BoxSignature other) {
        if (this.boxClass == null ? other.boxClass != null : !this.boxClass.equals(other.boxClass)) {
            return false;
        }
        if (this.boxId == null ? other.boxId != null : !this.boxId.equals(other.boxId)) {
            return false;
        }
        if (this.boxName == null ? other.boxName != null : !this.boxName.equals(other.boxName)) {
            return false;
        }
        if (this.pBlock == null ? other.pBlock != null : !this.pBlock.equals(other.pBlock)) {
            return false;
        }
        if (this.pBlockIndex != other.pBlockIndex) {
            return false;
        }
        if (this.pClass == null ? other.pClass != null : !this.pClass.equals(other.pClass)) {
            return false;
        }
        if (this.pClassIndex != other.pClassIndex) {
            return false;
        }
        return !(this.pId == null ? other.pId != null : !this.pId.equals(other.pId));
    }

    private void computeSignature(Box src) {
        this.boxName = src.getTagName();
        if (this.boxName == null) {
            this.boxName = "";
        }
        this.boxId = src.getAttribute("id");
        this.boxClass = src.getAttribute("class");
        if (src.getParentBox() != null) {
            this.boxIndex = this.computeBoxIndex(src.getParentBox(), src);
        }
        List<Box> anc = this.getAncestors(src);
        for (Box box : anc) {
            if (this.pId == null && box.getAttribute("id") != null) {
                this.pId = box.getAttribute("id");
            }
            if (this.pClass == null && box.getParentBox() != null && box.getAttribute("class") != null) {
                this.pClass = box.getAttribute("class");
                if (box.getParentBox() != null) {
                    this.pClassIndex = this.computeClassIndex(box.getParentBox(), box, this.pClass);
                }
            }
            if (this.pBlock != null || box.getDisplayType() != Box.DisplayType.BLOCK) continue;
            this.pBlock = box.getTagName();
            if (box.getParentBox() == null) continue;
            this.pBlockIndex = this.computeNameIndex(box.getParentBox(), box, this.pBlock);
        }
    }

    private boolean boxMatches(String name, String id, String cls) {
        return this.boxName.equals(name) && (this.boxId == null && id == null || this.boxId != null && id != null && this.boxId.equals(id)) && (this.boxClass == null && cls == null || this.boxClass != null && cls != null && this.boxClass.equals(cls));
    }

    private boolean parentsMatch(String block, String id, String cls) {
        return (this.pBlock == null && block == null || this.pBlock != null && block != null && this.pBlock.equals(block)) && (this.pId == null && id == null || this.pId != null && id != null && this.pId.equals(id)) && (this.pClass == null && cls == null || this.pClass != null && cls != null && this.pClass.equals(cls));
    }

    private int computeBoxIndex(Box parent, Box search) {
        int cnt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            String cls;
            String id;
            Box src = parent.getChildBox(i);
            String name = src.getTagName();
            if (this.boxMatches(name, id = src.getAttribute("id"), cls = src.getAttribute("class"))) {
                ++cnt;
            }
            if (search != null && src == search) break;
        }
        return cnt;
    }

    private int computeClassIndex(Box parent, Box search, String clsname) {
        int cnt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Box src = parent.getChildBox(i);
            String cls = src.getAttribute("class");
            if (cls != null && cls.equals(clsname)) {
                ++cnt;
            }
            if (search != null && src == search) break;
        }
        return cnt;
    }

    private int computeNameIndex(Box parent, Box search, String name) {
        int cnt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Box src = parent.getChildBox(i);
            String tagname = src.getTagName();
            if (tagname != null && tagname.equals(name)) {
                ++cnt;
            }
            if (search != null && src == search) break;
        }
        return cnt;
    }

    private List<Box> getAncestors(Box box) {
        ArrayList<Box> ret = new ArrayList<Box>();
        Box cur = box;
        while (cur.getParentBox() != null) {
            cur = cur.getParentBox();
            ret.add(cur);
        }
        return ret;
    }
}

