/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.sa.op;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.sa.op.AreaPattern;
import org.fit.layout.sa.op.BoxSignature;
import org.fit.layout.sa.op.PatternMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByExampleOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(GroupByExampleOperator.class);
    private AreaTree exampleTree;
    private List<AreaPattern> patterns = new ArrayList<AreaPattern>();
    private List<List<Area>> groupsFound = new ArrayList<List<Area>>();

    public String getId() {
        return "FitLayout.Segm.GroupByExample";
    }

    public String getName() {
        return "Group by example";
    }

    public String getDescription() {
        return "...";
    }

    public String getCategory() {
        return "restructure";
    }

    public AreaTree getExampleTree() {
        return this.exampleTree;
    }

    public void setExampleTree(AreaTree exampleTree) {
        this.exampleTree = exampleTree;
        this.patterns.clear();
        this.recursiveAnalyzeAreas(exampleTree.getRoot());
        log.info("{} patterns collected", (Object)this.patterns.size());
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.groupsFound.clear();
        ArrayList<Area> leaves = new ArrayList<Area>();
        this.findLeafAreas(root, leaves);
        int cnf = this.doScan(atree, leaves);
        ArrayList<List<Area>> trialDest = new ArrayList<List<Area>>();
        List<PatternMatch> matches = this.scanForMatches(atree, leaves, cnf, trialDest, true, null);
        this.scanForMatches(atree, leaves, cnf, this.groupsFound, false, matches);
        System.out.println("Found " + this.groupsFound.size() + " matches");
        root.updateTopologies();
        for (List<Area> group : this.groupsFound) {
            this.createSuperArea(group);
        }
    }

    private int doScan(AreaTree atree, List<Area> leaves) {
        for (int i = 0; i < 50; ++i) {
            ArrayList<List<Area>> dest2 = new ArrayList<List<Area>>();
            ArrayList<List<Area>> dest1 = new ArrayList<List<Area>>();
            List<PatternMatch> pool = this.scanForMatches(atree, leaves, i, dest1, true, null);
            List<PatternMatch> matches = this.scanForMatches(atree, leaves, i, dest2, true, pool);
            if (matches != null && !matches.isEmpty()) {
                log.trace("#{} valid, {} matches", (Object)i, (Object)matches.size());
                return i;
            }
            log.trace("#{} invalid (overlap)", (Object)i);
        }
        return 0;
    }

    private List<PatternMatch> scanForMatches(AreaTree atree, List<Area> leaves, int config, List<List<Area>> dest, boolean trial, List<PatternMatch> matchPool) {
        ArrayList<PatternMatch> ret = new ArrayList<PatternMatch>(20);
        Iterator<PatternMatch> poolIt = null;
        if (matchPool != null) {
            poolIt = matchPool.iterator();
        }
        int mode = 0;
        PatternMatch curmatch = null;
        PatternMatch endmatch = null;
        ArrayList<Area> newgroup = null;
        Area area = null;
        Iterator<Area> it = leaves.iterator();
        while (it.hasNext()) {
            if (area == null) {
                area = it.next();
            }
            for (Box box : area.getBoxes()) {
                switch (mode) {
                    case 0: {
                        PatternMatch ematch;
                        ArrayList<PatternMatch> matches = new ArrayList<PatternMatch>();
                        this.recursiveFindAllMatches(box, true, matches);
                        PatternMatch match = null;
                        if (!matches.isEmpty()) {
                            int pi = config % matches.size();
                            config /= matches.size();
                            match = matchPool == null ? (PatternMatch)matches.get(pi) : poolIt.next();
                            ret.add(match);
                        }
                        if (match != null) {
                            newgroup = new ArrayList();
                            if (match.getBox() != box) {
                                Area matcharea = atree.createArea(match.getBox());
                                newgroup.add(matcharea);
                                if (!trial) {
                                    Area parent = (Area)area.getParentArea();
                                    parent.appendChild((Object)matcharea);
                                    parent.removeChild((Object)area);
                                }
                            } else {
                                newgroup.add(area);
                            }
                            curmatch = match;
                            mode = 1;
                        } else if (curmatch != null && (ematch = this.recursiveScanBoxTree(box, false, curmatch.getPattern())) != null) {
                            curmatch.getPairs().add(ematch);
                        }
                        area = null;
                        break;
                    }
                    case 1: {
                        if (!this.isAncestorOrSelf(curmatch.getBox(), box)) {
                            if (curmatch.getPattern().getGroupCount() == 1) {
                                mode = 0;
                                dest.add(newgroup);
                                newgroup = new ArrayList();
                                break;
                            }
                            mode = 2;
                            break;
                        }
                        if (!trial) {
                            ((Area)area.getParentArea()).removeChild((Object)area);
                        }
                        area = null;
                        break;
                    }
                    case 2: {
                        endmatch = this.recursiveScanBoxTree(box, false, curmatch.getPattern());
                        if (endmatch != null && matchPool != null) {
                            endmatch = endmatch.getBox() == curmatch.getLastPair().getBox() ? curmatch.getLastPair() : null;
                        }
                        if (endmatch != null) {
                            curmatch.getPairs().add(endmatch);
                            if (endmatch.getBox() != box) {
                                Area matcharea = atree.createArea(endmatch.getBox());
                                newgroup.add(matcharea);
                                if (!trial) {
                                    Area oldparent = (Area)area.getParentArea();
                                    oldparent.appendChild((Object)matcharea);
                                    oldparent.removeChild((Object)area);
                                }
                            } else {
                                newgroup.add(area);
                            }
                            mode = 3;
                        } else if (this.findRootMatch(box, curmatch.getPattern()) != null) {
                            newgroup.add(area);
                        } else if (!newgroup.isEmpty()) {
                            dest.add(newgroup);
                            newgroup = new ArrayList();
                            mode = 0;
                        }
                        area = null;
                        break;
                    }
                    case 3: {
                        if (!this.isAncestorOrSelf(endmatch.getBox(), box)) {
                            dest.add((List<Area>)newgroup);
                            newgroup = new ArrayList<Area>();
                            mode = 0;
                            break;
                        }
                        if (!trial) {
                            ((Area)area.getParentArea()).removeChild((Object)area);
                        }
                        area = null;
                    }
                }
            }
        }
        if (newgroup != null && !newgroup.isEmpty()) {
            dest.add((List<Area>)newgroup);
        }
        if (trial) {
            ArrayList<Rectangular> groups = new ArrayList<Rectangular>(dest.size());
            for (List<Area> group : dest) {
                groups.add(this.computeGroupBounds(group));
            }
            if (this.checkOverlaps(groups)) {
                return null;
            }
        }
        return ret;
    }

    private void recursiveFindAllMatches(Box box, boolean start, List<PatternMatch> dest) {
        List<AreaPattern> list = this.findAllMatches(box, start);
        for (AreaPattern pat : list) {
            dest.add(new PatternMatch(pat, box));
        }
        if (box.getParentBox() != null) {
            this.recursiveFindAllMatches(box.getParentBox(), start, dest);
        }
    }

    private PatternMatch recursiveScanBoxTree(Box box, boolean start) {
        AreaPattern pat = this.findMatch(box, start);
        if (pat != null) {
            return new PatternMatch(pat, box);
        }
        if (box.getParentBox() != null) {
            return this.recursiveScanBoxTree(box.getParentBox(), start);
        }
        return null;
    }

    private PatternMatch recursiveScanBoxTree(Box box, boolean start, AreaPattern pattern) {
        AreaPattern pat = this.findMatch(box, start, pattern);
        if (pat != null) {
            return new PatternMatch(pat, box);
        }
        if (box.getParentBox() != null) {
            return this.recursiveScanBoxTree(box.getParentBox(), start, pattern);
        }
        return null;
    }

    private List<AreaPattern> findAllMatches(Box box, boolean start) {
        if (box.getParentBox() != null) {
            ArrayList<AreaPattern> ret = new ArrayList<AreaPattern>();
            for (AreaPattern pat : this.patterns) {
                if (this.findRootMatch(box, pat) == null || (!start || !pat.matchesStart(box)) && (start || !pat.matchesEnd(box))) continue;
                ret.add(pat);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private AreaPattern findMatch(Box box, boolean start) {
        if (box.getParentBox() != null) {
            AreaPattern ret = null;
            int cnt = 0;
            for (AreaPattern pat : this.patterns) {
                if (this.findRootMatch(box, pat) == null || (!start || !pat.matchesStart(box)) && (start || !pat.matchesEnd(box))) continue;
                ret = pat;
                ++cnt;
                System.out.println("Found " + pat);
            }
            if (cnt > 1) {
                System.out.println(" Multiple matches " + cnt + " for " + box);
            }
            return ret;
        }
        return null;
    }

    private AreaPattern findMatch(Box box, boolean start, AreaPattern pat) {
        if (box.getParentBox() != null) {
            if (this.findRootMatch(box, pat) != null && (start && pat.matchesStart(box) || !start && pat.matchesEnd(box))) {
                return pat;
            }
            return null;
        }
        return null;
    }

    private Box findRootMatch(Box box, AreaPattern pat) {
        Box cur = box;
        while (cur.getParentBox() != null) {
            if (!pat.matchesRoot(cur = cur.getParentBox())) continue;
            return cur;
        }
        return null;
    }

    private void findLeafAreas(Area root, List<Area> leaves) {
        if (root.isLeaf()) {
            leaves.add(root);
        } else {
            for (Area child : root.getChildAreas()) {
                this.findLeafAreas(child, leaves);
            }
        }
    }

    private boolean isAncestorOrSelf(Box anc, Box box) {
        for (Box cur = box; cur != null; cur = cur.getParentBox()) {
            if (cur != anc) continue;
            return true;
        }
        return false;
    }

    private boolean checkOverlaps(List<Rectangular> list) {
        for (Rectangular r1 : list) {
            for (Rectangular r2 : list) {
                if (r1 == r2 || !r1.intersects(r2)) continue;
                log.trace("OVERLAP {} x {}", (Object)r1, (Object)r2);
                return true;
            }
        }
        return false;
    }

    private void createSuperArea(List<Area> group) {
        if (group.get(0).getParentArea() != null) {
            if (group.size() > 1) {
                Area parent = (Area)group.get(0).getParentArea();
                Rectangular gp = this.computeGroupGP(parent, group);
                parent.createSuperArea(gp, group, "<area>");
            } else {
                group.get(0).setName("<area>");
            }
        }
    }

    private Rectangular computeGroupGP(Area parent, List<Area> group) {
        Rectangular gp = null;
        for (Area area : group) {
            Rectangular agp = parent.getTopology().getPosition(area);
            if (agp != null) {
                if (gp == null) {
                    gp = new Rectangular(agp);
                    continue;
                }
                gp.expandToEnclose(agp);
                continue;
            }
            log.error("Couldn't create super area for {} because of a different parent. The tree should be flattened before applying the GroupByExample operator", (Object)area);
        }
        return gp;
    }

    private Rectangular computeGroupBounds(List<Area> group) {
        Rectangular ret = null;
        for (Area area : group) {
            Rectangular agp = area.getBounds();
            if (ret == null) {
                ret = new Rectangular(agp);
                continue;
            }
            ret.expandToEnclose(agp);
        }
        return ret;
    }

    private void recursiveAnalyzeAreas(Area root) {
        if (root.getParentArea() != null) {
            this.analyzeArea(root);
        }
        for (Area child : root.getChildAreas()) {
            this.recursiveAnalyzeAreas(child);
        }
    }

    private void analyzeArea(Area area) {
        System.out.println("Area: " + area);
        Vector boxes = area.getAllBoxes();
        Box cparent = this.getCommonAncestor(boxes);
        List<Box> groups = this.getGroupCommonAncestors(boxes, cparent, area);
        if ((groups.isEmpty() || groups.size() == 1 && groups.get(0) == cparent) && cparent.getParentBox() != null) {
            if (groups.isEmpty()) {
                groups.add(cparent);
            }
            cparent = cparent.getParentBox();
        }
        BoxSignature psig = new BoxSignature(cparent);
        AreaPattern pat = new AreaPattern(psig);
        System.out.println("  Parent: " + cparent + " : " + psig);
        System.out.println("  Groups: " + groups);
        for (Box box : groups) {
            BoxSignature sig = new BoxSignature(box);
            pat.addGroupSignature(sig);
            System.out.println("    " + sig);
        }
        int fs = 0;
        if (!boxes.isEmpty()) {
            fs = AreaPattern.getStartingFontSize((Box)boxes.get(0));
        }
        pat.setFontSize(fs);
        System.out.println("  FS=" + fs);
        if (this.patterns.contains(pat)) {
            System.out.println("ALREADY THERE");
        } else {
            this.patterns.add(pat);
        }
    }

    private Box getCommonAncestor(List<Box> boxes) {
        HashSet<Box> candidates = null;
        for (Box box : boxes) {
            List<Box> anc = this.getAncestors(box);
            if (candidates == null) {
                candidates = new HashSet<Box>(anc);
                continue;
            }
            candidates.retainAll(anc);
        }
        int maxd = -1;
        Box ret = null;
        for (Box box : candidates) {
            int d = this.getDepth(box);
            if (d <= maxd) continue;
            maxd = d;
            ret = box;
        }
        return ret;
    }

    private List<Box> getGroupCommonAncestors(List<Box> boxes, Box parent, Area area) {
        ArrayList<Box> ret = new ArrayList<Box>();
        for (Box box : boxes) {
            Box anc = this.getAncestorUntilParent(box, parent, area);
            if (anc == null) continue;
            ret.add(anc);
        }
        return ret;
    }

    private List<Box> getAncestors(Box box) {
        ArrayList<Box> ret = new ArrayList<Box>();
        Box cur = box;
        ret.add(cur);
        while (cur.getParentBox() != null) {
            cur = cur.getParentBox();
            ret.add(cur);
        }
        return ret;
    }

    private Box getAncestorUntilParent(Box box, Box parent, Area area) {
        Rectangular ab = area.getBounds();
        Box cur = box;
        do {
            Box cparent;
            if ((cparent = cur.getParentBox()) == parent) {
                return cur;
            }
            Rectangular pb = cparent.getVisualBounds();
            if (ab.encloses(pb)) continue;
            return cur;
        } while ((cur = cur.getParentBox()) != null);
        return null;
    }

    private int getDepth(Box box) {
        int ret = 0;
        Box cur = box;
        while (cur.getParentBox() != null) {
            cur = cur.getParentBox();
            ++ret;
        }
        return ret;
    }
}

