/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.OpenShiftApplication;
import cz.xtf.builder.builders.BuildConfigBuilder;
import cz.xtf.builder.builders.ConfigMapWithPropertyFilesBuilder;
import cz.xtf.builder.builders.DeploymentConfigBuilder;
import cz.xtf.builder.builders.ImageStreamBuilder;
import cz.xtf.builder.builders.PVCBuilder;
import cz.xtf.builder.builders.RoleBindingBuilder;
import cz.xtf.builder.builders.RoleBuilder;
import cz.xtf.builder.builders.RouteBuilder;
import cz.xtf.builder.builders.SecretBuilder;
import cz.xtf.builder.builders.ServiceBuilder;
import cz.xtf.builder.db.OpenShiftAuxiliary;
import cz.xtf.core.bm.ManagedBuildReference;
import cz.xtf.core.openshift.OpenShift;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationBuilder {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBuilder.class);
    private final String applicationName;
    private final Set<RouteBuilder> routes = new HashSet<RouteBuilder>();
    private final Set<ServiceBuilder> services = new HashSet<ServiceBuilder>();
    private final Set<ImageStreamBuilder> images = new HashSet<ImageStreamBuilder>();
    private final Set<DeploymentConfigBuilder> deployments = new HashSet<DeploymentConfigBuilder>();
    private final Set<BuildConfigBuilder> builds = new HashSet<BuildConfigBuilder>();
    private final Set<SecretBuilder> secrets = new HashSet<SecretBuilder>();
    private final Set<ConfigMapWithPropertyFilesBuilder> configMaps = new HashSet<ConfigMapWithPropertyFilesBuilder>();
    private final Set<RoleBuilder> roles = new HashSet<RoleBuilder>();
    private final Set<RoleBindingBuilder> roleBindings = new HashSet<RoleBindingBuilder>();
    private final Set<PVCBuilder> persistentVolumeClaims = new HashSet<PVCBuilder>();
    private final Map<String, String> labels = new HashMap<String, String>();

    public static ApplicationBuilder fromImage(String name, String imageUrl) {
        return ApplicationBuilder.fromImage(name, imageUrl, Collections.EMPTY_MAP);
    }

    public static ApplicationBuilder fromImage(String name, String imageUrl, Map<String, String> labels) {
        ApplicationBuilder appBuilder = new ApplicationBuilder(name, labels);
        appBuilder.deploymentConfig().onConfigurationChange().podTemplate().container().fromImage(imageUrl);
        return appBuilder;
    }

    public static ApplicationBuilder fromManagedBuild(String name, ManagedBuildReference mbr) {
        return ApplicationBuilder.fromManagedBuild(name, mbr, Collections.EMPTY_MAP);
    }

    public static ApplicationBuilder fromManagedBuild(String name, ManagedBuildReference mbr, Map<String, String> labels) {
        ApplicationBuilder appBuilder = new ApplicationBuilder(name, labels);
        appBuilder.deploymentConfig().onImageChange().onConfigurationChange().podTemplate().container().fromImage(mbr.getNamespace(), mbr.getStreamName());
        return appBuilder;
    }

    public static ApplicationBuilder fromS2IBuild(String name, String imageUrl, String gitRepo) {
        return ApplicationBuilder.fromS2IBuild(name, imageUrl, gitRepo, Collections.EMPTY_MAP);
    }

    public static ApplicationBuilder fromS2IBuild(String name, String imageUrl, String gitRepo, Map<String, String> labels) {
        ApplicationBuilder appBuilder = new ApplicationBuilder(name, labels);
        appBuilder.buildConfig().onConfigurationChange().gitSource(gitRepo).setOutput(name).sti().forcePull(true).fromDockerImage(imageUrl);
        appBuilder.imageStream();
        appBuilder.deploymentConfig().onImageChange().onConfigurationChange().podTemplate().container().fromImage(name);
        return appBuilder;
    }

    public ApplicationBuilder(String name) {
        this(name, Collections.EMPTY_MAP);
    }

    public ApplicationBuilder(String name, Map<String, String> labels) {
        this.applicationName = name;
        this.labels.putAll(labels);
    }

    public String getName() {
        return this.applicationName;
    }

    public ImageStreamBuilder imageStream() {
        return this.imageStream(this.applicationName);
    }

    public ImageStreamBuilder imageStream(String name) {
        ImageStreamBuilder builder;
        Optional<ImageStreamBuilder> orig = this.images.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            builder = orig.get();
        } else {
            builder = new ImageStreamBuilder(this, name);
            builder.addLabels(this.labels);
            this.images.add(builder);
        }
        return builder;
    }

    public BuildConfigBuilder buildConfig() {
        return this.buildConfig(this.applicationName);
    }

    public BuildConfigBuilder buildConfig(String name) {
        BuildConfigBuilder builder;
        Optional<BuildConfigBuilder> orig = this.builds.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            builder = orig.get();
        } else {
            builder = new BuildConfigBuilder(this, name);
            builder.addLabels(this.labels);
            this.builds.add(builder);
        }
        return builder;
    }

    public DeploymentConfigBuilder deploymentConfig() {
        return this.deploymentConfig(this.applicationName);
    }

    public DeploymentConfigBuilder deploymentConfig(String name) {
        DeploymentConfigBuilder builder;
        Optional<DeploymentConfigBuilder> orig = this.deployments.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            builder = orig.get();
        } else {
            builder = new DeploymentConfigBuilder(this, name);
            builder.addLabels(this.labels);
            this.deployments.add(builder);
        }
        return builder;
    }

    public ServiceBuilder service() {
        return this.service(this.applicationName);
    }

    public ServiceBuilder service(String name) {
        ServiceBuilder result;
        Optional<ServiceBuilder> orig = this.services.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new ServiceBuilder(this, name);
            result.addContainerSelector("deploymentconfig", this.applicationName);
            result.addLabels(this.labels);
            this.services.add(result);
        }
        return result;
    }

    public RouteBuilder route() {
        return this.route(this.applicationName);
    }

    public RouteBuilder route(String name) {
        RouteBuilder result;
        Optional<RouteBuilder> orig = this.routes.stream().filter(r -> r.getName().startsWith(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new RouteBuilder(this, name);
            result.forService(this.applicationName);
            result.addLabels(this.labels);
            this.routes.add(result);
        }
        return result;
    }

    public RoleBuilder role() {
        return this.role(this.applicationName);
    }

    public RoleBuilder role(String name) {
        RoleBuilder result;
        Optional<RoleBuilder> orig = this.roles.stream().filter(r -> r.getName().startsWith(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new RoleBuilder(this, name);
            result.addLabels(this.labels);
            this.roles.add(result);
        }
        return result;
    }

    public RoleBindingBuilder roleBinding() {
        return this.roleBinding(this.applicationName);
    }

    public RoleBindingBuilder roleBinding(String name) {
        RoleBindingBuilder result;
        Optional<RoleBindingBuilder> orig = this.roleBindings.stream().filter(r -> r.getName().startsWith(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new RoleBindingBuilder(this, name);
            result.addLabels(this.labels);
            this.roleBindings.add(result);
        }
        return result;
    }

    public ConfigMapWithPropertyFilesBuilder configMap() {
        return this.configMap(this.applicationName);
    }

    public ConfigMapWithPropertyFilesBuilder configMap(String name) {
        ConfigMapWithPropertyFilesBuilder result;
        Optional<ConfigMapWithPropertyFilesBuilder> orig = this.configMaps.stream().filter(r -> r.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new ConfigMapWithPropertyFilesBuilder(name);
            result.addLabels(this.labels);
            this.configMaps.add(result);
        }
        return result;
    }

    public SecretBuilder secret() {
        return this.secret(this.applicationName);
    }

    public SecretBuilder secret(String name) {
        SecretBuilder result;
        Optional<SecretBuilder> orig = this.secrets.stream().filter(r -> r.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new SecretBuilder(name);
            result.addLabels(this.labels);
            this.secrets.add(result);
        }
        return result;
    }

    public PVCBuilder pvc() {
        return this.pvc(this.applicationName);
    }

    public PVCBuilder pvc(String name) {
        PVCBuilder result;
        Optional<PVCBuilder> orig = this.persistentVolumeClaims.stream().filter(r -> r.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            result = orig.get();
        } else {
            result = new PVCBuilder(name);
            result.addLabels(this.labels);
            this.persistentVolumeClaims.add(result);
        }
        return result;
    }

    public List<ImageStream> buildImageStreams() {
        return this.images.stream().map(ImageStreamBuilder::build).collect(Collectors.toList());
    }

    public List<BuildConfig> buildBuildConfigs() {
        return this.builds.stream().map(BuildConfigBuilder::build).collect(Collectors.toList());
    }

    public List<DeploymentConfig> buildDeploymentConfigs() {
        return this.deployments.stream().map(DeploymentConfigBuilder::build).collect(Collectors.toList());
    }

    public List<Service> buildServices() {
        return this.services.stream().map(ServiceBuilder::build).collect(Collectors.toList());
    }

    public List<Route> buildRoutes() {
        return this.routes.stream().map(RouteBuilder::build).collect(Collectors.toList());
    }

    public List<Role> buildRoles() {
        return this.roles.stream().map(RoleBuilder::build).collect(Collectors.toList());
    }

    public List<RoleBinding> buildRoleBindings() {
        return this.roleBindings.stream().map(RoleBindingBuilder::build).collect(Collectors.toList());
    }

    public List<ConfigMap> buildConfigMaps() {
        return this.configMaps.stream().map(ConfigMapWithPropertyFilesBuilder::build).collect(Collectors.toList());
    }

    public List<Secret> buildSecrets() {
        return this.secrets.stream().map(SecretBuilder::build).collect(Collectors.toList());
    }

    public List<PersistentVolumeClaim> buildPVCs() {
        return this.persistentVolumeClaims.stream().map(PVCBuilder::build).collect(Collectors.toList());
    }

    public List<HasMetadata> build() {
        LinkedList<HasMetadata> result = new LinkedList<HasMetadata>();
        result.addAll(this.buildImageStreams());
        result.addAll(this.buildBuildConfigs());
        result.addAll(this.buildDeploymentConfigs());
        result.addAll(this.buildServices());
        result.addAll(this.buildRoutes());
        result.addAll(this.buildConfigMaps());
        result.addAll(this.buildSecrets());
        result.addAll(this.buildPVCs());
        return result;
    }

    @Deprecated
    public OpenShiftApplication buildApplication() {
        return new OpenShiftApplication(this);
    }

    public OpenShiftApplication buildApplication(OpenShift openShift) {
        return new OpenShiftApplication(this, openShift);
    }

    public ApplicationBuilder addDatabase(OpenShiftAuxiliary database) {
        database.configureDeployment(this);
        database.configureApplicationDeployment(this.deploymentConfig());
        return this;
    }
}

