/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift.helpers;

import cz.xtf.core.openshift.helpers.ResourceParsers;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.List;
import java.util.function.Function;

public class ResourceFunctions {
    public static Function<List<Pod>, Boolean> areExactlyNPodsReady(int n) {
        return pods -> pods.stream().filter(ResourceParsers::isPodReady).count() == (long)n;
    }

    public static Function<List<Pod>, Boolean> areExactlyNPodsRunning(int n) {
        return pods -> pods.stream().filter(ResourceParsers::isPodRunning).count() == (long)n;
    }

    public static Function<List<Pod>, Boolean> haveAnyPodRestarted() {
        return ResourceFunctions.haveAnyPodRestartedAtLeastNTimes(1);
    }

    public static Function<List<Pod>, Boolean> haveAnyPodRestartedAtLeastNTimes(int n) {
        return pods -> pods.stream().anyMatch(pod -> ResourceParsers.hasPodRestartedAtLeastNTimes(pod, n));
    }

    private ResourceFunctions() {
    }
}

