/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public enum ServiceLogColor {
    ANSI_RESET_FG("\u001b[0m"),
    ANSI_RESET_BG("\u001b[0m"),
    ANSI_POD_LOG_BG("\u001b[40m"),
    ANSI_RED1("\u001b[31m"),
    ANSI_GREEN1("\u001b[32m"),
    ANSI_YELLOW1("\u001b[33m"),
    ANSI_AZURE1("\u001b[34m"),
    ANSI_VIOLET1("\u001b[35m"),
    ANSI_WATER1("\u001b[36m"),
    ANSI_BRIGHT_RED("\u001b[91m"),
    ANSI_BRIGHT_GREEN("\u001b[92m"),
    ANSI_BRIGHT_YELLOW("\u001b[93m"),
    ANSI_BRIGHT_BLUE("\u001b[94m"),
    ANSI_BRIGHT_PURPLE("\u001b[95m"),
    ANSI_BRIGHT_CYAN("\u001b[96m"),
    ANSI_BRIGHT_WHITE("\u001b[97m"),
    ANSI_POD_NAME_BG("\u001b[40;3m");

    public final String value;
    private static final Lock lock;
    private static int idx;
    public static final ServiceLogColor[] COLORS;

    private ServiceLogColor(String value) {
        this.value = value;
    }

    public static ServiceLogColor getNext() {
        lock.lock();
        try {
            if (++idx >= COLORS.length) {
                idx = 0;
            }
            ServiceLogColor serviceLogColor = COLORS[idx];
            return serviceLogColor;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        lock = new ReentrantLock();
        idx = 0;
        COLORS = new ServiceLogColor[]{ANSI_BRIGHT_GREEN, ANSI_BRIGHT_RED, ANSI_BRIGHT_YELLOW, ANSI_BRIGHT_BLUE, ANSI_BRIGHT_PURPLE, ANSI_BRIGHT_CYAN, ANSI_BRIGHT_WHITE, ANSI_RED1, ANSI_GREEN1, ANSI_YELLOW1, ANSI_AZURE1, ANSI_VIOLET1, ANSI_WATER1};
    }
}

