/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.helm;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.CLIUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelmBinary {
    private static final Logger log = LoggerFactory.getLogger(HelmBinary.class);
    private final String path;
    private final String helmConfigPath;
    private final String kubeUsername;
    private final String kubeToken;
    private final String namespace;

    public HelmBinary(String path, String kubeUsername, String kubeToken, String namespace) {
        this.path = path;
        this.kubeUsername = kubeUsername;
        this.kubeToken = kubeToken;
        Path helmConfigFile = Paths.get(path, new String[0]).getParent().resolve(".config");
        try {
            helmConfigFile = Files.createDirectories(helmConfigFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.helmConfigPath = helmConfigFile.toAbsolutePath().toString();
        this.namespace = namespace;
    }

    public HelmBinary(String path, String helmConfigPath, String kubeUsername, String kubeToken, String namespace) {
        this.path = path;
        this.helmConfigPath = helmConfigPath;
        this.kubeUsername = kubeUsername;
        this.kubeToken = kubeToken;
        this.namespace = namespace;
    }

    public String execute(String ... args) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("HELM_CONFIG_HOME", this.helmConfigPath);
        environmentVariables.put("HELM_KUBEAPISERVER", OpenShiftConfig.url());
        environmentVariables.put("HELM_KUBEASUSER", this.kubeUsername);
        environmentVariables.put("HELM_KUBETOKEN", this.kubeToken);
        environmentVariables.put("HELM_NAMESPACE", this.namespace);
        return CLIUtils.executeCommand(environmentVariables, (String[])ArrayUtils.addAll((Object[])new String[]{this.path}, (Object[])args));
    }
}

