/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.image;

import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.image.Image;

public class Product {
    private final String id;

    public Product(String id) {
        this.id = id;
    }

    public Image image() {
        return Image.resolve(this.id.replaceAll("\\..*", ""));
    }

    public String property(String propertyId) {
        return this.resolveDefaultingProperty("properties." + propertyId);
    }

    public String version() {
        return this.resolveDefaultingProperty("version");
    }

    public String templatesRepo() {
        return this.resolveDefaultingProperty("templates.repo");
    }

    public String templatesBranch() {
        return this.resolveDefaultingProperty("templates.branch");
    }

    public String helmChartsRepo() {
        return this.resolveDefaultingProperty("helm.charts.repo");
    }

    public String helmChartsBranch() {
        return this.resolveDefaultingProperty("helm.charts.branch");
    }

    public String helmChartsLocation() {
        return this.resolveDefaultingProperty("helm.charts.location");
    }

    public String helmChartExamplesLocation() {
        return this.resolveDefaultingProperty("helm.charts.examples.location");
    }

    private String resolveDefaultingProperty(String propertyId) {
        String value = XTFConfig.get("xtf." + this.id + "." + propertyId);
        String defaultingValue = this.id.contains(".") ? XTFConfig.get("xtf." + this.id.replaceAll("\\..*", "") + "." + propertyId) : null;
        return value != null ? value : defaultingValue;
    }
}

