/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm;

import cz.xtf.core.bm.BinaryBuild;
import cz.xtf.core.openshift.OpenShift;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryBuildFromSources
extends BinaryBuild {
    private static final Logger log = LoggerFactory.getLogger(BinaryBuildFromSources.class);
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;

    public BinaryBuildFromSources(String builderImage, Path path, Map<String, String> envProperties, String id) {
        super(builderImage, path, envProperties, id);
    }

    @Override
    public void build(OpenShift openShift) {
        openShift.imageStreams().create((Object)this.is);
        openShift.buildConfigs().create((Object)this.bc);
        try {
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<?> future = executorService.submit(() -> this.writeProjectTar(pos));
            ((BuildConfigResource)openShift.buildConfigs().withName(this.bc.getMetadata().getName())).instantiateBinary().fromInputStream((InputStream)pis);
            future.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error("Exception building {}", (Object)this.getId(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getContentHash() {
        if (!this.isCached() || this.contentHash == null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                DigestOutputStream dos = new DigestOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, md);
                this.writeProjectTar(dos);
                this.contentHash = Hex.encodeHexString((byte[])dos.getMessageDigest().digest()).substring(0, 63);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.contentHash;
    }

    private void writeProjectTar(OutputStream os) {
        Collection filesToArchive = FileUtils.listFiles((File)this.getPath().toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        try (TarArchiveOutputStream o = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", os);){
            o.setLongFileMode(3);
            for (File f : filesToArchive) {
                String tarPath = this.getPath().relativize(f.toPath()).toString();
                log.trace("adding file to tar: {}", (Object)tarPath);
                ArchiveEntry entry = o.createArchiveEntry(f, tarPath);
                TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)entry;
                tarArchiveEntry.setModTime(Date.from(Instant.EPOCH));
                PosixFileAttributes attrs = Files.getFileAttributeView(Paths.get(f.toURI()), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
                tarArchiveEntry.setMode(this.toOctalFileMode(attrs.permissions()));
                o.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                if (f.isFile()) {
                    try (InputStream i = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)i, (OutputStream)o);
                    }
                }
                o.closeArchiveEntry();
            }
            o.finish();
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e);
        }
    }

    public int toOctalFileMode(Set<PosixFilePermission> permissions) {
        int result = 0;
        for (PosixFilePermission permissionBit : permissions) {
            switch (permissionBit) {
                case OWNER_READ: {
                    result |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    break;
                }
                case OTHERS_READ: {
                    result |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                }
            }
        }
        return result;
    }
}

