/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHash {
    private static final Logger log = LoggerFactory.getLogger(ContentHash.class);

    public static String get(Path path) {
        String hash = String.valueOf(RandomUtils.nextLong((long)0L, (long)Integer.MAX_VALUE));
        try {
            hash = ContentHash.executeCommand(path, "/bin/sh", "-c", "tar -cf - . | md5sum").replaceAll("([a-z0-9]*).*", "$1");
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to generate to directory content hash. Falling back to random number.", (Throwable)e);
        }
        return hash;
    }

    private static String executeCommand(Path path, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(path.toFile());
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        int result = p.waitFor();
        if (result != 0) {
            throw new IOException("Failed to calculate hash via: " + Arrays.toString(args));
        }
        try (InputStream is = p.getInputStream();){
            String string;
            try (StringWriter sw = new StringWriter();){
                IOUtils.copy((InputStream)is, (Writer)sw, (Charset)Charset.defaultCharset());
                string = sw.toString();
            }
            return string;
        }
    }

    private ContentHash() {
    }
}

