/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLIUtils {
    private static final Logger log = LoggerFactory.getLogger(CLIUtils.class);

    public static String executeCommand(Map<String, String> environmentVariables, String ... args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().putAll(environmentVariables);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        try {
            Process p = pb.start();
            ExecutorService es = Executors.newFixedThreadPool(2);
            Future<String> out = es.submit(() -> {
                try (InputStream is = p.getInputStream();){
                    String string;
                    try (StringWriter sw = new StringWriter();){
                        IOUtils.copy((InputStream)is, (Writer)sw);
                        string = sw.toString();
                    }
                    return string;
                }
            });
            Future<String> err = es.submit(() -> {
                try (InputStream is = p.getErrorStream();){
                    String string;
                    try (StringWriter sw = new StringWriter();){
                        IOUtils.copy((InputStream)is, (Writer)sw);
                        string = sw.toString();
                    }
                    return string;
                }
            });
            int result = p.waitFor();
            if (result == 0) {
                return out.get();
            }
            log.error("Failed while executing (code {}): {}", (Object)result, (Object)String.join((CharSequence)" ", args));
            log.error(err.get());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error("Failed while executing: " + String.join((CharSequence)" ", args), (Throwable)e);
        }
        return null;
    }

    public static String executeCommand(String ... args) {
        return CLIUtils.executeCommand(Collections.emptyMap(), args);
    }
}

