/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.openshift.ClusterVersionOpenShiftBinaryPathResolver;
import cz.xtf.core.openshift.ConfiguredPathOpenShiftBinaryResolver;
import cz.xtf.core.openshift.OpenShiftBinaryManager;
import cz.xtf.core.openshift.OpenShiftBinaryPathResolver;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum OpenShiftBinaryManagerFactory {
    INSTANCE;

    private volatile OpenShiftBinaryManager openShiftBinaryManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OpenShiftBinaryManager getOpenShiftBinaryManager() {
        OpenShiftBinaryManager localRef = this.openShiftBinaryManager;
        if (localRef != null) return localRef;
        Class<OpenShiftBinaryManagerFactory> clazz = OpenShiftBinaryManagerFactory.class;
        synchronized (OpenShiftBinaryManagerFactory.class) {
            localRef = this.openShiftBinaryManager;
            if (localRef != null) return localRef;
            for (OpenShiftBinaryPathResolver resolver : this.resolverList()) {
                String path = resolver.resolve();
                if (path == null) continue;
                this.openShiftBinaryManager = localRef = new OpenShiftBinaryManager(path);
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localRef;
        }
    }

    private List<OpenShiftBinaryPathResolver> resolverList() {
        return Stream.of(new ConfiguredPathOpenShiftBinaryResolver(), new ClusterVersionOpenShiftBinaryPathResolver()).collect(Collectors.toList());
    }
}

