/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming;

import java.util.Objects;

public class ServiceLogsSettings {
    public static final String ATTRIBUTE_NAME_TARGET = "target";
    public static final String ATTRIBUTE_NAME_FILTER = "filter";
    public static final String ATTRIBUTE_NAME_OUTPUT = "output";
    public static final String UNASSIGNED = "[unassigned]";
    private final String target;
    private final String filter;
    private final String outputPath;

    private ServiceLogsSettings(String target, String filter, String outputPath) {
        this.target = target;
        this.filter = filter;
        this.outputPath = outputPath;
    }

    public String getTarget() {
        return this.target;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLogsSettings that = (ServiceLogsSettings)o;
        return this.target.equals(that.target) && this.filter.equals(that.filter) && this.outputPath.equals(that.outputPath);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.filter, this.outputPath);
    }

    public static final class Builder {
        private String target;
        private String filter;
        private String outputPath;

        public Builder withTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder withOutputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public ServiceLogsSettings build() {
            if (this.target == null || this.target.isEmpty()) {
                throw new IllegalStateException("The Service Logs Streaming settings must define a target regex");
            }
            if (this.filter == null || this.filter.isEmpty()) {
                this.filter = ServiceLogsSettings.UNASSIGNED;
            }
            if (this.outputPath == null || this.outputPath.isEmpty()) {
                this.outputPath = ServiceLogsSettings.UNASSIGNED;
            }
            return new ServiceLogsSettings(this.target, this.filter, this.outputPath);
        }
    }
}

