/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting;

import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public interface Waiter {
    public static final long DEFAULT_INTERVAL = 1000L;

    public Waiter timeout(long var1);

    public Waiter timeout(TimeUnit var1, long var2);

    public Waiter interval(long var1);

    public Waiter interval(TimeUnit var1, long var2);

    public Waiter reason(String var1);

    public Waiter logPoint(LogPoint var1);

    default public Waiter level(Level level) {
        throw new UnsupportedOperationException("Method level hasn't been implemented.");
    }

    default public Waiter onIteration(Runnable runnable) {
        throw new UnsupportedOperationException("Method onIteration hasn't been implemented.");
    }

    default public Waiter onSuccess(Runnable runnable) {
        throw new UnsupportedOperationException("Method onSuccess hasn't been implemented.");
    }

    default public Waiter onFailure(Runnable runnable) {
        throw new UnsupportedOperationException("Method onFailure hasn't been implemented.");
    }

    default public Waiter onTimeout(Runnable runnable) {
        throw new UnsupportedOperationException("Method onTimeout hasn't been implemented.");
    }

    default public Waiter failFast(FailFastCheck failFast) {
        throw new UnsupportedOperationException("Method failFast hasn't been implemented.");
    }

    public boolean waitFor();

    public static enum LogPoint {
        NONE,
        START,
        END,
        BOTH;

        private static final Logger log;

        public void logStart(String reason, long millis) {
            this.logStart(reason, millis, WaitingConfig.level());
        }

        public void logStart(String reason, long millis, Level level) {
            if (this.equals((Object)START) || this.equals((Object)BOTH)) {
                this.logMessage(level, String.format("Waiting up to %s. Reason: %s", DurationFormatUtils.formatDurationWords((long)millis, (boolean)true, (boolean)true), reason));
            }
        }

        public void logEnd(String reason, long millis) {
            this.logEnd(reason, millis, WaitingConfig.level());
        }

        public void logEnd(String reason, long millis, Level level) {
            if (this.equals((Object)END) || this.equals((Object)BOTH)) {
                this.logMessage(level, String.format("Finished waiting after %s. Reason: %s", DurationFormatUtils.formatDurationWords((long)millis, (boolean)true, (boolean)true), reason));
            }
        }

        private void logMessage(Level level, String message) {
            switch (level) {
                case TRACE: {
                    log.trace(message);
                    break;
                }
                case DEBUG: {
                    log.debug(message);
                    break;
                }
                case INFO: {
                    log.info(message);
                    break;
                }
                case WARN: {
                    log.warn(message);
                    break;
                }
                case ERROR: {
                    log.error(message);
                }
            }
        }

        static {
            log = LoggerFactory.getLogger(LogPoint.class);
        }
    }
}

