/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.PodShell;
import cz.xtf.core.openshift.crd.CustomResourceDefinitionContextProvider;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.Waiter;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingList;
import io.fabric8.kubernetes.api.model.rbac.RoleList;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.kubernetes.api.model.rbac.SubjectBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpecBuilder;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClientAdapter;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.observables.StringObservable;

public class OpenShift
extends NamespacedOpenShiftClientAdapter {
    private static final Logger log = LoggerFactory.getLogger(OpenShift.class);
    private static ServiceLoader<CustomResourceDefinitionContextProvider> crdContextProviderLoader;
    private static volatile String routeSuffix;
    public static final String KEEP_LABEL = "xtf.cz/keep";
    public static final Multimap<String, OpenShift> namespaceToOpenshiftClientMap;
    public static final String XTF_MANAGED_LABEL = "xtf.cz/managed";
    private final OpenShiftWaiters waiters;

    public static OpenShift get(String namespace) {
        Config kubeconfig = Config.autoConfigure(null);
        OpenShiftConfig openShiftConfig = new OpenShiftConfig(kubeconfig);
        OpenShift.setupTimeouts(openShiftConfig);
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            openShiftConfig.setNamespace(namespace);
        }
        return OpenShift.get(openShiftConfig);
    }

    public static OpenShift get(Path kubeconfigPath, String namespace) {
        try {
            String kubeconfigContents = new String(Files.readAllBytes(kubeconfigPath), StandardCharsets.UTF_8);
            Config kubeconfig = Config.fromKubeconfig(null, (String)kubeconfigContents, (String)kubeconfigPath.toAbsolutePath().toString());
            OpenShiftConfig openShiftConfig = new OpenShiftConfig(kubeconfig);
            OpenShift.setupTimeouts(openShiftConfig);
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                openShiftConfig.setNamespace(namespace);
            }
            return OpenShift.get(openShiftConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenShift get(String masterUrl, String namespace, String username, String password) {
        OpenShiftConfig openShiftConfig = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).withTrustCerts(true)).withNamespace(namespace)).withUsername(username)).withPassword(password)).build();
        OpenShift.setupTimeouts(openShiftConfig);
        return OpenShift.get(openShiftConfig);
    }

    public static OpenShift get(String masterUrl, String namespace, String token) {
        OpenShiftConfig openShiftConfig = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).withTrustCerts(true)).withNamespace(namespace)).withOauthToken(token)).build();
        OpenShift.setupTimeouts(openShiftConfig);
        return OpenShift.get(openShiftConfig);
    }

    private static OpenShift get(OpenShiftConfig openShiftConfig) {
        Optional<OpenShift> optionalOpenShift = namespaceToOpenshiftClientMap.get((Object)openShiftConfig.getNamespace()).stream().filter(oc -> OpenShift.isEqualOpenshiftConfig(openShiftConfig, (OpenShiftConfig)oc.getConfiguration())).findFirst();
        if (optionalOpenShift.isPresent()) {
            return optionalOpenShift.get();
        }
        OpenShift openshift = new OpenShift(openShiftConfig);
        namespaceToOpenshiftClientMap.put((Object)openShiftConfig.getNamespace(), (Object)openshift);
        return openshift;
    }

    private static void setupTimeouts(OpenShiftConfig config) {
        config.setBuildTimeout(600000L);
        config.setRequestTimeout(120000);
        config.setConnectionTimeout(120000);
    }

    protected static synchronized ServiceLoader<CustomResourceDefinitionContextProvider> getCRDContextProviders() {
        if (crdContextProviderLoader == null) {
            crdContextProviderLoader = ServiceLoader.load(CustomResourceDefinitionContextProvider.class);
        }
        return crdContextProviderLoader;
    }

    public OpenShift(OpenShiftConfig openShiftConfig) {
        NamespacedOpenShiftClient delegate = (NamespacedOpenShiftClient)new KubernetesClientBuilder().withConfig((Config)openShiftConfig).build().adapt(NamespacedOpenShiftClient.class);
        this.init((Client)delegate);
        this.waiters = new OpenShiftWaiters(this);
    }

    public void setupPullSecret(String secret) {
        this.setupPullSecret("xtf-pull-secret", secret);
    }

    public void setupPullSecret(String name, String secret) {
        final Secret pullSecret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).addToLabels(KEEP_LABEL, "true")).endMetadata()).withType("kubernetes.io/dockerconfigjson")).withData(Collections.singletonMap(".dockerconfigjson", Base64.getEncoder().encodeToString(secret.getBytes())))).build();
        ((Resource)this.secrets().resource((Object)pullSecret)).createOrReplace();
        ((ServiceAccountResource)this.serviceAccounts().withName("default")).edit(new Visitor[]{new Visitor<ServiceAccountBuilder>(){

            public void visit(ServiceAccountBuilder builder) {
                builder.addToImagePullSecrets(new LocalObjectReference[]{((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(pullSecret.getMetadata().getName())).build()});
            }
        }});
        ((ServiceAccountResource)this.serviceAccounts().withName("builder")).edit(new Visitor[]{new Visitor<ServiceAccountBuilder>(){

            public void visit(ServiceAccountBuilder builder) {
                builder.addToSecrets(new ObjectReference[]{((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName(pullSecret.getMetadata().getName())).build()});
            }
        }});
    }

    public KubernetesList createResources(HasMetadata ... resources) {
        return this.createResources(Arrays.asList(resources));
    }

    public KubernetesList createResources(List<HasMetadata> resources) {
        KubernetesList list = new KubernetesList();
        list.setItems(resources);
        return this.createResources(list);
    }

    public KubernetesList createResources(KubernetesList resources) {
        KubernetesList list = new KubernetesList();
        list.setItems((List)this.resourceList(resources.getItems()).create());
        return list;
    }

    public boolean deleteResources(KubernetesList resources) {
        return resources.getItems().size() == this.resourceList(resources.getItems()).delete().size();
    }

    public void loadResource(InputStream is) {
        this.load(is).delete();
        this.load(is).create();
    }

    public ProjectRequest createProjectRequest() {
        return this.createProjectRequest(((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(this.getNamespace())).endMetadata()).build());
    }

    public ProjectRequest createProjectRequest(String name) {
        return this.createProjectRequest(((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(name)).endMetadata()).build());
    }

    public ProjectRequest createProjectRequest(ProjectRequest projectRequest) {
        return (ProjectRequest)this.projectrequests().create((Object)projectRequest);
    }

    public ProjectRequest recreateProject() {
        return this.recreateProject(((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(this.getNamespace())).endMetadata()).build());
    }

    public ProjectRequest recreateProject(String name) {
        return this.recreateProject(((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(name)).endMetadata()).build());
    }

    public ProjectRequest recreateProject(ProjectRequest projectRequest) {
        boolean deleted = this.deleteProject(projectRequest.getMetadata().getName());
        if (deleted) {
            BooleanSupplier bs = () -> this.getProject(projectRequest.getMetadata().getName()) == null;
            new SimpleWaiter(bs, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), "Waiting for old project deletion before creating new one").waitFor();
        }
        return this.createProjectRequest(projectRequest);
    }

    public Project getProject(String name) {
        try {
            return (Project)((Resource)this.projects().withName(name)).get();
        }
        catch (KubernetesClientException e) {
            return null;
        }
    }

    public Project getProject() {
        try {
            return (Project)((Resource)this.projects().withName(this.getNamespace())).get();
        }
        catch (KubernetesClientException e) {
            return null;
        }
    }

    public boolean deleteProject() {
        return this.deleteProject(this.getNamespace());
    }

    public boolean deleteProject(String name) {
        return this.getProject(name) != null ? !((Resource)this.projects().withName(name)).delete().isEmpty() : false;
    }

    public ImageStream createImageStream(ImageStream imageStream) {
        return (ImageStream)((Resource)this.imageStreams().resource((Object)imageStream)).create();
    }

    public ImageStream getImageStream(String name) {
        return (ImageStream)((Resource)this.imageStreams().withName(name)).get();
    }

    public List<ImageStream> getImageStreams() {
        return ((ImageStreamList)this.imageStreams().list()).getItems();
    }

    public StatefulSet createStatefulSet(StatefulSet statefulSet) {
        return (StatefulSet)((RollableScalableResource)this.apps().statefulSets().resource((Object)statefulSet)).create();
    }

    public StatefulSet getStatefulSet(String name) {
        return (StatefulSet)((RollableScalableResource)this.apps().statefulSets().withName(name)).get();
    }

    public List<StatefulSet> getStatefulSets() {
        return ((StatefulSetList)this.apps().statefulSets().list()).getItems();
    }

    public boolean deleteImageStream(ImageStream imageStream) {
        return !((Resource)this.imageStreams().resource((Object)imageStream)).delete().isEmpty();
    }

    public ImageStreamTag createImageStreamTag(ImageStreamTag imageStreamTag) {
        return (ImageStreamTag)((Resource)this.imageStreamTags().resource((Object)imageStreamTag)).create();
    }

    public ImageStreamTag getImageStreamTag(String imageStreamName, String tag) {
        return (ImageStreamTag)((Resource)this.imageStreamTags().withName(imageStreamName + ":" + tag)).get();
    }

    public List<ImageStreamTag> getImageStreamTags() {
        return ((ImageStreamTagList)this.imageStreamTags().list()).getItems();
    }

    public boolean deleteImageStreamTag(ImageStreamTag imageStreamTag) {
        return !((Resource)this.imageStreamTags().resource((Object)imageStreamTag)).delete().isEmpty();
    }

    public Pod createPod(Pod pod) {
        return (Pod)((PodResource)this.pods().resource((Object)pod)).create();
    }

    public Pod getPod(String name) {
        return (Pod)((PodResource)this.pods().withName(name)).get();
    }

    public String getPodLog(String deploymentConfigName) {
        return this.getPodLog(this.getAnyPod(deploymentConfigName));
    }

    public String getPodLog(Pod pod) {
        return this.getPodLog(pod, this.getAnyContainer(pod));
    }

    public String getPodLog(Pod pod, String containerName) {
        return this.getPodLog(pod, this.getContainer(pod, containerName));
    }

    public String getPodLog(Pod pod, Container container) {
        if (Objects.nonNull(container)) {
            return ((ContainerResource)((PodResource)this.pods().withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).getLog();
        }
        return ((PodResource)this.pods().withName(pod.getMetadata().getName())).getLog();
    }

    public Map<String, String> getAllContainerLogs(Pod pod) {
        return this.retrieveFromPodContainers(pod, container -> this.getPodLog(pod, (Container)container));
    }

    public Reader getPodLogReader(Pod pod) {
        return this.getPodLogReader(pod, this.getAnyContainer(pod));
    }

    public Reader getPodLogReader(Pod pod, String containerName) {
        return this.getPodLogReader(pod, this.getContainer(pod, containerName));
    }

    public Reader getPodLogReader(Pod pod, Container container) {
        if (Objects.nonNull(container)) {
            return ((ContainerResource)((PodResource)this.pods().withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).getLogReader();
        }
        return ((PodResource)this.pods().withName(pod.getMetadata().getName())).getLogReader();
    }

    public Map<String, Reader> getAllContainerLogReaders(Pod pod) {
        return this.retrieveFromPodContainers(pod, container -> this.getPodLogReader(pod, (Container)container));
    }

    public Observable<String> observePodLog(String dcName) {
        return this.observePodLog(this.getAnyPod(dcName));
    }

    public Observable<String> observePodLog(Pod pod) {
        return this.observePodLog(pod, this.getAnyContainer(pod));
    }

    public Observable<String> observePodLog(Pod pod, String containerName) {
        return this.observePodLog(pod, this.getContainer(pod, containerName));
    }

    public Observable<String> observePodLog(Pod pod, Container container) {
        LogWatch watcher = Objects.nonNull(container) ? ((ContainerResource)((PodResource)this.pods().withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).watchLog() : ((PodResource)this.pods().withName(pod.getMetadata().getName())).watchLog();
        return StringObservable.byLine((Observable)StringObservable.from((Reader)new InputStreamReader(watcher.getOutput())));
    }

    public Map<String, Observable<String>> observeAllContainerLogs(Pod pod) {
        return this.retrieveFromPodContainers(pod, container -> this.observePodLog(pod, (Container)container));
    }

    public List<Pod> getPods() {
        return ((PodList)this.pods().list()).getItems();
    }

    public List<Pod> getPods(String deploymentConfigName) {
        return this.getLabeledPods("deploymentconfig", deploymentConfigName);
    }

    public List<Pod> getPods(String deploymentConfigName, int version) {
        return this.getLabeledPods("deployment", deploymentConfigName + "-" + version);
    }

    public List<Pod> getLabeledPods(String key, String value) {
        return this.getLabeledPods(Collections.singletonMap(key, value));
    }

    public List<Pod> getLabeledPods(Map<String, String> labels) {
        return ((PodList)((FilterWatchListDeletable)this.pods().withLabels(labels)).list()).getItems();
    }

    public Pod getAnyPod(String deploymentConfigName) {
        return this.getAnyPod("deploymentconfig", deploymentConfigName);
    }

    public Pod getAnyPod(String key, String value) {
        return this.getAnyPod(Collections.singletonMap(key, value));
    }

    public Pod getAnyPod(Map<String, String> labels) {
        List<Pod> pods = this.getLabeledPods(labels);
        return pods.get(new Random().nextInt(pods.size()));
    }

    public boolean deletePod(Pod pod) {
        return this.deletePod(pod, 0L);
    }

    public boolean deletePod(Pod pod, long gracePeriod) {
        return !((PropagationPolicyConfigurable)((PodResource)this.pods().withName(pod.getMetadata().getName())).withGracePeriod(gracePeriod)).delete().isEmpty();
    }

    public boolean deletePods(String key, String value) {
        return !((FilterWatchListDeletable)this.pods().withLabel(key, value)).delete().isEmpty();
    }

    public boolean deletePods(Map<String, String> labels) {
        return !((FilterWatchListDeletable)this.pods().withLabels(labels)).delete().isEmpty();
    }

    public List<Container> getAllContainers(Pod pod) {
        return Optional.ofNullable(pod.getSpec()).map(PodSpec::getContainers).orElse(new ArrayList());
    }

    public Container getAnyContainer(Pod pod) {
        List<Container> containers = this.getAllContainers(pod);
        return containers.get(new Random().nextInt(containers.size()));
    }

    public Container getContainer(Pod pod, String containerName) {
        return this.getAllContainers(pod).stream().filter(c -> c.getName().equals(containerName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find container with name " + containerName + " in pod " + pod.getMetadata().getName()));
    }

    private <R> Map<String, R> retrieveFromPodContainers(Pod pod, Function<Container, R> containerRetriever) {
        return this.getAllContainers(pod).stream().collect(Collectors.toMap(Container::getName, containerRetriever));
    }

    public Secret createSecret(Secret secret) {
        return (Secret)((Resource)this.secrets().resource((Object)secret)).create();
    }

    public Secret getSecret(String name) {
        return (Secret)((Resource)this.secrets().withName(name)).get();
    }

    public List<Secret> getSecrets() {
        return ((SecretList)this.secrets().list()).getItems();
    }

    public List<Secret> getUserSecrets() {
        return ((SecretList)((FilterWatchListDeletable)this.secrets().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems().stream().filter(s -> !s.getType().startsWith("kubernetes.io/")).collect(Collectors.toList());
    }

    public boolean deleteSecret(Secret secret) {
        return !((Resource)this.secrets().resource((Object)secret)).delete().isEmpty();
    }

    public Service createService(Service service) {
        return (Service)((ServiceResource)this.services().resource((Object)service)).create();
    }

    public Service getService(String name) {
        return (Service)((ServiceResource)this.services().withName(name)).get();
    }

    public List<Service> getServices() {
        return ((ServiceList)this.services().list()).getItems();
    }

    public boolean deleteService(Service service) {
        return !((ServiceResource)this.services().resource((Object)service)).delete().isEmpty();
    }

    public Endpoints createEndpoint(Endpoints endpoint) {
        return (Endpoints)((Resource)this.endpoints().resource((Object)endpoint)).create();
    }

    public Endpoints getEndpoint(String name) {
        return (Endpoints)((Resource)this.endpoints().withName(name)).get();
    }

    public List<Endpoints> getEndpoints() {
        return ((EndpointsList)this.endpoints().list()).getItems();
    }

    public boolean deleteEndpoint(Endpoints endpoint) {
        return !((Resource)this.endpoints().resource((Object)endpoint)).delete().isEmpty();
    }

    public Route createRoute(Route route) {
        return (Route)((Resource)this.routes().resource((Object)route)).create();
    }

    public Route getRoute(String name) {
        return (Route)((Resource)this.routes().withName(name)).get();
    }

    public List<Route> getRoutes() {
        return ((RouteList)this.routes().list()).getItems();
    }

    public boolean deleteRoute(Route route) {
        return !((Resource)this.routes().resource((Object)route)).delete().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String generateHostname(String routeName) {
        if (routeSuffix == null) {
            Class<OpenShift> clazz = OpenShift.class;
            // MONITORENTER : cz.xtf.core.openshift.OpenShift.class
            if (routeSuffix == null) {
                routeSuffix = StringUtils.isNotBlank((CharSequence)cz.xtf.core.config.OpenShiftConfig.routeDomain()) ? cz.xtf.core.config.OpenShiftConfig.routeDomain() : this.retrieveRouteSuffix();
            }
            // MONITOREXIT : clazz
        }
        log.info("generateHostname returns namespace: " + routeName + "-" + this.getNamespace() + "." + routeSuffix);
        return routeName + "-" + this.getNamespace() + "." + routeSuffix;
    }

    private String retrieveRouteSuffix() {
        Route route = new Route();
        route.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName("probing-route")).build());
        route.setSpec(((RouteSpecBuilder)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)new RouteSpecBuilder().withNewTo().withKind("Service")).withName("imaginary-service")).endTo()).build());
        route = this.createRoute(route);
        this.deleteRoute(route);
        return route.getSpec().getHost().replaceAll("^[^\\.]*\\.(.*)", "$1");
    }

    private List<ReplicationController> getReplicationControllers() {
        return ((ReplicationControllerList)this.replicationControllers().list()).getItems();
    }

    private boolean deleteReplicationController(ReplicationController replicationController) {
        return !((RollableScalableResource)this.replicationControllers().withName(replicationController.getMetadata().getName())).cascading(false).delete().isEmpty();
    }

    public DeploymentConfig createDeploymentConfig(DeploymentConfig deploymentConfig) {
        return (DeploymentConfig)((DeployableScalableResource)this.deploymentConfigs().resource((Object)deploymentConfig)).create();
    }

    public DeploymentConfig getDeploymentConfig(String name) {
        return (DeploymentConfig)((DeployableScalableResource)this.deploymentConfigs().withName(name)).get();
    }

    public List<DeploymentConfig> getDeploymentConfigs() {
        return ((DeploymentConfigList)this.deploymentConfigs().list()).getItems();
    }

    public Map<String, String> getDeploymentConfigEnvVars(String name) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        ((Container)this.getDeploymentConfig(name).getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv().forEach(envVar -> envVars.put(envVar.getName(), envVar.getValue()));
        return envVars;
    }

    public DeploymentConfig updateDeploymentconfig(DeploymentConfig deploymentConfig) {
        return (DeploymentConfig)((DeployableScalableResource)this.deploymentConfigs().withName(deploymentConfig.getMetadata().getName())).replace();
    }

    public DeploymentConfig updateDeploymentConfigEnvVars(String name, Map<String, String> envVars) {
        DeploymentConfig dc = this.getDeploymentConfig(name);
        List vars = envVars.entrySet().stream().map(x -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)x.getKey())).withValue((String)x.getValue())).build()).collect(Collectors.toList());
        ((Container)dc.getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv().removeIf(x -> envVars.containsKey(x.getName()));
        ((Container)dc.getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv().addAll(vars);
        return this.updateDeploymentconfig(dc);
    }

    public boolean deleteDeploymentConfig(DeploymentConfig deploymentConfig) {
        return this.deleteDeploymentConfig(deploymentConfig, false);
    }

    public boolean deleteDeploymentConfig(DeploymentConfig deploymentConfig, boolean cascading) {
        return !((DeployableScalableResource)this.deploymentConfigs().withName(deploymentConfig.getMetadata().getName())).cascading(cascading).delete().isEmpty();
    }

    public void scale(String name, int replicas) {
        ((DeployableScalableResource)this.deploymentConfigs().withName(name)).scale(replicas);
    }

    public void deployLatest(String name) {
        ((DeployableScalableResource)this.deploymentConfigs().withName(name)).deployLatest();
    }

    public Build getBuild(String name) {
        return (Build)((BuildResource)this.inNamespace(this.getNamespace()).builds().withName(name)).get();
    }

    public Build getLatestBuild(String buildConfigName) {
        long lastVersion = ((BuildConfig)((BuildConfigResource)this.buildConfigs().withName(buildConfigName)).get()).getStatus().getLastVersion();
        return this.getBuild(buildConfigName + "-" + lastVersion);
    }

    public List<Build> getBuilds() {
        return ((BuildList)this.builds().list()).getItems();
    }

    public String getBuildLog(Build build) {
        return ((BuildResource)this.builds().withName(build.getMetadata().getName())).getLog();
    }

    public Reader getBuildLogReader(Build build) {
        return ((BuildResource)this.builds().withName(build.getMetadata().getName())).getLogReader();
    }

    public boolean deleteBuild(Build build) {
        return !((BuildResource)this.builds().resource((Object)build)).delete().isEmpty();
    }

    public Build startBuild(String buildConfigName) {
        BuildRequest request = ((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(buildConfigName)).endMetadata()).build();
        return (Build)((BuildConfigResource)this.buildConfigs().withName(buildConfigName)).instantiate(request);
    }

    public Build startBinaryBuild(String buildConfigName, File file) {
        return (Build)((BuildConfigResource)this.buildConfigs().withName(buildConfigName)).instantiateBinary().fromFile(file);
    }

    public BuildConfig createBuildConfig(BuildConfig buildConfig) {
        return (BuildConfig)((BuildConfigResource)this.buildConfigs().resource((Object)buildConfig)).create();
    }

    public BuildConfig getBuildConfig(String name) {
        return (BuildConfig)((BuildConfigResource)this.buildConfigs().withName(name)).get();
    }

    public List<BuildConfig> getBuildConfigs() {
        return ((BuildConfigList)this.buildConfigs().list()).getItems();
    }

    public Map<String, String> getBuildConfigEnvVars(String name) {
        return this.getBuildConfig(name).getSpec().getStrategy().getSourceStrategy().getEnv().stream().collect(Collectors.toMap(EnvVar::getName, EnvVar::getValue));
    }

    public BuildConfig updateBuildConfig(BuildConfig buildConfig) {
        return (BuildConfig)((BuildConfigResource)this.buildConfigs().withName(buildConfig.getMetadata().getName())).replace();
    }

    public BuildConfig updateBuildConfigEnvVars(String name, Map<String, String> envVars) {
        BuildConfig bc = this.getBuildConfig(name);
        List vars = envVars.entrySet().stream().map(x -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)x.getKey())).withValue((String)x.getValue())).build()).collect(Collectors.toList());
        bc.getSpec().getStrategy().getSourceStrategy().getEnv().removeIf(x -> envVars.containsKey(x.getName()));
        bc.getSpec().getStrategy().getSourceStrategy().getEnv().addAll(vars);
        return this.updateBuildConfig(bc);
    }

    public boolean deleteBuildConfig(BuildConfig buildConfig) {
        return !((BuildConfigResource)this.buildConfigs().resource((Object)buildConfig)).delete().isEmpty();
    }

    public ServiceAccount createServiceAccount(ServiceAccount serviceAccount) {
        return (ServiceAccount)((ServiceAccountResource)this.serviceAccounts().resource((Object)serviceAccount)).create();
    }

    public ServiceAccount getServiceAccount(String name) {
        return (ServiceAccount)((ServiceAccountResource)this.serviceAccounts().withName(name)).get();
    }

    public List<ServiceAccount> getServiceAccounts() {
        return ((ServiceAccountList)this.serviceAccounts().list()).getItems();
    }

    public List<ServiceAccount> getUserServiceAccounts() {
        return ((ServiceAccountList)((FilterWatchListDeletable)this.serviceAccounts().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems().stream().filter(sa -> !sa.getMetadata().getName().matches("builder|default|deployer")).collect(Collectors.toList());
    }

    public boolean deleteServiceAccount(ServiceAccount serviceAccount) {
        return !((ServiceAccountResource)this.serviceAccounts().resource((Object)serviceAccount)).delete().isEmpty();
    }

    public RoleBinding createRoleBinding(RoleBinding roleBinding) {
        return (RoleBinding)((Resource)this.rbac().roleBindings().resource((Object)roleBinding)).create();
    }

    public RoleBinding getRoleBinding(String name) {
        return (RoleBinding)((Resource)this.rbac().roleBindings().withName(name)).get();
    }

    public List<RoleBinding> getRoleBindings() {
        return ((RoleBindingList)this.rbac().roleBindings().list()).getItems();
    }

    public Role getRole(String name) {
        return (Role)((Resource)this.rbac().roles().withName(name)).get();
    }

    public List<Role> getRoles() {
        return ((RoleList)this.rbac().roles().list()).getItems();
    }

    public List<RoleBinding> getUserRoleBindings() {
        return ((RoleBindingList)((FilterWatchListDeletable)((FilterWatchListDeletable)this.rbac().roleBindings().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).withLabelNotIn("olm.owner.kind", new String[]{"ClusterServiceVersion"})).list()).getItems().stream().filter(rb -> !rb.getMetadata().getName().matches("admin|system:deployers|system:image-builders|system:image-pullers")).collect(Collectors.toList());
    }

    public boolean deleteRoleBinding(RoleBinding roleBinding) {
        return !((Resource)this.rbac().roleBindings().resource((Object)roleBinding)).delete().isEmpty();
    }

    public RoleBinding addRoleToUser(String roleName, String username) {
        return this.addRoleToUser(roleName, null, username);
    }

    public RoleBinding addRoleToUser(String roleName, String roleKind, String username) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(roleName);
        this.addSubjectToRoleBinding(roleBinding, "User", username, null);
        return this.updateRoleBinding(roleBinding);
    }

    public RoleBinding addRoleToServiceAccount(String roleName, String serviceAccountName) {
        return this.addRoleToServiceAccount(roleName, serviceAccountName, this.getNamespace());
    }

    public RoleBinding addRoleToServiceAccount(String roleName, String serviceAccountName, String namespace) {
        return this.addRoleToServiceAccount(roleName, null, serviceAccountName, namespace);
    }

    public RoleBinding addRoleToServiceAccount(String roleName, String roleKind, String serviceAccountName, String namespace) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(roleName, roleKind);
        this.addSubjectToRoleBinding(roleBinding, "ServiceAccount", serviceAccountName, namespace);
        return this.updateRoleBinding(roleBinding);
    }

    @Deprecated
    public RoleBinding addRoleToGroup(String roleName, String groupName) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(roleName);
        this.addSubjectToRoleBinding(roleBinding, "Group", groupName, null);
        return this.updateRoleBinding(roleBinding);
    }

    public RoleBinding addRoleToGroup(String roleName, String roleKind, String groupName) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(roleName, roleKind);
        this.addSubjectToRoleBinding(roleBinding, "Group", groupName, null);
        return this.updateRoleBinding(roleBinding);
    }

    private RoleBinding getOrCreateRoleBinding(String name) {
        return this.getOrCreateRoleBinding(name, null);
    }

    private RoleBinding getOrCreateRoleBinding(String name, String kind) {
        RoleBinding roleBinding = this.getRoleBinding(name);
        if (roleBinding == null) {
            if (kind == null) {
                kind = "Role";
                if (Arrays.asList("admin", "edit", "view").contains(name)) {
                    kind = "ClusterRole";
                }
            }
            roleBinding = ((RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(name)).endMetadata()).withNewRoleRef().withKind(kind)).withName(name)).endRoleRef()).build();
            this.createRoleBinding(roleBinding);
        }
        return roleBinding;
    }

    public RoleBinding updateRoleBinding(RoleBinding roleBinding) {
        return (RoleBinding)((Resource)this.rbac().roleBindings().withName(roleBinding.getMetadata().getName())).replace((Object)roleBinding);
    }

    private void addSubjectToRoleBinding(RoleBinding roleBinding, String entityKind, String entityName) {
        this.addSubjectToRoleBinding(roleBinding, entityKind, entityName, null);
    }

    private void addSubjectToRoleBinding(RoleBinding roleBinding, String entityKind, String entityName, String entityNamespace) {
        SubjectBuilder subjectBuilder = (SubjectBuilder)((SubjectBuilder)new SubjectBuilder().withKind(entityKind)).withName(entityName);
        if (entityNamespace != null) {
            subjectBuilder.withNamespace(entityNamespace);
        }
        Subject subject = subjectBuilder.build();
        if (roleBinding.getSubjects().stream().noneMatch(x -> x.getName().equals(subject.getName()) && x.getKind().equals(subject.getKind()))) {
            roleBinding.getSubjects().add(subject);
        }
    }

    public RoleBinding removeRoleFromServiceAccount(String roleName, String serviceAccountName) {
        return this.removeRoleFromEntity(roleName, "ServiceAccount", serviceAccountName);
    }

    public RoleBinding removeRoleFromEntity(String roleName, String entityKind, String entityName) {
        RoleBinding roleBinding = (RoleBinding)((Resource)this.rbac().roleBindings().withName(roleName)).get();
        if (roleBinding != null) {
            roleBinding.getSubjects().removeIf(s -> s.getName().equals(entityName) && s.getKind().equals(entityKind));
            return this.updateRoleBinding(roleBinding);
        }
        return null;
    }

    public ResourceQuota createResourceQuota(ResourceQuota resourceQuota) {
        return (ResourceQuota)((Resource)this.resourceQuotas().resource((Object)resourceQuota)).create();
    }

    public ResourceQuota getResourceQuota(String name) {
        return (ResourceQuota)((Resource)this.resourceQuotas().withName(name)).get();
    }

    public boolean deleteResourceQuota(ResourceQuota resourceQuota) {
        return !((Resource)this.resourceQuotas().resource((Object)resourceQuota)).delete().isEmpty();
    }

    public PersistentVolumeClaim createPersistentVolumeClaim(PersistentVolumeClaim pvc) {
        return (PersistentVolumeClaim)((Resource)this.persistentVolumeClaims().resource((Object)pvc)).create();
    }

    public PersistentVolumeClaim getPersistentVolumeClaim(String name) {
        return (PersistentVolumeClaim)((Resource)this.persistentVolumeClaims().withName(name)).get();
    }

    public List<PersistentVolumeClaim> getPersistentVolumeClaims() {
        return ((PersistentVolumeClaimList)this.persistentVolumeClaims().list()).getItems();
    }

    public boolean deletePersistentVolumeClaim(PersistentVolumeClaim pvc) {
        return !((Resource)this.persistentVolumeClaims().resource((Object)pvc)).delete().isEmpty();
    }

    public HorizontalPodAutoscaler createHorizontalPodAutoscaler(HorizontalPodAutoscaler hpa) {
        return (HorizontalPodAutoscaler)((Resource)this.autoscaling().v1().horizontalPodAutoscalers().resource((Object)hpa)).create();
    }

    public HorizontalPodAutoscaler getHorizontalPodAutoscaler(String name) {
        return (HorizontalPodAutoscaler)((Resource)this.autoscaling().v1().horizontalPodAutoscalers().withName(name)).get();
    }

    public List<HorizontalPodAutoscaler> getHorizontalPodAutoscalers() {
        return ((HorizontalPodAutoscalerList)this.autoscaling().v1().horizontalPodAutoscalers().list()).getItems();
    }

    public boolean deleteHorizontalPodAutoscaler(HorizontalPodAutoscaler hpa) {
        return !((Resource)this.autoscaling().v1().horizontalPodAutoscalers().resource((Object)hpa)).delete().isEmpty();
    }

    public ConfigMap createConfigMap(ConfigMap configMap) {
        return (ConfigMap)((Resource)this.configMaps().resource((Object)configMap)).create();
    }

    public ConfigMap getConfigMap(String name) {
        return (ConfigMap)((Resource)this.configMaps().withName(name)).get();
    }

    public List<ConfigMap> getConfigMaps() {
        return ((ConfigMapList)this.configMaps().list()).getItems();
    }

    public List<ConfigMap> getUserConfigMaps() {
        return ((ConfigMapList)((FilterWatchListDeletable)this.configMaps().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems().stream().filter(cm -> !cm.getMetadata().getName().equals("kube-root-ca.crt")).filter(cm -> !cm.getMetadata().getName().equals("openshift-service-ca.crt")).collect(Collectors.toList());
    }

    public boolean deleteConfigMap(ConfigMap configMap) {
        return !((Resource)this.configMaps().resource((Object)configMap)).delete().isEmpty();
    }

    public Template createTemplate(Template template) {
        return (Template)((TemplateResource)this.templates().resource((Object)template)).create();
    }

    public Template getTemplate(String name) {
        return (Template)((TemplateResource)this.templates().withName(name)).get();
    }

    public List<Template> getTemplates() {
        return ((TemplateList)this.templates().list()).getItems();
    }

    public boolean deleteTemplate(String name) {
        return !((TemplateResource)this.templates().withName(name)).delete().isEmpty();
    }

    public boolean deleteTemplate(Template template) {
        return !((TemplateResource)this.templates().resource((Object)template)).delete().isEmpty();
    }

    public Template loadAndCreateTemplate(InputStream is) {
        Template t = (Template)((TemplateResource)this.templates().load(is)).get();
        this.deleteTemplate(t);
        return this.createTemplate(t);
    }

    public KubernetesList recreateAndProcessTemplate(Template template, Map<String, String> parameters) {
        this.deleteTemplate(template.getMetadata().getName());
        this.createTemplate(template);
        return this.processTemplate(template.getMetadata().getName(), parameters);
    }

    public KubernetesList recreateAndProcessAndDeployTemplate(Template template, Map<String, String> parameters) {
        return this.createResources(this.recreateAndProcessTemplate(template, parameters));
    }

    public KubernetesList processTemplate(String name, Map<String, String> parameters) {
        ParameterValue[] values = this.processParameters(parameters);
        return ((TemplateResource)this.templates().withName(name)).process(values);
    }

    public KubernetesList processAndDeployTemplate(String name, Map<String, String> parameters) {
        return this.createResources(this.processTemplate(name, parameters));
    }

    private ParameterValue[] processParameters(Map<String, String> parameters) {
        return parameters.entrySet().stream().map(entry -> new ParameterValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new ParameterValue[parameters.size()]);
    }

    public Node getNode(String name) {
        return (Node)((Resource)this.nodes().withName(name)).get();
    }

    public List<Node> getNodes() {
        return ((NodeList)this.nodes().list()).getItems();
    }

    public List<Node> getNodes(Map<String, String> labels) {
        return ((NodeList)((FilterWatchListDeletable)this.nodes().withLabels(labels)).list()).getItems();
    }

    public cz.xtf.core.event.EventList getEventList() {
        return new cz.xtf.core.event.EventList(((EventList)this.v1().events().list()).getItems());
    }

    @Deprecated
    public List<Event> getEvents() {
        return ((EventList)this.v1().events().list()).getItems();
    }

    public LocalPortForward portForward(String deploymentConfigName, int remotePort, int localPort) {
        return this.portForward(this.getAnyPod(deploymentConfigName), remotePort, localPort);
    }

    public LocalPortForward portForward(Pod pod, int remotePort, int localPort) {
        return ((PodResource)this.pods().withName(pod.getMetadata().getName())).portForward(remotePort, localPort);
    }

    public PodShell podShell(String dcName) {
        return this.podShell(this.getAnyPod(dcName));
    }

    public PodShell podShell(Pod pod) {
        return new PodShell(this, pod);
    }

    public PodShell podShell(Pod pod, String containerName) {
        return new PodShell(this, pod, containerName);
    }

    public Waiter clean() {
        for (CustomResourceDefinitionContextProvider crdContextProvider : OpenShift.getCRDContextProviders()) {
            try {
                this.newHasMetadataOperation((ResourceDefinitionContext)crdContextProvider.getContext(), GenericKubernetesResource.class, GenericKubernetesResourceList.class).inNamespace(this.getNamespace()).delete();
                log.debug("DELETE :: " + crdContextProvider.getContext().getName() + " instances");
            }
            catch (KubernetesClientException kce) {
                log.debug(crdContextProvider.getContext().getName() + " might not be installed on the cluster.", (Throwable)kce);
            }
        }
        ((FilterWatchListDeletable)this.templates().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.apps().deployments().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.apps().replicaSets().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.apps().statefulSets().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.batch().v1().jobs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.deploymentConfigs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.replicationControllers().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.buildConfigs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.imageStreams().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.endpoints().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.services().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.builds().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.routes().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((PropagationPolicyConfigurable)((FilterWatchListDeletable)this.pods().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).withGracePeriod(0L)).delete();
        ((FilterWatchListDeletable)this.persistentVolumeClaims().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        ((FilterWatchListDeletable)this.autoscaling().v1().horizontalPodAutoscalers().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).delete();
        this.getUserConfigMaps().forEach(this::deleteConfigMap);
        this.getUserSecrets().forEach(this::deleteSecret);
        this.getUserServiceAccounts().forEach(sa -> this.deleteServiceAccount((ServiceAccount)sa));
        this.getUserRoleBindings().forEach(this::deleteRoleBinding);
        ((FilterWatchListDeletable)((FilterWatchListDeletable)this.rbac().roles().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).withLabelNotIn("olm.owner.kind", new String[]{"ClusterServiceVersion"})).delete();
        for (HasMetadata hasMetadata : this.listRemovableResources()) {
            log.warn("DELETE LEFTOVER :: " + hasMetadata.getKind() + "/" + hasMetadata.getMetadata().getName());
            ((Deletable)((PropagationPolicyConfigurable)this.resource(hasMetadata).withGracePeriod(0L)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
        }
        return this.waiters.isProjectClean();
    }

    List<HasMetadata> listRemovableResources() {
        ArrayList<HasMetadata> removables = new ArrayList<HasMetadata>();
        removables.addAll(((TemplateList)((FilterWatchListDeletable)this.templates().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((DeploymentList)((FilterWatchListDeletable)this.apps().deployments().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((ReplicaSetList)((FilterWatchListDeletable)this.apps().replicaSets().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((JobList)((FilterWatchListDeletable)this.batch().v1().jobs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((DeploymentConfigList)((FilterWatchListDeletable)this.deploymentConfigs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((StatefulSetList)((FilterWatchListDeletable)this.apps().statefulSets().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((ReplicationControllerList)((FilterWatchListDeletable)this.replicationControllers().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((BuildConfigList)((FilterWatchListDeletable)this.buildConfigs().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((ImageStreamList)((FilterWatchListDeletable)this.imageStreams().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((EndpointsList)((FilterWatchListDeletable)this.endpoints().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((ServiceList)((FilterWatchListDeletable)this.services().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((BuildList)((FilterWatchListDeletable)this.builds().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((RouteList)((FilterWatchListDeletable)this.routes().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((PodList)((FilterWatchListDeletable)this.pods().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((PersistentVolumeClaimList)((FilterWatchListDeletable)this.persistentVolumeClaims().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(((HorizontalPodAutoscalerList)((FilterWatchListDeletable)this.autoscaling().v1().horizontalPodAutoscalers().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).list()).getItems());
        removables.addAll(this.getUserConfigMaps());
        removables.addAll(this.getUserSecrets());
        removables.addAll(this.getUserServiceAccounts());
        removables.addAll(this.getUserRoleBindings());
        removables.addAll(((RoleList)((FilterWatchListDeletable)((FilterWatchListDeletable)this.rbac().roles().withLabelNotIn(KEEP_LABEL, new String[]{"", "true"})).withLabelNotIn("olm.owner.kind", new String[]{"ClusterServiceVersion"})).list()).getItems());
        return removables;
    }

    public Path storePodLog(Pod pod, Path dirPath, String fileName) throws IOException {
        String log = this.getPodLog(pod);
        return this.storeLog(log, dirPath, fileName);
    }

    public Path storeBuildLog(Build build, Path dirPath, String fileName) throws IOException {
        String log = this.getBuildLog(build);
        return this.storeLog(log, dirPath, fileName);
    }

    private Path storeLog(String log, Path dirPath, String fileName) throws IOException {
        Path filePath = dirPath.resolve(fileName);
        Files.createDirectories(dirPath, new FileAttribute[0]);
        Files.createFile(filePath, new FileAttribute[0]);
        Files.write(filePath, log.getBytes(), new OpenOption[0]);
        return filePath;
    }

    @Deprecated
    public OpenShiftWaiters waiters() {
        return this.waiters;
    }

    private static boolean isEqualOpenshiftConfig(OpenShiftConfig newConfig, OpenShiftConfig existingConfig) {
        return new EqualsBuilder().append((Object)newConfig.getOpenShiftUrl(), (Object)existingConfig.getOpenShiftUrl()).append((Object)newConfig.getNamespace(), (Object)existingConfig.getNamespace()).append((Object)newConfig.getUsername(), (Object)existingConfig.getUsername()).append((Object)newConfig.getPassword(), (Object)existingConfig.getPassword()).append((Object)newConfig.getOauthToken(), (Object)existingConfig.getOauthToken()).append(newConfig.isTrustCerts(), existingConfig.isTrustCerts()).isEquals();
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> newHasMetadataOperation(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl((Client)this, rdContext, resourceType, listClass);
    }

    static {
        namespaceToOpenshiftClientMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    }
}

