/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.openshift.CLIUtils;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinary {
    private static final Logger log = LoggerFactory.getLogger(OpenShiftBinary.class);
    private final String path;
    private String ocConfigPath;

    public OpenShiftBinary(String path) {
        this.path = path;
    }

    public OpenShiftBinary(String path, String ocConfigPath) {
        this(path);
        this.ocConfigPath = ocConfigPath;
    }

    public void login(String url, String token) {
        this.execute("login", url, "--insecure-skip-tls-verify=true", "--token=" + token);
    }

    public void login(String url, String username, String password) {
        this.execute("login", url, "--insecure-skip-tls-verify=true", "-u", username, "-p", password);
    }

    public void apply(String namespace, String sourcePath) {
        this.execute("apply", "--namespace=" + namespace, "--filename=" + sourcePath);
    }

    public void apply(String sourcePath) {
        this.execute("apply", "--filename=" + sourcePath);
    }

    public void apply(List<String> sourcePaths) {
        for (String sourcePath : sourcePaths) {
            this.apply(sourcePath);
        }
    }

    public void apply(String namespace, List<String> sourcePaths) {
        for (String sourcePath : sourcePaths) {
            this.apply(namespace, sourcePath);
        }
    }

    public void project(String projectName) {
        this.execute("project", projectName);
    }

    public void startBuild(String buildConfig, String sourcePath) {
        this.execute("start-build", buildConfig, "--from-dir=" + sourcePath);
    }

    public String execute(String ... args) {
        if (this.ocConfigPath == null) {
            return CLIUtils.executeCommand((String[])ArrayUtils.addAll((Object[])new String[]{this.path}, (Object[])args));
        }
        return CLIUtils.executeCommand((String[])ArrayUtils.addAll((Object[])new String[]{this.path, "--kubeconfig=" + this.ocConfigPath}, (Object[])args));
    }

    public String getOcConfigPath() {
        return this.ocConfigPath;
    }
}

