/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.image;

import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.image.UnknownImageException;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.util.ArrayList;
import java.util.Arrays;

public class Image {
    private final String url;
    private final String registry;
    private final String user;
    private final String repo;
    private final String tag;

    public static Image get(String id) {
        String imageUrl = XTFConfig.get("xtf." + id + ".image");
        return imageUrl == null ? null : Image.from(imageUrl);
    }

    public static Image resolve(String id) {
        String subid = XTFConfig.get("xtf." + id + ".subid");
        Image image = Image.get(id + "." + subid);
        if (image != null) {
            String customReg = XTFConfig.get("xtf." + id + ".reg");
            String customRegId = XTFConfig.get("xtf." + id + ".regid");
            String customUser = XTFConfig.get("xtf." + id + ".user");
            String customTag = XTFConfig.get("xtf." + id + ".tag");
            String reg = customRegId != null ? XTFConfig.get("xtf.registry." + customRegId) : customReg;
            reg = reg != null ? reg : image.getRegistry();
            String user = customUser != null ? customUser : image.getUser();
            String tag = customTag != null ? customTag : image.getTag();
            return new Image(reg, user, image.getRepo(), tag);
        }
        image = Image.get(id);
        if (image != null) {
            return image;
        }
        throw new UnknownImageException("Unable to get image using " + id + " or " + subid);
    }

    public static Image from(String imageUrl) {
        String tag;
        String repo;
        String repoTag;
        String user;
        String registry;
        String[] slashTokens = imageUrl.split("/");
        switch (slashTokens.length) {
            case 1: {
                registry = "";
                user = "";
                repoTag = slashTokens[0];
                break;
            }
            case 2: {
                registry = "";
                user = slashTokens[0];
                repoTag = slashTokens[1];
                break;
            }
            case 3: {
                registry = slashTokens[0];
                user = slashTokens[1];
                repoTag = slashTokens[2];
                break;
            }
            default: {
                registry = slashTokens[0];
                user = slashTokens[1];
                repoTag = String.join((CharSequence)"/", Arrays.copyOfRange(slashTokens, 2, slashTokens.length));
            }
        }
        String[] tokens = repoTag.split(":");
        switch (tokens.length) {
            case 1: {
                repo = tokens[0];
                tag = "";
                break;
            }
            case 2: {
                repo = tokens[0];
                tag = tokens[1];
                break;
            }
            default: {
                throw new IllegalArgumentException("repoTag '" + repoTag + "' should have zero or two ':' characters");
            }
        }
        return new Image(registry, user, repo, tag);
    }

    public Image(String registry, String user, String repo, String tag) {
        this.url = String.format("%s/%s/%s:%s", registry, user, repo, tag);
        this.registry = registry;
        this.user = user;
        this.repo = repo;
        this.tag = tag;
    }

    public String getMajorTag() {
        return this.tag.replaceAll("-.*", "");
    }

    public ImageStream getImageStream() {
        return this.getImageStream(this.repo);
    }

    public ImageStream getImageStream(String name) {
        return this.getImageStream(name, this.getMajorTag());
    }

    public ImageStream getImageStream(String name, String ... tags) {
        ArrayList<TagReference> tagRefs = new ArrayList<TagReference>(tags.length);
        for (String tag : tags) {
            tagRefs.add(((TagReferenceBuilder)((TagReferenceFluent.FromNested)((TagReferenceFluent.FromNested)((TagReferenceBuilder)((TagReferenceFluent.ImportPolicyNested)((TagReferenceBuilder)new TagReferenceBuilder().withName(tag)).withNewImportPolicy().withInsecure(Boolean.valueOf(true))).and()).withNewFrom().withKind("DockerImage")).withName(this.url)).endFrom()).build());
        }
        return ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).addToAnnotations("openshift.io/image.insecureRepository", "true")).and()).withNewSpec().withTags(tagRefs)).endSpec()).build();
    }

    public boolean isVersionAtLeast(String version) {
        String majorTag = this.getMajorTag();
        if (this.getMajorTag().matches("[0-9]+\\.[0-9]+")) {
            int imageMajor = Integer.valueOf(majorTag.split("\\.")[0]);
            int imageMinor = Integer.valueOf(majorTag.split("\\.")[1]);
            int targetMajor = Integer.valueOf(version.split("\\.")[0]);
            int targetMinor = Integer.valueOf(version.split("\\.")[1]);
            return imageMajor >= targetMajor && imageMinor >= targetMinor;
        }
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getUser() {
        return this.user;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getTag() {
        return this.tag;
    }
}

