/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting;

import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.waiting.Waiter;
import cz.xtf.core.waiting.WaiterException;
import cz.xtf.core.waiting.failfast.ExponentialTimeBackoff;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.event.Level;

public class SupplierWaiter<X>
implements Waiter {
    private Supplier<X> supplier;
    private Function<X, Boolean> successCondition;
    private Function<X, Boolean> failureCondition;
    private Runnable onIteration;
    private Runnable onSuccess;
    private Runnable onFailure;
    private Runnable onTimeout;
    private long timeout;
    private long interval;
    private String reason;
    private Waiter.LogPoint logPoint;
    private Level level;
    private FailFastCheck failFast;

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition) {
        this(supplier, successCondition, (X x) -> false);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, Function<X, Boolean> failureCondition) {
        this(supplier, successCondition, failureCondition, TimeUnit.MILLISECONDS, WaitingConfig.timeout());
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, String reason) {
        this(supplier, successCondition, (X x) -> false, reason);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, Function<X, Boolean> failureCondition, String reason) {
        this(supplier, successCondition, failureCondition, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), reason);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, TimeUnit timeoutUnit, long timeout) {
        this(supplier, successCondition, (X x) -> false, timeoutUnit, timeout);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, TimeUnit timeoutUnit, long timeout, String reason) {
        this(supplier, successCondition, x -> false, timeoutUnit, timeout, reason);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, Function<X, Boolean> failureCondition, TimeUnit timeoutUnit, long timeout) {
        this(supplier, successCondition, failureCondition, timeoutUnit, timeout, null);
    }

    public SupplierWaiter(Supplier<X> supplier, Function<X, Boolean> successCondition, Function<X, Boolean> failureCondition, TimeUnit timeoutUnit, long timeout, String reason) {
        this.supplier = supplier;
        this.successCondition = successCondition;
        this.failureCondition = failureCondition;
        this.onIteration = () -> {};
        this.onSuccess = () -> {};
        this.onFailure = () -> {};
        this.onTimeout = () -> {};
        this.failFast = () -> false;
        this.interval = 1000L;
        this.timeout = timeoutUnit.toMillis(timeout);
        this.reason = reason;
        this.level = WaitingConfig.level();
        this.logPoint = reason == null ? Waiter.LogPoint.NONE : Waiter.LogPoint.START;
    }

    @Override
    public SupplierWaiter timeout(long millis) {
        this.timeout = millis;
        return this;
    }

    @Override
    public SupplierWaiter timeout(TimeUnit timeUnit, long t) {
        this.timeout = timeUnit.toMillis(t);
        return this;
    }

    @Override
    public SupplierWaiter interval(long millis) {
        this.interval = millis;
        return this;
    }

    @Override
    public SupplierWaiter interval(TimeUnit timeUnit, long t) {
        this.interval = timeUnit.toMillis(t);
        return this;
    }

    @Override
    public SupplierWaiter reason(String reason) {
        this.reason = reason;
        this.logPoint = Waiter.LogPoint.START;
        return this;
    }

    @Override
    public SupplierWaiter logPoint(Waiter.LogPoint logPoint) {
        this.logPoint = logPoint;
        return this;
    }

    @Override
    public SupplierWaiter level(Level level) {
        this.level = level;
        return this;
    }

    @Override
    public SupplierWaiter onIteration(Runnable runnable) {
        this.onIteration = runnable;
        return this;
    }

    @Override
    public SupplierWaiter onSuccess(Runnable runnable) {
        this.onSuccess = runnable;
        return this;
    }

    @Override
    public SupplierWaiter onFailure(Runnable runnable) {
        this.onFailure = runnable;
        return this;
    }

    @Override
    public SupplierWaiter onTimeout(Runnable runnable) {
        this.onTimeout = runnable;
        return this;
    }

    @Override
    public SupplierWaiter failFast(FailFastCheck failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public boolean waitFor() {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.timeout;
        this.logPoint.logStart(this.reason, this.timeout, this.level);
        ExponentialTimeBackoff backoff = ExponentialTimeBackoff.builder().blocking(false).maxBackoff(32000L).build();
        while (System.currentTimeMillis() < endTime) {
            if (backoff.next() && this.failFast.hasFailed()) {
                this.logPoint.logEnd(this.reason + " (fail fast method failure)", System.currentTimeMillis() - startTime, this.level);
                throw new WaiterException(this.failFast.reason());
            }
            X x = this.supplier.get();
            if (this.failureCondition.apply(x).booleanValue()) {
                this.logPoint.logEnd(this.reason + " (Failure)", System.currentTimeMillis() - startTime, this.level);
                this.onFailure.run();
                return false;
            }
            if (this.successCondition.apply(x).booleanValue()) {
                this.logPoint.logEnd(this.reason + " (Success)", System.currentTimeMillis() - startTime, this.level);
                this.onSuccess.run();
                return true;
            }
            this.onIteration.run();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                throw new WaiterException("Thread has been interrupted!");
            }
        }
        this.logPoint.logEnd(this.reason + "(Timeout)", this.timeout, this.level);
        this.onTimeout.run();
        throw new WaiterException(this.reason);
    }
}

