/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLIUtils {
    private static final Logger log = LoggerFactory.getLogger(CLIUtils.class);
    private static final Pattern TOKEN_EQ = Pattern.compile("--token=\\S+");
    private static final Pattern TOKEN_SPACE = Pattern.compile("--token\\s+\\S+");
    private static final Pattern T_EQ = Pattern.compile("-t=\\S+");
    private static final Pattern T_SPACE = Pattern.compile("-t\\s+\\S+");
    private static final Pattern PASSWORD_EQ = Pattern.compile("--password=\\S+");
    private static final Pattern PASSWORD_SPACE = Pattern.compile("--password\\s+\\S+");
    private static final Pattern P_EQ = Pattern.compile("-p=\\S+");
    private static final Pattern P_SPACE = Pattern.compile("-p\\s+\\S+");
    private static final Function<String, String> DEFAULT_MASK_FUNCTION = s -> {
        s = TOKEN_EQ.matcher((CharSequence)s).replaceAll("--token=***");
        s = TOKEN_SPACE.matcher((CharSequence)s).replaceAll("--token ***");
        s = T_EQ.matcher((CharSequence)s).replaceAll("-t=***");
        s = T_SPACE.matcher((CharSequence)s).replaceAll("-t ***");
        s = PASSWORD_EQ.matcher((CharSequence)s).replaceAll("--password=***");
        s = PASSWORD_SPACE.matcher((CharSequence)s).replaceAll("--password ***");
        s = P_EQ.matcher((CharSequence)s).replaceAll("-p=***");
        s = P_SPACE.matcher((CharSequence)s).replaceAll("-p ***");
        return s;
    };

    public static String executeCommand(Map<String, String> environmentVariables, String ... args) {
        return CLIUtils.executeCommand(environmentVariables, DEFAULT_MASK_FUNCTION, args);
    }

    private static String executeCommand(Map<String, String> environmentVariables, Function<String, String> maskFunction, String ... args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().putAll(environmentVariables);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        String commandString = String.join((CharSequence)" ", args);
        String maskedCommandString = maskFunction.apply(commandString);
        try {
            log.debug("executing local command: {}", (Object)maskedCommandString);
            Process p = pb.start();
            ExecutorService es = Executors.newFixedThreadPool(2);
            Future<String> out = es.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
            Future<String> err = es.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
            int result = p.waitFor();
            es.shutdown();
            if (result == 0) {
                String commandOutput = out.get();
                log.debug(commandOutput);
                return commandOutput;
            }
            log.error("Failed while executing (code {}): {}", (Object)result, (Object)maskedCommandString);
            log.error("stdout:\n{}", (Object)out.get());
            log.error("stderr:\n{}", (Object)err.get());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error("Failed while executing: " + maskedCommandString, (Throwable)e);
        }
        return null;
    }

    public static String executeCommand(String ... args) {
        return CLIUtils.executeCommand(Collections.emptyMap(), args);
    }
}

