/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.http.Https;
import cz.xtf.core.http.HttpsException;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterVersionInfo {
    private static final Logger log = LoggerFactory.getLogger(ClusterVersionInfo.class);
    private static final Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+)(\\.\\d+)?(-.*)?$");
    private final String openshiftVersion = StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.version()) ? OpenShiftConfig.version() : this.detectClusterVersionFromCluster();
    private final Matcher versionMatcher = this.openshiftVersion != null ? this.validateConfiguredVersion(this.openshiftVersion) : null;

    ClusterVersionInfo() {
    }

    public String getOpenshiftVersion() {
        return this.openshiftVersion;
    }

    String getMajorMinorOpenshiftVersion() {
        if (this.openshiftVersion != null && this.versionMatcher.groupCount() >= 1) {
            return this.versionMatcher.group(1);
        }
        return null;
    }

    boolean isMajorMinorOnly() {
        if (this.openshiftVersion != null && this.versionMatcher.groupCount() >= 1) {
            return this.versionMatcher.group(2) == null && this.versionMatcher.group(3) == null;
        }
        return false;
    }

    boolean isMajorMinorMicro() {
        if (this.openshiftVersion != null && this.versionMatcher.groupCount() >= 2) {
            return this.versionMatcher.group(2) != null;
        }
        return false;
    }

    boolean isReleaseCandidate() {
        if (this.openshiftVersion != null && this.versionMatcher.groupCount() >= 3) {
            return Optional.ofNullable(this.versionMatcher.group(3)).orElse("").contains("-rc.");
        }
        return false;
    }

    boolean isDeveloperPreview() {
        if (this.openshiftVersion != null && this.versionMatcher.groupCount() >= 3) {
            return this.versionMatcher.group(3) != null && !this.isReleaseCandidate();
        }
        return false;
    }

    private String detectClusterVersionFromCluster() {
        String openshiftVersion = null;
        try {
            String versionInfo = Https.httpsGetContent(OpenShiftConfig.url() + "/version/openshift");
            openshiftVersion = ModelNode.fromJSONString((String)versionInfo).get("gitVersion").asString().replaceAll("^v(.*)", "$1");
        }
        catch (HttpsException he) {
            try {
                openshiftVersion = OpenShifts.admin().getOpenShiftV4Version();
            }
            catch (KubernetesClientException kce) {
                log.warn("xtf.openshift.version isn't configured and automatic version detection failed.", (Throwable)kce);
            }
        }
        return openshiftVersion;
    }

    private Matcher validateConfiguredVersion(String version) {
        Objects.requireNonNull(version);
        Matcher matcher = versionPattern.matcher(version);
        if (!matcher.matches()) {
            log.warn("Version {} configured in xtf.openshift.version isn't in expected format 'major.minor[.micro]'.", (Object)version);
        }
        return matcher;
    }
}

