/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.bm.BuildManagers;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.junit5.annotations.OpenShiftRecorder;
import cz.xtf.junit5.config.JUnitConfig;
import cz.xtf.junit5.extensions.helpers.EventsFilterBuilder;
import cz.xtf.junit5.extensions.helpers.ResourcesFilterBuilder;
import cz.xtf.junit5.extensions.helpers.ResourcesPrinterHelper;
import cz.xtf.junit5.extensions.helpers.ResourcesTimestampHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftRecorderHandler
implements TestWatcher,
TestExecutionExceptionHandler,
BeforeAllCallback,
BeforeEachCallback,
LifecycleMethodExecutionExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(OpenShiftRecorderHandler.class);
    private static final String FILTER_FOR_BEFORE_ALL_DONE = "RESOURCES_FOR_BEFORE_ALL_RECORDED";
    private static final String POD_FILTER_MASTER = "POD_FILTER_MASTER";
    private static final String DC_FILTER_MASTER = "DC_FILTER_MASTER";
    private static final String BUILD_FILTER_MASTER = "BUILD_FILTER_MASTER";
    private static final String BC_FILTER_MASTER = "BC_FILTER_MASTER";
    private static final String IS_FILTER_MASTER = "IS_FILTER_MASTER";
    private static final String SS_FILTER_MASTER = "SS_FILTER_MASTER";
    private static final String ROUTE_FILTER_MASTER = "ROUTE_FILTER_MASTER";
    private static final String CONFIGMAP_FILTER_MASTER = "CONFIGMAP_FILTER_MASTER";
    private static final String SERVICE_FILTER_MASTER = "SERVICE_FILTER_MASTER";
    private static final String EVENT_FILTER_MASTER = "EVENT_FILTER_MASTER";
    private static final String POD_FILTER_BUILDS = "POD_FILTER_BUILDS";
    private static final String BUILD_FILTER_BUILDS = "BUILD_METHOD_FILTER_BUILDS";
    private static final String BC_FILTER_BUILDS = "BC_FILTER_BUILDS";
    private static final String IS_FILTER_BUILDS = "IS_FILTER_BUILDS";
    private static final String EVENT_FILTER_BUILDS = "EVENT_FILTER_BUILDS";

    public void beforeAll(ExtensionContext context) {
        ExtensionContext.Store classStore = this.getClassStore(context);
        OpenShift master = OpenShifts.master();
        OpenShift bm = BuildManagers.get().openShift();
        this.initClassFilter(context, POD_FILTER_MASTER, master, Pod.class);
        this.initClassFilter(context, DC_FILTER_MASTER, master, DeploymentConfig.class);
        this.initClassFilter(context, BUILD_FILTER_MASTER, master, Build.class);
        this.initClassFilter(context, BC_FILTER_MASTER, master, BuildConfig.class);
        this.initClassFilter(context, IS_FILTER_MASTER, master, ImageStream.class);
        this.initClassFilter(context, SS_FILTER_MASTER, master, StatefulSet.class);
        this.initClassFilter(context, ROUTE_FILTER_MASTER, master, Route.class);
        this.initClassFilter(context, CONFIGMAP_FILTER_MASTER, master, ConfigMap.class);
        this.initClassFilter(context, SERVICE_FILTER_MASTER, master, Service.class);
        classStore.put((Object)EVENT_FILTER_MASTER, (Object)new EventsFilterBuilder().setExcludedUntil(ResourcesTimestampHelper.timeOfLastEvent(master)));
        if (!this.isMasterAndBuildNamespaceSame()) {
            this.initClassFilter(context, POD_FILTER_BUILDS, bm, Pod.class);
            this.initClassFilter(context, BUILD_FILTER_BUILDS, bm, Build.class);
            this.initClassFilter(context, BC_FILTER_BUILDS, bm, BuildConfig.class);
            this.initClassFilter(context, IS_FILTER_BUILDS, bm, ImageStream.class);
            classStore.put((Object)EVENT_FILTER_BUILDS, (Object)new EventsFilterBuilder().setExcludedUntil(ResourcesTimestampHelper.timeOfLastEvent(bm)));
        }
        classStore.put((Object)FILTER_FOR_BEFORE_ALL_DONE, (Object)new AtomicBoolean(false));
    }

    private void initClassFilter(ExtensionContext context, String key, OpenShift openShift, Class<? extends HasMetadata> resourceClass) {
        ExtensionContext.Store classStore = this.getClassStore(context);
        classStore.put((Object)key, (Object)new ResourcesFilterBuilder().setExcludedUntil(ResourcesTimestampHelper.timeOfLastResourceOf(openShift, resourceClass)));
    }

    private void updateClassFilterBeforeAllResources(ExtensionContext context, String key, OpenShift openShift, Class<? extends HasMetadata> resourceClass) {
        ExtensionContext.Store classStore = this.getClassStore(context);
        ((ResourcesFilterBuilder)classStore.get((Object)key, ResourcesFilterBuilder.class)).setIncludedAlwaysWindow(((ResourcesFilterBuilder)classStore.get((Object)key, ResourcesFilterBuilder.class)).getExcludedUntil(), ResourcesTimestampHelper.timeOfLastResourceOf(openShift, resourceClass)).setExcludedUntil(null);
    }

    private void initMethodFilter(ExtensionContext context, String key, OpenShift openShift, Class<? extends HasMetadata> resourceClass) {
        ExtensionContext.Store classStore = this.getClassStore(context);
        ExtensionContext.Store methodStore = this.getMethodStore(context);
        try {
            methodStore.put((Object)key, (Object)((ResourcesFilterBuilder)((ResourcesFilterBuilder)classStore.get((Object)key, ResourcesFilterBuilder.class)).clone()).setExcludedUntil(ResourcesTimestampHelper.timeOfLastResourceOf(openShift, resourceClass)));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store classStore = this.getClassStore(context);
        ExtensionContext.Store methodStore = this.getMethodStore(context);
        OpenShift master = OpenShifts.master();
        OpenShift bm = BuildManagers.get().openShift();
        if (!((AtomicBoolean)classStore.get((Object)FILTER_FOR_BEFORE_ALL_DONE, AtomicBoolean.class)).get()) {
            this.updateClassFilterBeforeAllResources(context, POD_FILTER_MASTER, master, Pod.class);
            this.updateClassFilterBeforeAllResources(context, DC_FILTER_MASTER, master, DeploymentConfig.class);
            this.updateClassFilterBeforeAllResources(context, BUILD_FILTER_MASTER, master, Build.class);
            this.updateClassFilterBeforeAllResources(context, BC_FILTER_MASTER, master, BuildConfig.class);
            this.updateClassFilterBeforeAllResources(context, IS_FILTER_MASTER, master, ImageStream.class);
            this.updateClassFilterBeforeAllResources(context, SS_FILTER_MASTER, master, StatefulSet.class);
            this.updateClassFilterBeforeAllResources(context, ROUTE_FILTER_MASTER, master, Route.class);
            this.updateClassFilterBeforeAllResources(context, CONFIGMAP_FILTER_MASTER, master, ConfigMap.class);
            this.updateClassFilterBeforeAllResources(context, SERVICE_FILTER_MASTER, master, Service.class);
            this.updateClassFilterBeforeAllResources(context, EVENT_FILTER_MASTER, master, Event.class);
            if (!this.isMasterAndBuildNamespaceSame()) {
                this.updateClassFilterBeforeAllResources(context, POD_FILTER_BUILDS, bm, Pod.class);
                this.updateClassFilterBeforeAllResources(context, BUILD_FILTER_BUILDS, bm, Build.class);
                this.updateClassFilterBeforeAllResources(context, BC_FILTER_BUILDS, bm, BuildConfig.class);
                this.updateClassFilterBeforeAllResources(context, IS_FILTER_BUILDS, bm, ImageStream.class);
                this.updateClassFilterBeforeAllResources(context, EVENT_FILTER_BUILDS, bm, Event.class);
            }
            ((AtomicBoolean)classStore.get((Object)FILTER_FOR_BEFORE_ALL_DONE, AtomicBoolean.class)).set(true);
        }
        this.initMethodFilter(context, POD_FILTER_MASTER, master, Pod.class);
        this.initMethodFilter(context, DC_FILTER_MASTER, master, DeploymentConfig.class);
        this.initMethodFilter(context, BUILD_FILTER_MASTER, master, Build.class);
        this.initMethodFilter(context, BC_FILTER_MASTER, master, BuildConfig.class);
        this.initMethodFilter(context, IS_FILTER_MASTER, master, ImageStream.class);
        this.initMethodFilter(context, SS_FILTER_MASTER, master, StatefulSet.class);
        this.initMethodFilter(context, ROUTE_FILTER_MASTER, master, Route.class);
        this.initMethodFilter(context, CONFIGMAP_FILTER_MASTER, master, Route.class);
        this.initMethodFilter(context, SERVICE_FILTER_MASTER, master, Service.class);
        this.initMethodFilter(context, EVENT_FILTER_MASTER, master, Event.class);
        if (!this.isMasterAndBuildNamespaceSame()) {
            this.initMethodFilter(context, POD_FILTER_BUILDS, bm, Pod.class);
            this.initMethodFilter(context, BUILD_FILTER_BUILDS, bm, Build.class);
            this.initMethodFilter(context, BC_FILTER_BUILDS, bm, BuildConfig.class);
            this.initMethodFilter(context, IS_FILTER_BUILDS, bm, ImageStream.class);
            this.initMethodFilter(context, EVENT_FILTER_BUILDS, bm, Event.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            this.recordState(context);
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            if (JUnitConfig.recordBefore()) {
                this.recordState(context);
            }
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            if (JUnitConfig.recordBefore()) {
                this.recordState(context);
            }
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    public void testSuccessful(ExtensionContext context) {
        if (JUnitConfig.recordAlways()) {
            try {
                this.recordState(context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void recordState(ExtensionContext context) throws IOException {
        this.savePods(context, this.getFilter(context, POD_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, POD_FILTER_BUILDS) : null);
        this.saveDCs(context, this.getFilter(context, DC_FILTER_MASTER));
        this.saveBuilds(context, this.getFilter(context, BUILD_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, BUILD_FILTER_BUILDS) : null);
        this.saveBCs(context, this.getFilter(context, BC_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, BC_FILTER_BUILDS) : null);
        this.saveISs(context, this.getFilter(context, IS_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, IS_FILTER_BUILDS) : null);
        this.saveStatefulsets(context, this.getFilter(context, SS_FILTER_MASTER));
        this.saveRoutes(context, this.getFilter(context, ROUTE_FILTER_MASTER));
        this.saveConfigMaps(context, this.getFilter(context, CONFIGMAP_FILTER_MASTER));
        this.saveServices(context, this.getFilter(context, SERVICE_FILTER_MASTER));
        this.saveSecrets(context);
        this.savePodLogs(context, this.getFilter(context, POD_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, POD_FILTER_BUILDS) : null);
        this.saveEvents(context, this.getFilter(context, EVENT_FILTER_MASTER), !this.isMasterAndBuildNamespaceSame() ? this.getFilter(context, EVENT_FILTER_BUILDS) : null);
    }

    private <E extends HasMetadata> ResourcesFilterBuilder<E> getFilter(ExtensionContext context, String key) {
        ResourcesFilterBuilder filter;
        OpenShiftRecorder classOpenShiftRecorder = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), OpenShiftRecorder.class).orElse(null);
        OpenShiftRecorder methodOpenShiftRecorder = AnnotationSupport.findAnnotation((Optional)context.getElement(), OpenShiftRecorder.class).orElse(null);
        OpenShiftRecorder openShiftRecorder = methodOpenShiftRecorder != null ? methodOpenShiftRecorder : classOpenShiftRecorder;
        String[] resourceNames = openShiftRecorder != null ? openShiftRecorder.resourceNames() : null;
        ResourcesFilterBuilder resourcesFilterBuilder = filter = context.getTestMethod().isPresent() ? (ResourcesFilterBuilder)this.getMethodStore(context).get((Object)key, ResourcesFilterBuilder.class) : (ResourcesFilterBuilder)this.getClassStore(context).get((Object)key, ResourcesFilterBuilder.class);
        if (!(resourceNames == null || resourceNames.length == 1 && resourceNames[0].equals(""))) {
            filter.filterByResourceNames();
            filter.setResourceNames(resourceNames);
        } else {
            filter.filterByLastSeenResources();
        }
        return filter;
    }

    private void saveStatefulsets(ExtensionContext context, ResourcesFilterBuilder<StatefulSet> masterFilter) throws IOException {
        Path StatefulSetsLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "statefulSets.log");
        try (ResourcesPrinterHelper<StatefulSet> printer = ResourcesPrinterHelper.forStatefulSet(StatefulSetsLogPath);){
            OpenShifts.master().getStatefulSets().stream().filter(masterFilter.build()).forEach(printer::row);
        }
    }

    private void saveISs(ExtensionContext context, ResourcesFilterBuilder<ImageStream> masterFilter, ResourcesFilterBuilder<ImageStream> buildsFilter) throws IOException {
        Path imageStreamsMasterLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "imageStreams-" + OpenShifts.master().getNamespace() + ".log");
        try (ResourcesPrinterHelper<ImageStream> printer = ResourcesPrinterHelper.forISs(imageStreamsMasterLogPath);){
            OpenShifts.master().getImageStreams().stream().filter(masterFilter.build()).forEach(printer::row);
        }
        if (!this.isMasterAndBuildNamespaceSame()) {
            Path imageStreamsBMLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "imageStreams-" + BuildManagers.get().openShift().getNamespace() + ".log");
            try (ResourcesPrinterHelper<ImageStream> printer = ResourcesPrinterHelper.forISs(imageStreamsBMLogPath);){
                BuildManagers.get().openShift().getImageStreams().stream().filter(buildsFilter.build()).forEach(printer::row);
            }
        }
    }

    private void saveBCs(ExtensionContext context, ResourcesFilterBuilder<BuildConfig> masterFilter, ResourcesFilterBuilder<BuildConfig> buildsFilter) throws IOException {
        Path bcMasterLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "buildConfigs-" + OpenShifts.master().getNamespace() + ".log");
        try (ResourcesPrinterHelper<BuildConfig> printer = ResourcesPrinterHelper.forBCs(bcMasterLogPath);){
            OpenShifts.master().getBuildConfigs().stream().filter(masterFilter.build()).forEach(printer::row);
        }
        if (!this.isMasterAndBuildNamespaceSame()) {
            Path bcBMLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "buildConfigs-" + BuildManagers.get().openShift().getNamespace() + ".log");
            try (ResourcesPrinterHelper<BuildConfig> printer = ResourcesPrinterHelper.forBCs(bcBMLogPath);){
                BuildManagers.get().openShift().getBuildConfigs().stream().filter(buildsFilter.build()).forEach(printer::row);
            }
        }
    }

    private void saveBuilds(ExtensionContext context, ResourcesFilterBuilder<Build> masterFilter, ResourcesFilterBuilder<Build> buildsFilter) throws IOException {
        Path buildsMasterLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "builds-" + OpenShifts.master().getNamespace() + ".log");
        try (ResourcesPrinterHelper<Build> printer = ResourcesPrinterHelper.forBuilds(buildsMasterLogPath);){
            OpenShifts.master().getBuilds().stream().filter(masterFilter.build()).forEach(printer::row);
        }
        if (!this.isMasterAndBuildNamespaceSame()) {
            Path buildsBMLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "builds-" + BuildManagers.get().openShift().getNamespace() + ".log");
            try (ResourcesPrinterHelper<Build> printer = ResourcesPrinterHelper.forBuilds(buildsBMLogPath);){
                BuildManagers.get().openShift().getBuilds().stream().filter(buildsFilter.build()).forEach(printer::row);
            }
        }
    }

    private void saveSecrets(ExtensionContext context) throws IOException {
        Path secretsLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "secrets.log");
        try (ResourcesPrinterHelper<Secret> printer = ResourcesPrinterHelper.forSecrets(secretsLogPath);){
            OpenShifts.master().getSecrets().forEach(printer::row);
        }
    }

    private void saveServices(ExtensionContext context, ResourcesFilterBuilder<Service> masterFilter) throws IOException {
        Path servicesLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "services.log");
        try (ResourcesPrinterHelper<Service> printer = ResourcesPrinterHelper.forServices(servicesLogPath);){
            OpenShifts.master().getServices().stream().filter(masterFilter.build()).forEach(printer::row);
        }
    }

    private void saveRoutes(ExtensionContext context, ResourcesFilterBuilder<Route> masterFilter) throws IOException {
        Path routesLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "routes.log");
        try (ResourcesPrinterHelper<Route> printer = ResourcesPrinterHelper.forRoutes(routesLogPath);){
            OpenShifts.master().getRoutes().stream().filter(masterFilter.build()).forEach(printer::row);
        }
    }

    private void saveConfigMaps(ExtensionContext context, ResourcesFilterBuilder<ConfigMap> masterFilter) throws IOException {
        Path configMapsLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "configMaps.log");
        try (ResourcesPrinterHelper<ConfigMap> printer = ResourcesPrinterHelper.forConfigMaps(configMapsLogPath);){
            OpenShifts.master().getConfigMaps().stream().filter(masterFilter.build()).forEach(printer::row);
        }
    }

    private void savePods(ExtensionContext context, ResourcesFilterBuilder<Pod> masterFilter, ResourcesFilterBuilder<Pod> buildsFilter) throws IOException {
        Path podsMasterLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "pods-" + OpenShifts.master().getNamespace() + ".log");
        try (ResourcesPrinterHelper<Pod> printer = ResourcesPrinterHelper.forPods(podsMasterLogPath);){
            OpenShifts.master().getPods().stream().filter(masterFilter.build()).forEach(printer::row);
        }
        if (!this.isMasterAndBuildNamespaceSame()) {
            Path podsBMLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "pods-" + BuildManagers.get().openShift().getNamespace() + ".log");
            try (ResourcesPrinterHelper<Pod> printer = ResourcesPrinterHelper.forPods(podsBMLogPath);){
                BuildManagers.get().openShift().getPods().stream().filter(buildsFilter.build()).forEach(printer::row);
            }
        }
    }

    private void saveDCs(ExtensionContext context, ResourcesFilterBuilder<DeploymentConfig> masterFilter) throws IOException {
        Path dcsLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "deploymentConfigs.log");
        try (ResourcesPrinterHelper<DeploymentConfig> printer = ResourcesPrinterHelper.forDCs(dcsLogPath);){
            OpenShifts.master().getDeploymentConfigs().stream().filter(masterFilter.build()).forEach(printer::row);
        }
    }

    private ExtensionContext.Store getClassStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{extensionContext.getRequiredTestClass()}));
    }

    private ExtensionContext.Store getMethodStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{extensionContext.getRequiredTestClass(), extensionContext.getTestClass()}));
    }

    private void savePodLogs(ExtensionContext context, ResourcesFilterBuilder<Pod> masterFilter, ResourcesFilterBuilder<Pod> buildsFilter) {
        BiConsumer<OpenShift, ResourcesFilterBuilder> podPrinter = (openShift, filter) -> openShift.getPods().stream().filter(filter.build()).forEach(pod -> {
            try {
                openShift.storePodLog(pod, Paths.get(this.attachmentsDir(), this.dirNameForTest(context)), pod.getMetadata().getName() + ".log");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        podPrinter.accept(OpenShifts.master(), masterFilter);
        if (!this.isMasterAndBuildNamespaceSame()) {
            podPrinter.accept(BuildManagers.get().openShift(), buildsFilter);
        }
    }

    private String dirNameForTest(ExtensionContext context) {
        if (context.getTestMethod().isPresent()) {
            return ((Class)context.getTestClass().get()).getName() + "." + context.getDisplayName();
        }
        return ((Class)context.getTestClass().get()).getName();
    }

    private void saveEvents(ExtensionContext context, ResourcesFilterBuilder<Event> masterFilter, ResourcesFilterBuilder<Event> buildsFilter) throws IOException {
        Path eventsMasterLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "events-" + OpenShifts.master().getNamespace() + ".log");
        try (ResourcesPrinterHelper<Event> printer = ResourcesPrinterHelper.forEvents(eventsMasterLogPath);){
            OpenShifts.master().getEvents().stream().filter(masterFilter.build()).forEach(printer::row);
        }
        if (!this.isMasterAndBuildNamespaceSame()) {
            Path eventsBMLogPath = Paths.get(this.attachmentsDir(), this.dirNameForTest(context), "events-" + BuildManagers.get().openShift().getNamespace() + ".log");
            try (ResourcesPrinterHelper<Event> printer = ResourcesPrinterHelper.forEvents(eventsBMLogPath);){
                BuildManagers.get().openShift().getEvents().stream().filter(buildsFilter.build()).forEach(printer::row);
            }
        }
    }

    private String attachmentsDir() {
        return JUnitConfig.recordDir() != null ? JUnitConfig.recordDir() : System.getProperty("user.dir");
    }

    private boolean isMasterAndBuildNamespaceSame() {
        return OpenShifts.master().getNamespace().equals(BuildManagers.get().openShift().getNamespace());
    }
}

