/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.junit5.config.JUnitConfig;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

public class ProjectCreator
implements TestExecutionListener {
    private static final OpenShift openShift = OpenShifts.master();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (openShift.getProject() == null) {
            openShift.createProjectRequest();
            openShift.waiters().isProjectReady().waitFor();
        }
        if (OpenShiftConfig.pullSecret() != null) {
            openShift.setupPullSecret(OpenShiftConfig.pullSecret());
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        boolean deleted;
        if (JUnitConfig.cleanOpenShift() && (deleted = openShift.deleteProject())) {
            BooleanSupplier bs = () -> openShift.getProject() == null;
            new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for old project deletion").waitFor();
        }
    }
}

