/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions.helpers;

import cz.xtf.core.openshift.OpenShift;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ResourcesTimestampHelper {
    static ZonedDateTime lastCreationTime(List<? extends HasMetadata> items) {
        ZonedDateTime result = null;
        for (HasMetadata hasMetadata : items) {
            ZonedDateTime time = ResourcesTimestampHelper.parseZonedDateTime(hasMetadata.getMetadata().getCreationTimestamp());
            if (result != null && !time.isAfter(result)) continue;
            result = time;
        }
        return result == null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(0L), ZoneOffset.UTC) : result;
    }

    static ZonedDateTime creationTime(HasMetadata item) {
        return ZonedDateTime.parse(item.getMetadata().getCreationTimestamp(), DateTimeFormatter.ISO_DATE_TIME);
    }

    static ZonedDateTime parseZonedDateTime(String time) {
        return ZonedDateTime.parse(time, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static ZonedDateTime timeOfLastPod(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getPods());
    }

    public static ZonedDateTime timeOfLastDC(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getDeploymentConfigs());
    }

    public static ZonedDateTime timeOfLastBC(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getBuildConfigs());
    }

    public static ZonedDateTime timeOfLastBuild(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getBuilds());
    }

    public static ZonedDateTime timeOfLastIS(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getImageStreams());
    }

    public static ZonedDateTime timeOfLastSS(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getStatefulSets());
    }

    public static ZonedDateTime timeOfLastRoute(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getRoutes());
    }

    public static ZonedDateTime timeOfLastConfigMap(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getConfigMaps());
    }

    public static ZonedDateTime timeOfLastService(OpenShift openShift) {
        return ResourcesTimestampHelper.lastCreationTime(openShift.getServices());
    }

    public static ZonedDateTime timeOfLastEvent(OpenShift openShift) {
        ZonedDateTime result = null;
        for (Event event : openShift.getEvents()) {
            if (event.getLastTimestamp() == null) continue;
            ZonedDateTime time = ResourcesTimestampHelper.parseZonedDateTime(event.getLastTimestamp());
            if (result != null && (time == null || !time.isAfter(result))) continue;
            result = time;
        }
        return result == null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(0L), ZoneOffset.UTC) : result;
    }

    public static ZonedDateTime timeOfLastResourceOf(OpenShift openShift, Class<? extends HasMetadata> resourceClass) {
        if (resourceClass.equals(Pod.class)) {
            return ResourcesTimestampHelper.timeOfLastPod(openShift);
        }
        if (resourceClass.equals(DeploymentConfig.class)) {
            return ResourcesTimestampHelper.timeOfLastDC(openShift);
        }
        if (resourceClass.equals(BuildConfig.class)) {
            return ResourcesTimestampHelper.timeOfLastBC(openShift);
        }
        if (resourceClass.equals(Build.class)) {
            return ResourcesTimestampHelper.timeOfLastBuild(openShift);
        }
        if (resourceClass.equals(ImageStream.class)) {
            return ResourcesTimestampHelper.timeOfLastIS(openShift);
        }
        if (resourceClass.equals(StatefulSet.class)) {
            return ResourcesTimestampHelper.timeOfLastSS(openShift);
        }
        if (resourceClass.equals(Route.class)) {
            return ResourcesTimestampHelper.timeOfLastRoute(openShift);
        }
        if (resourceClass.equals(ConfigMap.class)) {
            return ResourcesTimestampHelper.timeOfLastConfigMap(openShift);
        }
        if (resourceClass.equals(Service.class)) {
            return ResourcesTimestampHelper.timeOfLastService(openShift);
        }
        if (resourceClass.equals(Event.class)) {
            return ResourcesTimestampHelper.timeOfLastEvent(openShift);
        }
        throw new RuntimeException("Unsupported resource - " + resourceClass.getName());
    }
}

