/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.context.TestCaseContext;
import cz.xtf.core.namespace.NamespaceManager;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.junit5.config.JUnitConfig;
import java.util.Arrays;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCreator
implements TestExecutionListener,
BeforeAllCallback,
AfterAllCallback,
PostDiscoveryFilter {
    private static final Logger log = LoggerFactory.getLogger(ProjectCreator.class);

    public void testPlanExecutionStarted(TestPlan testPlan) {
        NamespaceManager.createIfDoesNotExistsProject((String)OpenShiftConfig.namespace());
    }

    public void beforeAll(ExtensionContext context) {
        this.setTestExecutionContext(context);
        log.debug("BeforeAll - Test case: " + ((Class)context.getTestClass().get()).getName() + " running in thread name: " + Thread.currentThread().getName() + " will use namespace: " + OpenShifts.master().getNamespace() + " - thread context is: " + TestCaseContext.getRunningTestCaseName());
        NamespaceManager.createIfDoesNotExistsProject();
    }

    private void setTestExecutionContext(ExtensionContext context) {
        TestCaseContext.setRunningTestCase((String)((Class)context.getTestClass().get()).getName());
    }

    public void afterAll(ExtensionContext context) {
        if (JUnitConfig.cleanOpenShift()) {
            NamespaceManager.deleteProject((boolean)false);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (JUnitConfig.cleanOpenShift()) {
            NamespaceManager.deleteProject((String)OpenShiftConfig.namespace(), (boolean)true);
        }
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof MethodBasedTestDescriptor) {
            boolean disabled;
            boolean bl = disabled = Arrays.stream(((MethodBasedTestDescriptor)testDescriptor).getTestClass().getAnnotations()).filter(annotation -> annotation instanceof Disabled).count() > 0L;
            if (!disabled) {
                NamespaceManager.addTestCaseToNamespaceEntryIfAbsent((TestDescriptor)testDescriptor);
            }
        }
        return FilterResult.included((String)testDescriptor.getDisplayName());
    }
}

