/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.gomobile.androlog.test;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.test.AndroidTestCase;
import de.akquinet.android.androlog.Log;
import de.akquinet.gomobile.androlog.test.MockContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import junit.framework.Assert;

public class AndrologInitTest
extends AndroidTestCase {
    private File activate;
    private File defaultFile;
    private File deactivate;
    private File activateAndDefault;
    private File activateAndLevels;
    private File subFolder;
    private File testContext;

    public void setUp() {
        try {
            Assert.assertTrue((String)"No SDCard or not the permission to write", (boolean)Environment.getExternalStorageDirectory().canWrite());
            Properties propsDefault = new Properties();
            propsDefault.setProperty("androlog.active", "true");
            this.defaultFile = new File(Environment.getExternalStorageDirectory(), "androlog.properties");
            this.defaultFile.createNewFile();
            FileOutputStream out = new FileOutputStream(this.defaultFile);
            propsDefault.store(out, "Default file");
            out.close();
            Properties propsActive = new Properties();
            propsActive.setProperty("androlog.active", "true");
            this.activate = new File(Environment.getExternalStorageDirectory(), "activate.properties");
            this.subFolder = new File(Environment.getExternalStorageDirectory(), "tmp/activate.properties");
            this.testContext = new File(Environment.getExternalStorageDirectory(), this.getContext().getPackageName() + ".properties");
            this.activate.createNewFile();
            this.testContext.createNewFile();
            new File(Environment.getExternalStorageDirectory(), "tmp").mkdir();
            this.subFolder.createNewFile();
            out = new FileOutputStream(this.activate);
            propsActive.store(out, "Enable Androlog file");
            out.close();
            out = new FileOutputStream(this.subFolder);
            propsActive.store(out, "Enable Androlog file");
            out.close();
            out = new FileOutputStream(this.testContext);
            propsActive.store(out, "Enable Androlog file");
            out.close();
            Properties propsDeactive = new Properties();
            propsDeactive.setProperty("androlog.active", "false");
            this.deactivate = new File(Environment.getExternalStorageDirectory(), "deactivate.properties");
            this.deactivate.createNewFile();
            out = new FileOutputStream(this.deactivate);
            propsDeactive.store(out, "Disable Androlog file");
            out.close();
            Properties propsDefaultLevel = new Properties();
            propsDefaultLevel.setProperty("androlog.active", "true");
            propsDefaultLevel.setProperty("androlog.default.level", "ERROR");
            this.activateAndDefault = new File(Environment.getExternalStorageDirectory(), "activateAndDefault.properties");
            this.activateAndDefault.createNewFile();
            out = new FileOutputStream(this.activateAndDefault);
            propsDefaultLevel.store(out, "Enable Androlog file and set default log level");
            out.close();
            Properties propsLevels = new Properties();
            propsLevels.setProperty("androlog.active", "true");
            propsLevels.setProperty("androlog.default.level", "ERROR");
            propsLevels.setProperty("my.log.verbose", "VERBOSE");
            propsLevels.setProperty("my.log.debug", "DEBUG");
            propsLevels.setProperty("my.log.info", "INFO");
            propsLevels.setProperty("my.log.warn", "WARN");
            propsLevels.setProperty("my.log.error", "ERROR");
            propsLevels.setProperty("my.log.assert", "ASSERT");
            this.activateAndLevels = new File(Environment.getExternalStorageDirectory(), "levels.properties");
            this.activateAndLevels.createNewFile();
            out = new FileOutputStream(this.activateAndLevels);
            propsLevels.store(out, "Enable Androlog file and set default log level");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void tearDown() {
        this.activate.delete();
        this.defaultFile.delete();
        this.deactivate.delete();
        this.activateAndDefault.delete();
        this.activateAndLevels.delete();
        this.subFolder.delete();
        this.testContext.delete();
        File sub = new File(Environment.getExternalStorageDirectory(), "tmp");
        sub.delete();
    }

    public void testDefaultInit() {
        Log.init();
        Assert.assertEquals((int)4, (int)Log.getDefaultLogLevel());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testDefaultInitWhenTheFileDoesNotExist() {
        this.defaultFile.delete();
        Log.init();
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
    }

    public void testInitWithActivateFile() {
        Log.init((String)this.activate.getName());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithMissingWile() {
        Log.init((String)"missing.properties");
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
    }

    public void testInitWithDeactivateFile() {
        Log.init((String)this.deactivate.getName());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
    }

    public void testInitWithActivateAndDefaultFile() {
        Log.init((String)this.activateAndDefault.getName());
        Assert.assertEquals((int)6, (int)Log.getDefaultLogLevel());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.e((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithFileSettingLevels() {
        Log.init((String)this.activateAndLevels.getName());
        String message = "This is a VERBOSE test";
        String tag = "my.log.verbose";
        int expected = tag.length() + message.length() + 3;
        int x = Log.v((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a DEBUG test";
        tag = "my.log.debug";
        expected = tag.length() + message.length() + 3;
        x = Log.v((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a INFO test";
        tag = "my.log.info";
        expected = tag.length() + message.length() + 3;
        x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a WARN test";
        tag = "my.log.warn";
        expected = tag.length() + message.length() + 3;
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.e((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a ERROR test";
        tag = "my.log.error";
        expected = tag.length() + message.length() + 3;
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.e((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testSubFolderFile() {
        Log.init((String)("tmp/" + this.subFolder.getName()));
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithContext() {
        Log.init((Context)this.getContext());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithContextAndAssets() {
        Log.init((Context)this.getContext());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithContextAndAssetsAndFileName() {
        Log.init((Context)this.getContext(), (String)"androlog/my-configuration.properties");
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testInitWithMissingContext() {
        this.testContext.delete();
        Log.init((Context)new MockContext(){

            @Override
            public String getPackageName() {
                return AndrologInitTest.this.getContext().getPackageName();
            }

            @Override
            public AssetManager getAssets() {
                return null;
            }
        });
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
    }

    public void testInitWithNullAndNull() {
        this.testContext.delete();
        this.defaultFile.delete();
        Log.init(null, null);
        String message = "This is a INFO test";
        String tag = "my.log.info";
        int x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
    }
}

