/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.gomobile.androlog.test;

import android.content.Context;
import android.os.Environment;
import android.test.AndroidTestCase;
import de.akquinet.android.androlog.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;

public class ReportingInitTest
extends AndroidTestCase {
    private File activate;
    private File defaultFile;
    private File deactivate;
    private File activateAndDefault;
    private File testContext;

    public void setUp() {
        try {
            Assert.assertTrue((String)"No SDCard or not the permission to write", (boolean)Environment.getExternalStorageDirectory().canWrite());
            Properties propsDefault = new Properties();
            propsDefault.setProperty("androlog.active", "true");
            propsDefault.setProperty("androlog.report.active", "true");
            propsDefault.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.NoopReporter");
            this.defaultFile = new File(Environment.getExternalStorageDirectory(), "androlog.properties");
            this.defaultFile.createNewFile();
            FileOutputStream out = new FileOutputStream(this.defaultFile);
            propsDefault.store(out, "Default file");
            out.close();
            Properties propsActive = new Properties();
            propsActive.setProperty("androlog.active", "true");
            propsActive.setProperty("androlog.report.active", "true");
            propsActive.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.NoopReporter");
            this.activate = new File(Environment.getExternalStorageDirectory(), "activate.properties");
            this.testContext = new File(Environment.getExternalStorageDirectory(), this.getContext().getPackageName() + ".properties");
            this.activate.createNewFile();
            this.testContext.createNewFile();
            new File(Environment.getExternalStorageDirectory(), "tmp").mkdir();
            out = new FileOutputStream(this.activate);
            propsActive.store(out, "Enable Androlog file");
            out.close();
            out = new FileOutputStream(this.testContext);
            propsActive.store(out, "Enable Androlog file");
            out.close();
            Properties propsDeactive = new Properties();
            propsDeactive.setProperty("androlog.active", "false");
            propsDeactive.setProperty("androlog.report.active", "true");
            propsDeactive.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.NoopReporter");
            this.deactivate = new File(Environment.getExternalStorageDirectory(), "deactivate.properties");
            this.deactivate.createNewFile();
            out = new FileOutputStream(this.deactivate);
            propsDeactive.store(out, "Disable Androlog Log, Enable Reporting file");
            out.close();
            Properties propsDefaultLevel = new Properties();
            propsDefaultLevel.setProperty("androlog.active", "true");
            propsDefaultLevel.setProperty("androlog.report.active", "true");
            propsDefaultLevel.setProperty("androlog.default.level", "ERROR");
            propsDefaultLevel.setProperty("androlog.report.default.level", "ERROR");
            propsDefaultLevel.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.NoopReporter");
            this.activateAndDefault = new File(Environment.getExternalStorageDirectory(), "activateAndDefault.properties");
            this.activateAndDefault.createNewFile();
            out = new FileOutputStream(this.activateAndDefault);
            propsDefaultLevel.store(out, "Enable Androlog file and set default log level");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void tearDown() {
        this.activate.delete();
        this.defaultFile.delete();
        this.deactivate.delete();
        this.activateAndDefault.delete();
        this.testContext.delete();
    }

    public void testDefaultReport() {
        Log.init((Context)this.getContext());
        Assert.assertEquals((int)4, (int)Log.getDefaultLogLevel());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)2, (int)list.size());
    }

    public void testDefaultInitWhenTheFileDoesNotExist() {
        this.defaultFile.delete();
        Log.init();
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNull((Object)list);
    }

    public void testReportWithActivateFile() {
        Log.init((Context)this.getContext(), (String)this.activate.getName());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)2, (int)list.size());
    }

    public void testReportWithMissingFile() {
        Log.init((String)"missing.properties");
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNull((Object)list);
    }

    public void testReportWithDeactivatedLog() {
        Log.init((Context)this.getContext(), (String)this.deactivate.getName());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)2, (int)list.size());
    }

    public void testReportWithActivateAndDefaultFile() {
        Log.init((Context)this.getContext(), (String)this.activateAndDefault.getName());
        Assert.assertEquals((int)6, (int)Log.getDefaultLogLevel());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        Log.e((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)1, (int)list.size());
    }

    public void testInitWithContext() {
        Log.init((Context)this.getContext());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)2, (int)list.size());
    }
}

