/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.gomobile.androlog.test;

import android.os.Environment;
import de.akquinet.android.androlog.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class WTFTest
extends TestCase {
    public void setUp() {
        Log.reset();
        Log.activateLogging();
        Log.setDefaultLogLevel((int)2);
    }

    public void testWTFWhenLogActive() {
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        String message = "This is a REALLY BAD error";
        int x = Log.wtf((String)tag, (String)message);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWhenLogInactive() {
        Log.deactivateLogging();
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        String message = "This is a REALLY BAD error";
        int x = Log.wtf((String)tag, (String)message);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWhenLogLevelSetToError() {
        Log.setDefaultLogLevel((int)6);
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        String message = "This is a REALLY BAD error";
        int x = Log.wtf((String)tag, (String)message);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWhenLogLevelSetToAssert() {
        Log.setDefaultLogLevel((int)7);
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        String message = "This is a REALLY BAD error";
        int x = Log.wtf((String)tag, (String)message);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWithThis() {
        String message = "This is a REALLY BAD error";
        int x = Log.wtf((Object)((Object)this), (String)message);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWithThisWithException() {
        String message = "This is a REALLY BAD error";
        NullPointerException ex = new NullPointerException();
        int x = Log.wtf((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testWTFWithExceptionOnly() {
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        NullPointerException ex = new NullPointerException();
        int x = Log.wtf((String)tag, (Throwable)ex);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
    }

    public void testDisablingDelegationFromConfiguration() {
        Log.reset();
        Log.setWTFDelegation((boolean)true);
        Properties props = new Properties();
        props.setProperty("androlog.active", "true");
        props.setProperty("androlog.delegate.wtf", "false");
        Log.configure((Properties)props);
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        NullPointerException ex = new NullPointerException();
        int x = Log.wtf((String)tag, (Throwable)ex);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("" + x), (x < 1000 ? 1 : 0) != 0);
    }

    public void testDisablingDelegationFromFile() throws IOException {
        Log.reset();
        Log.setWTFDelegation((boolean)true);
        Properties props = new Properties();
        props.setProperty("androlog.active", "true");
        props.setProperty("androlog.delegate.wtf", "false");
        File file = new File(Environment.getExternalStorageDirectory(), "wtf.properties");
        file.createNewFile();
        FileOutputStream out = new FileOutputStream(file);
        props.store(out, "Disable WTF delegation from file");
        out.close();
        Log.init((String)"wtf.properties");
        String tag = "de.akquinet.gomobile.androlog.test.WTFTest";
        NullPointerException ex = new NullPointerException();
        int x = Log.wtf((String)tag, (Throwable)ex);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("" + x), (x < 1000 ? 1 : 0) != 0);
    }
}

