/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.gomobile.androlog.test;

import de.akquinet.android.androlog.Log;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AndrologTest
extends TestCase {
    public void setUp() {
        Log.activateLogging();
        Log.setDefaultLogLevel((int)2);
    }

    public void testDWithThis() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a DEBUG test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testDWithThisWithException() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a DEBUG test";
        NullPointerException ex = new NullPointerException();
        int expected = tag.length() + message.length() + 3 + 904;
        int x = Log.d((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testWWithThis() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a WARNING test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.w((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testWWithThisWithException() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a WARNING test";
        NullPointerException ex = new NullPointerException();
        int expected = tag.length() + message.length() + 3 + 904;
        int x = Log.w((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testVWithThis() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a VERBOSE test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.v((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testVWithThisWithException() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a VERBOSE test";
        NullPointerException ex = new NullPointerException();
        int expected = tag.length() + message.length() + 3 + 904;
        int x = Log.v((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testEWithThis() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is an ERROR test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.e((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testEWithThisWithException() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a ERROR test";
        NullPointerException ex = new NullPointerException();
        int expected = tag.length() + message.length() + 3 + 904;
        int x = Log.e((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testIWithThis() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a INFO test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.i((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testIWithThisWithException() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a INFO test";
        NullPointerException ex = new NullPointerException();
        int expected = tag.length() + message.length() + 3 + 905;
        int x = Log.i((Object)((Object)this), (String)message, (Throwable)ex);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testIWithCaller() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a INFO test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.i((String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testDWithCaller() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a DEBUG test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.d((String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testWWithCaller() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a WARNING test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.w((String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testVWithCaller() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is a VERBOSE test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.v((String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testEWithCaller() {
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is an ERROR test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.e((String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testWhenAdronlogIsDisabled() {
        Log.deactivateLogging();
        Assert.assertEquals((int)0, (int)Log.v((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.v((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.d((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.d((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.i((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.i((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.w((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.w((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.e((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.e((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
    }

    public void testDisablingFromConfiguration() {
        Log.reset();
        Properties props = new Properties();
        props.setProperty("androlog.active", "false");
        Log.configure((Properties)props);
        Assert.assertEquals((int)0, (int)Log.v((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.v((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.v((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.d((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.d((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.d((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.i((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.i((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.i((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.w((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.w((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.w((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.e((String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((Object)((Object)this), (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((Object)((Object)this), (String)"xxx", (Throwable)new NullPointerException()));
        Assert.assertEquals((int)0, (int)Log.e((String)"TAG", (String)"xxx"));
        Assert.assertEquals((int)0, (int)Log.e((String)"TAG", (String)"xxx", (Throwable)new NullPointerException()));
    }

    public void testLogLevelsFromConfiguration() {
        Log.reset();
        Properties props = new Properties();
        props.setProperty("androlog.active", "true");
        props.setProperty("androlog.default.level", "ERROR");
        props.setProperty("my.log.verbose", "VERBOSE");
        props.setProperty("my.log.debug", "DEBUG");
        props.setProperty("my.log.info", "INFO");
        props.setProperty("my.log.warn", "WARN");
        props.setProperty("my.log.error", "ERROR");
        props.setProperty("my.log.assert", "ASSERT");
        Log.configure((Properties)props);
        String message = "This is a VERBOSE test";
        String tag = "my.log.verbose";
        int expected = tag.length() + message.length() + 3;
        int x = Log.v((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a DEBUG test";
        tag = "my.log.debug";
        expected = tag.length() + message.length() + 3;
        x = Log.v((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a INFO test";
        tag = "my.log.info";
        expected = tag.length() + message.length() + 3;
        x = Log.d((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a WARN test";
        tag = "my.log.warn";
        expected = tag.length() + message.length() + 3;
        x = Log.i((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        x = Log.e((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
        message = "This is a ERROR test";
        tag = "my.log.error";
        expected = tag.length() + message.length() + 3;
        x = Log.w((String)tag, (String)message);
        Assert.assertEquals((int)0, (int)x);
        x = Log.e((String)tag, (String)message);
        Assert.assertEquals((int)expected, (int)x);
    }

    public void testDefaultLevelFromConfiguration() {
        Log.reset();
        Properties props = new Properties();
        props.setProperty("androlog.active", "true");
        props.setProperty("androlog.default.level", "ERROR");
        Log.configure((Properties)props);
        String tag = "de.akquinet.gomobile.androlog.test.AndrologTest";
        String message = "This is an ERROR test";
        int expected = tag.length() + message.length() + 3;
        int x = Log.e((Object)((Object)this), (String)message);
        Assert.assertEquals((int)expected, (int)x);
        expected = tag.length() + message.length() + 3;
        x = Log.i((Object)((Object)this), (String)message);
        Assert.assertEquals((int)0, (int)x);
    }
}

