/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.gomobile.androlog.test;

import android.content.Context;
import android.os.Environment;
import android.test.AndroidTestCase;
import de.akquinet.android.androlog.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.http.auth.MalformedChallengeException;

public class MailReporterTest
extends AndroidTestCase {
    private File testContext;

    public void setUp() {
        try {
            Assert.assertTrue((String)"No SDCard or not the permission to write", (boolean)Environment.getExternalStorageDirectory().canWrite());
            Properties propsDefault = new Properties();
            propsDefault.setProperty("androlog.active", "true");
            propsDefault.setProperty("androlog.report.active", "true");
            propsDefault.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.NoopReporter");
            Properties propsActive = new Properties();
            propsActive.setProperty("androlog.active", "true");
            propsActive.setProperty("androlog.report.active", "true");
            propsActive.setProperty("androlog.report.reporters", "de.akquinet.android.androlog.reporter.MailReporter");
            propsActive.setProperty("androlog.reporter.mail.address", "clement.escoffier@gmail.com");
            this.testContext = new File(Environment.getExternalStorageDirectory(), String.valueOf(this.getContext().getPackageName()) + ".properties");
            this.testContext.createNewFile();
            new File(Environment.getExternalStorageDirectory(), "tmp").mkdir();
            FileOutputStream out = new FileOutputStream(this.testContext);
            propsActive.store(out, "Enable Androlog file");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void tearDown() {
        this.testContext.delete();
    }

    public void testMail() {
        Log.init((Context)this.getContext());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)2, (int)list.size());
        Log.report();
        Log.report((String)"this is a user message", null);
        MalformedChallengeException error = new MalformedChallengeException("error message", (Throwable)new NumberFormatException());
        Log.report(null, (Throwable)error);
    }

    public void testMailWithLongLog() {
        Log.init((Context)this.getContext());
        String message = "This is a INFO test";
        String tag = "my.log.info";
        Log.d((String)tag, (String)message);
        Log.i((String)tag, (String)message);
        Log.w((String)tag, (String)message);
        int i = 0;
        while (i < 200) {
            Log.w((String)("" + i));
            ++i;
        }
        List list = Log.getReportedEntries();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((int)25, (int)list.size());
        Log.report();
        Log.report((String)"this is a user message", null);
        MalformedChallengeException error = new MalformedChallengeException("error message", (Throwable)new NumberFormatException());
        Log.report(null, (Throwable)error);
    }
}

