/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.capabilityset;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFilter {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int EQ = 4;
    public static final int LTE = 5;
    public static final int GTE = 6;
    public static final int SUBSTRING = 7;
    public static final int PRESENT = 8;
    public static final int APPROX = 9;
    private final String m_name;
    private final Object m_value;
    private final int m_op;

    public SimpleFilter(String attr, Object value, int op) {
        this.m_name = attr;
        this.m_value = value;
        this.m_op = op;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getValue() {
        return this.m_value;
    }

    public int getOperation() {
        return this.m_op;
    }

    public String toString() {
        String s = null;
        switch (this.m_op) {
            case 1: {
                s = new StringBuffer().append("(&").append(SimpleFilter.toString((List)this.m_value)).append(")").toString();
                break;
            }
            case 2: {
                s = new StringBuffer().append("(|").append(SimpleFilter.toString((List)this.m_value)).append(")").toString();
                break;
            }
            case 3: {
                s = new StringBuffer().append("(!").append(SimpleFilter.toString((List)this.m_value)).append(")").toString();
                break;
            }
            case 4: {
                s = new StringBuffer().append("(").append(this.m_name).append("=").append(SimpleFilter.toEncodedString(this.m_value)).append(")").toString();
                break;
            }
            case 5: {
                s = new StringBuffer().append("(").append(this.m_name).append("<=").append(SimpleFilter.toEncodedString(this.m_value)).append(")").toString();
                break;
            }
            case 6: {
                s = new StringBuffer().append("(").append(this.m_name).append(">=").append(SimpleFilter.toEncodedString(this.m_value)).append(")").toString();
                break;
            }
            case 7: {
                s = new StringBuffer().append("(").append(this.m_name).append("=").append(SimpleFilter.unparseSubstring((List)this.m_value)).append(")").toString();
                break;
            }
            case 8: {
                s = new StringBuffer().append("(").append(this.m_name).append("=*)").toString();
                break;
            }
            case 9: {
                s = new StringBuffer().append("(").append(this.m_name).append("~=").append(SimpleFilter.toEncodedString(this.m_value)).append(")").toString();
            }
        }
        return s;
    }

    private static String toString(List list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
        }
        return sb.toString();
    }

    private static String toDecodedString(String s, int startIdx, int endIdx) {
        StringBuffer sb = new StringBuffer(endIdx - startIdx);
        boolean escaped = false;
        for (int i = 0; i < endIdx - startIdx; ++i) {
            char c = s.charAt(startIdx + i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toEncodedString(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '(' || c == ')' || c == '*') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            o = sb.toString();
        }
        return o.toString();
    }

    public static SimpleFilter parse(String filter) {
        int idx = SimpleFilter.skipWhitespace(filter, 0);
        if (filter == null || filter.length() == 0 || idx >= filter.length()) {
            throw new IllegalArgumentException("Null or empty filter.");
        }
        if (filter.charAt(idx) != '(') {
            throw new IllegalArgumentException(new StringBuffer().append("Missing opening parenthesis: ").append(filter).toString());
        }
        SimpleFilter sf = null;
        ArrayList<Object> stack = new ArrayList<Object>();
        boolean isEscaped = false;
        while (idx < filter.length()) {
            if (sf != null) {
                throw new IllegalArgumentException(new StringBuffer().append("Only one top-level operation allowed: ").append(filter).toString());
            }
            if (!isEscaped && filter.charAt(idx) == '(') {
                if (filter.charAt(idx = SimpleFilter.skipWhitespace(filter, idx + 1)) == '&') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 1));
                    } else {
                        stack.add(0, new Integer(idx));
                    }
                } else if (filter.charAt(idx) == '|') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 2));
                    } else {
                        stack.add(0, new Integer(idx));
                    }
                } else if (filter.charAt(idx) == '!') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 3));
                    } else {
                        stack.add(0, new Integer(idx));
                    }
                } else {
                    stack.add(0, new Integer(idx));
                }
            } else if (!isEscaped && filter.charAt(idx) == ')') {
                Object top = stack.remove(0);
                if (top instanceof SimpleFilter) {
                    if (!stack.isEmpty() && stack.get(0) instanceof SimpleFilter) {
                        ((List)((SimpleFilter)stack.get((int)0)).m_value).add(top);
                    } else {
                        sf = (SimpleFilter)top;
                    }
                } else if (!stack.isEmpty() && stack.get(0) instanceof SimpleFilter) {
                    ((List)((SimpleFilter)stack.get((int)0)).m_value).add(SimpleFilter.subfilter(filter, (Integer)top, idx));
                } else {
                    sf = SimpleFilter.subfilter(filter, (Integer)top, idx);
                }
            } else {
                isEscaped = !isEscaped && filter.charAt(idx) == '\\';
            }
            idx = SimpleFilter.skipWhitespace(filter, idx + 1);
        }
        if (sf == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Missing closing parenthesis: ").append(filter).toString());
        }
        return sf;
    }

    private static SimpleFilter subfilter(String filter, int startIdx, int endIdx) {
        char c;
        String opChars = "=<>~";
        int attrEndIdx = startIdx;
        for (int i = 0; i < endIdx - startIdx && "=<>~".indexOf(c = filter.charAt(startIdx + i)) < 0; ++i) {
            if (Character.isWhitespace(c)) continue;
            attrEndIdx = startIdx + i + 1;
        }
        if (attrEndIdx == startIdx) {
            throw new IllegalArgumentException(new StringBuffer().append("Missing attribute name: ").append(filter.substring(startIdx, endIdx)).toString());
        }
        String attr = filter.substring(startIdx, attrEndIdx);
        startIdx = SimpleFilter.skipWhitespace(filter, attrEndIdx);
        int op = -1;
        switch (filter.charAt(startIdx)) {
            case '=': {
                op = 4;
                ++startIdx;
                break;
            }
            case '<': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException(new StringBuffer().append("Unknown operator: ").append(filter.substring(startIdx, endIdx)).toString());
                }
                op = 5;
                startIdx += 2;
                break;
            }
            case '>': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException(new StringBuffer().append("Unknown operator: ").append(filter.substring(startIdx, endIdx)).toString());
                }
                op = 6;
                startIdx += 2;
                break;
            }
            case '~': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException(new StringBuffer().append("Unknown operator: ").append(filter.substring(startIdx, endIdx)).toString());
                }
                op = 9;
                startIdx += 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer().append("Unknown operator: ").append(filter.substring(startIdx, endIdx)).toString());
            }
        }
        Object value = SimpleFilter.toDecodedString(filter, startIdx, endIdx);
        if (op == 4) {
            String valueStr = filter.substring(startIdx, endIdx);
            List<String> values = SimpleFilter.parseSubstring(valueStr);
            if (values.size() == 2 && values.get(0).length() == 0 && values.get(1).length() == 0) {
                op = 8;
            } else if (values.size() > 1) {
                op = 7;
                value = values;
            }
        }
        return new SimpleFilter(attr, value, op);
    }

    public static List<String> parseSubstring(String value) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        boolean escaped = false;
        while (true) {
            if (idx >= value.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!(escaped || c != '(' && c != ')')) {
                throw new IllegalArgumentException(new StringBuffer().append("Illegal value: ").append(value).toString());
            }
            if (!escaped && c == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException(new StringBuffer().append("Invalid filter string: ").append(value).toString());
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.size() == 0) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    public static String unparseSubstring(List<String> pieces) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pieces.size(); ++i) {
            if (i > 0) {
                sb.append("*");
            }
            sb.append(SimpleFilter.toEncodedString(pieces.get(i)));
        }
        return sb.toString();
    }

    public static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        if (len == 1) {
            return s.equals(pieces.get(0));
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }

    private static int skipWhitespace(String s, int startIdx) {
        int len = s.length();
        while (startIdx < len && Character.isWhitespace(s.charAt(startIdx))) {
            ++startIdx;
        }
        return startIdx;
    }
}

