/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.jsonrpc.endpoint;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONRPCServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;
import org.ow2.chameleon.rose.server.EndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRpcEndpointFactory
implements EndpointFactory,
Pojo {
    private InstanceManager __IM;
    public static final String[] CONFIGS = new String[]{"jsonrpc", "org.jabsorb", "json-rpc"};
    private boolean __Fhttpservice;
    private HttpService httpservice;
    private boolean __Flogger;
    private LogService logger;
    private static final String PROP_GZIP_THRESHOLD = "gzip_threshold";
    private boolean __Fgzip_threshold;
    private String gzip_threshold;
    private boolean __Fservletname;
    private String servletname;
    private boolean __Fjsonbridge;
    private JSONRPCBridge jsonbridge;
    private boolean __FendpointNames;
    private Set<String> endpointNames;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __McreateEndpoint$java_lang_Object$java_util_Map;
    private boolean __McreateEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map;
    private boolean __MdestroyEndpoint$java_lang_String;

    HttpService __gethttpservice() {
        if (!this.__Fhttpservice) {
            return this.httpservice;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpservice");
    }

    void __sethttpservice(HttpService httpService) {
        if (!this.__Fhttpservice) {
            this.httpservice = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpservice", (Object)httpService);
    }

    LogService __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (LogService)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(LogService logService) {
        if (!this.__Flogger) {
            this.logger = logService;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logService);
    }

    String __getgzip_threshold() {
        if (!this.__Fgzip_threshold) {
            return this.gzip_threshold;
        }
        return (String)this.__IM.onGet((Object)this, PROP_GZIP_THRESHOLD);
    }

    void __setgzip_threshold(String string) {
        if (!this.__Fgzip_threshold) {
            this.gzip_threshold = string;
            return;
        }
        this.__IM.onSet((Object)this, PROP_GZIP_THRESHOLD, (Object)string);
    }

    String __getservletname() {
        if (!this.__Fservletname) {
            return this.servletname;
        }
        return (String)this.__IM.onGet((Object)this, "servletname");
    }

    void __setservletname(String string) {
        if (!this.__Fservletname) {
            this.servletname = string;
            return;
        }
        this.__IM.onSet((Object)this, "servletname", (Object)string);
    }

    JSONRPCBridge __getjsonbridge() {
        if (!this.__Fjsonbridge) {
            return this.jsonbridge;
        }
        return (JSONRPCBridge)this.__IM.onGet((Object)this, "jsonbridge");
    }

    void __setjsonbridge(JSONRPCBridge jSONRPCBridge) {
        if (!this.__Fjsonbridge) {
            this.jsonbridge = jSONRPCBridge;
            return;
        }
        this.__IM.onSet((Object)this, "jsonbridge", (Object)jSONRPCBridge);
    }

    Set __getendpointNames() {
        if (!this.__FendpointNames) {
            return this.endpointNames;
        }
        return (Set)this.__IM.onGet((Object)this, "endpointNames");
    }

    void __setendpointNames(Set set) {
        if (!this.__FendpointNames) {
            this.endpointNames = set;
            return;
        }
        this.__IM.onSet((Object)this, "endpointNames", (Object)set);
    }

    public JsonRpcEndpointFactory() {
        this(null);
    }

    private JsonRpcEndpointFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setgzip_threshold("200");
        this.__setendpointNames(new HashSet());
    }

    private void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(PROP_GZIP_THRESHOLD, this.__getgzip_threshold());
        try {
            this.__gethttpservice().registerServlet(this.__getservletname(), (Servlet)new JSONRPCServlet(), properties, null);
        }
        catch (NamespaceException e) {
            this.__getlogger().log(1, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.__getlogger().log(1, e.getMessage(), (Throwable)e);
        }
        this.__setjsonbridge(JSONRPCBridge.getGlobalBridge());
    }

    private void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        try {
            if (this.__gethttpservice() != null) {
                this.__gethttpservice().unregister(this.__getservletname());
            }
        }
        catch (RuntimeException re) {
            this.__getlogger().log(1, re.getMessage(), (Throwable)re);
        }
    }

    public void createEndpoint(Object object, Map<String, String> map) throws IllegalArgumentException {
        if (!this.__McreateEndpoint$java_lang_Object$java_util_Map) {
            this.__createEndpoint(object, map);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createEndpoint$java_lang_Object$java_util_Map", new Object[]{object, map});
            this.__createEndpoint(object, map);
            this.__IM.onExit((Object)this, "createEndpoint$java_lang_Object$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createEndpoint$java_lang_Object$java_util_Map", throwable);
            throw throwable;
        }
    }

    private void __createEndpoint(Object pService, Map<String, String> properties) throws IllegalArgumentException {
        String name = properties.get("endpoint.name");
        if (this.__getendpointNames().contains(name)) {
            throw new IllegalArgumentException("An endpoint of name: " + name + " has already been created.");
        }
        if (!properties.containsKey("endpoint.interface.name")) {
            this.__getjsonbridge().registerObject((Object)name, pService);
        } else {
            String itf = properties.get("endpoint.interface.name");
            try {
                this.__getjsonbridge().registerObject((Object)name, pService, pService.getClass().getClassLoader().loadClass(itf));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("The properties endpoint.name, endpoint.interface.name must be set.", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load the service interface " + itf + " from the service classloader.", e);
            }
        }
        this.__getendpointNames().add(name);
    }

    public void createEndpoint(Object object, ClassLoader classLoader, Map<String, String> map) throws IllegalArgumentException {
        if (!this.__McreateEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map) {
            this.__createEndpoint(object, classLoader, map);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map", new Object[]{object, classLoader, map});
            this.__createEndpoint(object, classLoader, map);
            this.__IM.onExit((Object)this, "createEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map", throwable);
            throw throwable;
        }
    }

    private void __createEndpoint(Object pService, ClassLoader pLoader, Map<String, String> properties) throws IllegalArgumentException {
        String name = properties.get("endpoint.name");
        if (this.__getendpointNames().contains(name)) {
            throw new IllegalArgumentException("An endpoint of name: " + name + " has already been created.");
        }
        String itf = properties.get("endpoint.interface.name");
        try {
            this.__getjsonbridge().registerObject((Object)name, pService, pLoader.loadClass(itf));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("The properties endpoint.name and endpoint.interface.name must be set.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load the service interface " + itf + " from the given classloader.", e);
        }
        this.__getendpointNames().add(name);
    }

    public void destroyEndpoint(String string) throws IllegalArgumentException, NullPointerException {
        if (!this.__MdestroyEndpoint$java_lang_String) {
            this.__destroyEndpoint(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "destroyEndpoint$java_lang_String", new Object[]{string});
            this.__destroyEndpoint(string);
            this.__IM.onExit((Object)this, "destroyEndpoint$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "destroyEndpoint$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __destroyEndpoint(String pService) throws IllegalArgumentException, NullPointerException {
        if (!this.__getendpointNames().contains(pService)) {
            throw new IllegalArgumentException("There is no endpoint of name: " + pService);
        }
        this.__getjsonbridge().unregisterObject((Object)pService);
        this.__getendpointNames().remove(pService);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("endpointNames")) {
                this.__FendpointNames = true;
            }
            if (set.contains("jsonbridge")) {
                this.__Fjsonbridge = true;
            }
            if (set.contains("servletname")) {
                this.__Fservletname = true;
            }
            if (set.contains(PROP_GZIP_THRESHOLD)) {
                this.__Fgzip_threshold = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("httpservice")) {
                this.__Fhttpservice = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("createEndpoint$java_lang_Object$java_util_Map")) {
                this.__McreateEndpoint$java_lang_Object$java_util_Map = true;
            }
            if (set.contains("createEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map")) {
                this.__McreateEndpoint$java_lang_Object$java_lang_ClassLoader$java_util_Map = true;
            }
            if (set.contains("destroyEndpoint$java_lang_String")) {
                this.__MdestroyEndpoint$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

