/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.arch.gogo;

import java.io.PrintStream;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.service.command.Descriptor;

@Component(public_factory=false, immediate=true)
@Instantiate
@Provides(specifications={Arch.class})
public class Arch
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fm_scope;
    @ServiceProperty(name="osgi.command.scope", value="ipojo")
    String m_scope;
    private boolean __Fm_function;
    @ServiceProperty(name="osgi.command.function", value="{}")
    String[] m_function;
    private boolean __Fm_archs;
    @Requires(optional=true)
    private Architecture[] m_archs;
    private boolean __Fm_factories;
    @Requires(optional=true)
    private Factory[] m_factories;
    private boolean __Fm_handlers;
    @Requires(optional=true)
    private HandlerFactory[] m_handlers;
    private boolean __Minstances;
    private boolean __Minstance$java_lang_String;
    private boolean __Mfactory$java_lang_String;
    private boolean __Mfactories;
    private boolean __Mhandlers;

    String __getm_scope() {
        if (!this.__Fm_scope) {
            return this.m_scope;
        }
        return (String)this.__IM.onGet((Object)this, "m_scope");
    }

    void __setm_scope(String string) {
        if (!this.__Fm_scope) {
            this.m_scope = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_scope", (Object)string);
    }

    String[] __getm_function() {
        if (!this.__Fm_function) {
            return this.m_function;
        }
        return (String[])this.__IM.onGet((Object)this, "m_function");
    }

    void __setm_function(String[] stringArray) {
        if (!this.__Fm_function) {
            this.m_function = stringArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_function", (Object)stringArray);
    }

    Architecture[] __getm_archs() {
        if (!this.__Fm_archs) {
            return this.m_archs;
        }
        return (Architecture[])this.__IM.onGet((Object)this, "m_archs");
    }

    void __setm_archs(Architecture[] architectureArray) {
        if (!this.__Fm_archs) {
            this.m_archs = architectureArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_archs", (Object)architectureArray);
    }

    Factory[] __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (Factory[])this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(Factory[] factoryArray) {
        if (!this.__Fm_factories) {
            this.m_factories = factoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)factoryArray);
    }

    HandlerFactory[] __getm_handlers() {
        if (!this.__Fm_handlers) {
            return this.m_handlers;
        }
        return (HandlerFactory[])this.__IM.onGet((Object)this, "m_handlers");
    }

    void __setm_handlers(HandlerFactory[] handlerFactoryArray) {
        if (!this.__Fm_handlers) {
            this.m_handlers = handlerFactoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_handlers", (Object)handlerFactoryArray);
    }

    public Arch() {
        this(null);
    }

    private Arch(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_function(new String[]{"instances", "instance", "factory", "factories", "handlers"});
    }

    @Descriptor(value="Display iPOJO instances")
    public void instances() {
        if (!this.__Minstances) {
            this.__instances();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instances", new Object[0]);
            this.__instances();
            this.__IM.onExit((Object)this, "instances", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instances", throwable);
            throw throwable;
        }
    }

    private void __instances() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.__getm_archs().length; ++i) {
            InstanceDescription instance = this.__getm_archs()[i].getInstanceDescription();
            if (instance.getState() == 2) {
                buffer.append("Instance " + instance.getName() + " -> valid \n");
            }
            if (instance.getState() == 1) {
                buffer.append("Instance " + instance.getName() + " -> invalid \n");
            }
            if (instance.getState() != 0) continue;
            buffer.append("Instance " + instance.getName() + " -> stopped \n");
        }
        if (buffer.length() == 0) {
            buffer.append("No instances \n");
        }
        System.out.println(buffer.toString());
    }

    @Descriptor(value="Display the architecture of a specific instance")
    public void instance(String string) {
        if (!this.__Minstance$java_lang_String) {
            this.__instance(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instance$java_lang_String", new Object[]{string});
            this.__instance(string);
            this.__IM.onExit((Object)this, "instance$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instance$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __instance(@Descriptor(value="target instance name") String instance) {
        for (int i = 0; i < this.__getm_archs().length; ++i) {
            InstanceDescription id = this.__getm_archs()[i].getInstanceDescription();
            if (!id.getName().equalsIgnoreCase(instance)) continue;
            System.out.println(id.getDescription());
            return;
        }
        System.err.println("Instance " + instance + " not found");
    }

    @Descriptor(value="Display the information about a specific factory")
    public void factory(String string) {
        if (!this.__Mfactory$java_lang_String) {
            this.__factory(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "factory$java_lang_String", new Object[]{string});
            this.__factory(string);
            this.__IM.onExit((Object)this, "factory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "factory$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __factory(@Descriptor(value="target factory") String factory) {
        boolean found = false;
        PrintStream out = System.out;
        for (int i = 0; i < this.__getm_factories().length; ++i) {
            if (!this.__getm_factories()[i].getName().equalsIgnoreCase(factory)) continue;
            if (found) {
                out.println();
            }
            out.println(this.__getm_factories()[i].getDescription());
            found = true;
        }
        if (!found) {
            System.err.println("Factory " + factory + " not found");
        }
    }

    @Descriptor(value="Display iPOJO factories")
    public void factories() {
        if (!this.__Mfactories) {
            this.__factories();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "factories", new Object[0]);
            this.__factories();
            this.__IM.onExit((Object)this, "factories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "factories", throwable);
            throw throwable;
        }
    }

    private void __factories() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.__getm_factories().length; ++i) {
            if (this.__getm_factories()[i].getMissingHandlers().size() == 0) {
                buffer.append("Factory " + this.__getm_factories()[i].getName() + " (VALID) \n");
                continue;
            }
            buffer.append("Factory " + this.__getm_factories()[i].getName() + " (INVALID : " + this.__getm_factories()[i].getMissingHandlers() + ") \n");
        }
        if (buffer.length() == 0) {
            buffer.append("No factories \n");
        }
        System.out.println(buffer.toString());
    }

    @Descriptor(value="Display iPOJO handlers")
    public void handlers() {
        if (!this.__Mhandlers) {
            this.__handlers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handlers", new Object[0]);
            this.__handlers();
            this.__IM.onExit((Object)this, "handlers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handlers", throwable);
            throw throwable;
        }
    }

    private void __handlers() {
        PrintStream out = System.out;
        for (int i = 0; i < this.__getm_handlers().length; ++i) {
            String name = this.__getm_handlers()[i].getHandlerName();
            if ("composite".equals(this.__getm_handlers()[i].getType())) {
                name = name + " [composite]";
            }
            if (this.__getm_handlers()[i].getMissingHandlers().size() == 0) {
                out.println("Handler " + name + " (VALID)");
                continue;
            }
            out.println("Handler " + name + " (INVALID : " + this.__getm_handlers()[i].getMissingHandlers() + ")");
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_handlers")) {
                this.__Fm_handlers = true;
            }
            if (set.contains("m_scope")) {
                this.__Fm_scope = true;
            }
            if (set.contains("m_function")) {
                this.__Fm_function = true;
            }
            if (set.contains("m_archs")) {
                this.__Fm_archs = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("instances")) {
                this.__Minstances = true;
            }
            if (set.contains("instance$java_lang_String")) {
                this.__Minstance$java_lang_String = true;
            }
            if (set.contains("factory$java_lang_String")) {
                this.__Mfactory$java_lang_String = true;
            }
            if (set.contains("factories")) {
                this.__Mfactories = true;
            }
            if (set.contains("handlers")) {
                this.__Mhandlers = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

