/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.disco;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.chameleon.rose.disco.RemoteEntityDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEntityDescriptionManager {
    private RemoteServiceDescriptionImpl servidedesc;
    private ServiceRegistration registration;

    private RemoteEntityDescriptionManager(Builder builder) {
        this.servidedesc = new RemoteServiceDescriptionImpl(builder);
    }

    public void updateProperties(Map<String, Object> properties) throws IllegalArgumentException, IllegalStateException {
        if (this.registration == null) {
            throw new IllegalStateException("The RemoteServiceDescription has not been registered");
        }
        this.servidedesc.setProperties(properties);
        Hashtable<String, Object> description = new Hashtable<String, Object>(this.servidedesc.getProperties());
        this.registration.setProperties(description);
    }

    public void register(BundleContext context) {
        Hashtable<String, Object> description = new Hashtable<String, Object>(this.servidedesc.getProperties());
        description.put("service.pid", this.servidedesc.getId());
        description.put("remote.enity.configs", this.servidedesc.getConfigs());
        description.put("remote.entity.interfaces", this.servidedesc.getInterfaces());
        this.registration = context.registerService(RemoteEntityDescription.class.getName(), (Object)this.servidedesc, description);
    }

    public void unRegister() throws IllegalStateException {
        if (this.registration == null) {
            throw new IllegalStateException("The RemoteServiceDescription has not been registered");
        }
        this.registration.unregister();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteServiceDescriptionImpl
    implements RemoteEntityDescription {
        private final String[] interfaces;
        private final String[] configs;
        private final String id;
        private Map<String, Object> properties;

        public RemoteServiceDescriptionImpl(Builder builder) {
            this.configs = builder.configs;
            this.interfaces = builder.interfaces;
            this.id = builder.remoteid;
            this.setProperties(builder.properties);
        }

        @Override
        public String[] getInterfaces() {
            return this.interfaces;
        }

        @Override
        public String[] getConfigs() {
            return this.configs;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        public Object getProperty(String key) {
            return this.properties.get(key);
        }

        private void setProperties(Map<String, Object> pProperties) {
            try {
                Object new_id = this.properties.get("service.pid");
                if (!this.id.equals(new_id)) {
                    throw new IllegalArgumentException("The properties: service.pid is immutable");
                }
            }
            catch (NullPointerException ne) {
                Object new_id = null;
            }
            try {
                Object new_configs = this.properties.get("remote.enity.configs");
                if (!this.configs.equals(new_configs)) {
                    throw new IllegalArgumentException("The properties: remote.enity.configs is immutable");
                }
            }
            catch (NullPointerException ne) {
                Object new_configs = null;
            }
            try {
                Object new_interfaces = this.properties.get("remote.entity.interfaces");
                if (!this.interfaces.equals(new_interfaces)) {
                    throw new IllegalArgumentException("The properties: remote.entity.interfaces is immutable");
                }
            }
            catch (NullPointerException ne) {
                Object new_interfaces = null;
            }
            this.properties = Collections.unmodifiableMap(pProperties);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final String[] interfaces;
        private final String[] configs;
        private String remoteid = UUID.randomUUID().toString();
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Builder(String[] pInterfaces, String[] pConfigs) {
            this.interfaces = pInterfaces;
            this.configs = pConfigs;
        }

        public Builder id(String id) {
            this.remoteid = id;
            return this;
        }

        public Builder properties(Map<String, Object> pProperties) throws IllegalArgumentException {
            this.properties.putAll(pProperties);
            return this;
        }

        public RemoteEntityDescriptionManager build() {
            return new RemoteEntityDescriptionManager(this);
        }
    }
}

