/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.pub;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.chameleon.rose.pub.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointDescriptionManager {
    private EndpointDescriptionImpl endpointDesc;
    private ServiceRegistration registration;

    private EndpointDescriptionManager(Builder builder) {
        this.endpointDesc = new EndpointDescriptionImpl(builder);
    }

    public void updateProperties(Map<String, Object> properties) throws IllegalArgumentException, IllegalStateException {
        if (this.registration == null) {
            throw new IllegalStateException("The EndpointDescription has not been registered");
        }
        EndpointDescriptionManager.checkProperties(properties);
        this.endpointDesc.setProperties(properties);
        Hashtable<String, Object> description = new Hashtable<String, Object>(this.endpointDesc.getProperties());
        this.registration.setProperties(description);
    }

    public void register(BundleContext context) {
        Hashtable<String, Object> description = new Hashtable<String, Object>(this.endpointDesc.getProperties());
        description.put("endpoint.id", this.endpointDesc.getId());
        description.put("endpoint.configs", this.endpointDesc.getConfigs());
        description.put("endpoint.intents", this.endpointDesc.getIntents());
        description.put("endpoint.interfaces", this.endpointDesc.getInterfaces());
        this.registration = context.registerService(EndpointDescription.class.getName(), (Object)this.endpointDesc, description);
    }

    public void unRegister() throws IllegalStateException {
        if (this.registration == null) {
            throw new IllegalStateException("The RemoteServiceDescription has not been registered");
        }
        this.registration.unregister();
    }

    private static void checkProperties(Map<String, Object> properties) throws IllegalArgumentException {
        if (properties.containsKey("endpoint.id") || properties.containsKey("endpoint.interfaces") || properties.containsKey("endpoint.configs")) {
            throw new IllegalArgumentException("The properties: endpoint.configs, endpoint.id, endpoint.interfaces are immutable and thus cannot be updated");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndpointDescriptionImpl
    implements EndpointDescription {
        private final String[] interfaces;
        private final String[] configs;
        private final String[] intents;
        private final String id;
        private Map<String, Object> properties;

        public EndpointDescriptionImpl(Builder builder) {
            this.configs = builder.configs;
            this.interfaces = builder.interfaces;
            this.id = builder.remoteid;
            this.intents = builder.intents;
            this.setProperties(builder.properties);
        }

        @Override
        public String[] getInterfaces() {
            return this.interfaces;
        }

        @Override
        public String[] getConfigs() {
            return this.configs;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        public Object getProperty(String key) {
            return this.properties.get(key);
        }

        private void setProperties(Map<String, Object> pProperties) {
            this.properties = Collections.unmodifiableMap(pProperties);
        }

        @Override
        public boolean contains(String key) {
            return this.properties.containsKey(key);
        }

        @Override
        public String[] getIntents() {
            return this.intents;
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>(this.properties);
            map.put("endpoint.configs", this.configs);
            map.put("endpoint.interfaces", this.interfaces);
            map.put("endpoint.intents", this.intents);
            map.put("endpoint.id", this.id);
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final String[] interfaces;
        private final String[] configs;
        private final String remoteid;
        private Map<String, Object> properties = new HashMap<String, Object>();
        public String[] intents = new String[0];

        public Builder(String[] pInterfaces, String[] pConfigs, String id) {
            this.interfaces = pInterfaces;
            this.configs = pConfigs;
            this.remoteid = id;
        }

        public Builder intents(String[] pIntents) {
            this.intents = pIntents;
            return this;
        }

        public Builder properties(Map<String, Object> pProperties) throws IllegalArgumentException {
            EndpointDescriptionManager.checkProperties(pProperties);
            this.properties.putAll(pProperties);
            return this;
        }

        public EndpointDescriptionManager build() {
            return new EndpointDescriptionManager(this);
        }
    }
}

