/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.ow2.chameleon.rose.RemoteIdGenerator;
import org.ow2.chameleon.rose.pub.EndpointDescriptionManager;
import org.ow2.chameleon.rose.server.EndpointFactory;
import org.ow2.chameleon.rose.util.Tools;

public class GenericEndpointFactory
implements ServiceTrackerCustomizer,
Pojo {
    private InstanceManager __IM;
    private static final String[] BLACKLIST = new String[]{"service.exported"};
    private boolean __Ffilter;
    private String filter;
    private boolean __Fconfigs;
    private String[] configs;
    private boolean __Fexporter;
    private EndpointFactory exporter;
    private boolean __Flogger;
    private LogService logger;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Ftracker;
    private ServiceTracker tracker;
    private boolean __FsidToEndpointDescription;
    private Map<Long, EndpointDescriptionManager> sidToEndpointDescription;
    private boolean __FidGenerator;
    private RemoteIdGenerator idGenerator;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MbindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference;
    private boolean __MaddingService$org_osgi_framework_ServiceReference;
    private boolean __MmodifiedService$org_osgi_framework_ServiceReference$java_lang_Object;
    private boolean __MremovedService$org_osgi_framework_ServiceReference$java_lang_Object;

    String __getfilter() {
        if (!this.__Ffilter) {
            return this.filter;
        }
        return (String)this.__IM.onGet((Object)this, "filter");
    }

    void __setfilter(String string) {
        if (!this.__Ffilter) {
            this.filter = string;
            return;
        }
        this.__IM.onSet((Object)this, "filter", (Object)string);
    }

    String[] __getconfigs() {
        if (!this.__Fconfigs) {
            return this.configs;
        }
        return (String[])this.__IM.onGet((Object)this, "configs");
    }

    void __setconfigs(String[] stringArray) {
        if (!this.__Fconfigs) {
            this.configs = stringArray;
            return;
        }
        this.__IM.onSet((Object)this, "configs", (Object)stringArray);
    }

    EndpointFactory __getexporter() {
        if (!this.__Fexporter) {
            return this.exporter;
        }
        return (EndpointFactory)this.__IM.onGet((Object)this, "exporter");
    }

    void __setexporter(EndpointFactory endpointFactory) {
        if (!this.__Fexporter) {
            this.exporter = endpointFactory;
            return;
        }
        this.__IM.onSet((Object)this, "exporter", (Object)endpointFactory);
    }

    LogService __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (LogService)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(LogService logService) {
        if (!this.__Flogger) {
            this.logger = logService;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logService);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServiceTracker __gettracker() {
        if (!this.__Ftracker) {
            return this.tracker;
        }
        return (ServiceTracker)this.__IM.onGet((Object)this, "tracker");
    }

    void __settracker(ServiceTracker serviceTracker) {
        if (!this.__Ftracker) {
            this.tracker = serviceTracker;
            return;
        }
        this.__IM.onSet((Object)this, "tracker", (Object)serviceTracker);
    }

    Map __getsidToEndpointDescription() {
        if (!this.__FsidToEndpointDescription) {
            return this.sidToEndpointDescription;
        }
        return (Map)this.__IM.onGet((Object)this, "sidToEndpointDescription");
    }

    void __setsidToEndpointDescription(Map map) {
        if (!this.__FsidToEndpointDescription) {
            this.sidToEndpointDescription = map;
            return;
        }
        this.__IM.onSet((Object)this, "sidToEndpointDescription", (Object)map);
    }

    RemoteIdGenerator __getidGenerator() {
        if (!this.__FidGenerator) {
            return this.idGenerator;
        }
        return (RemoteIdGenerator)this.__IM.onGet((Object)this, "idGenerator");
    }

    void __setidGenerator(RemoteIdGenerator remoteIdGenerator) {
        if (!this.__FidGenerator) {
            this.idGenerator = remoteIdGenerator;
            return;
        }
        this.__IM.onSet((Object)this, "idGenerator", (Object)remoteIdGenerator);
    }

    public GenericEndpointFactory(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private GenericEndpointFactory(InstanceManager _manager, BundleContext pContext) {
        this._setInstanceManager(_manager);
        this.__setcontext(pContext);
        this.__setsidToEndpointDescription(new HashMap());
    }

    private void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        if (this.__gettracker() == null) {
            try {
                this.__settracker(new ServiceTracker(this.__getcontext(), this.__getcontext().createFilter(this.__getfilter()), (ServiceTrackerCustomizer)this));
            }
            catch (InvalidSyntaxException e) {
                this.__getlogger().log(1, "The given filter: " + this.__getfilter() + " is not a valid filter.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.__gettracker().open();
    }

    private void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        if (this.__gettracker() != null) {
            this.__gettracker().close();
        }
    }

    private void bindEndpointFactory(EndpointFactory endpointFactory, ServiceReference serviceReference) {
        if (!this.__MbindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference) {
            this.__bindEndpointFactory(endpointFactory, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference", new Object[]{endpointFactory, serviceReference});
            this.__bindEndpointFactory(endpointFactory, serviceReference);
            this.__IM.onExit((Object)this, "bindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __bindEndpointFactory(EndpointFactory factory, ServiceReference refs) {
        this.__setexporter(factory);
        this.__setconfigs((String[])refs.getProperty("remote.configs.supported"));
    }

    public Object addingService(ServiceReference serviceReference) {
        Object object;
        if (!this.__MaddingService$org_osgi_framework_ServiceReference) {
            return this.__addingService(serviceReference);
        }
        try {
            this.__IM.onEntry((Object)this, "addingService$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            object = this.__addingService(serviceReference);
            this.__IM.onExit((Object)this, "addingService$org_osgi_framework_ServiceReference", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addingService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __addingService(ServiceReference sref) {
        Object service = this.__getcontext().getService(sref);
        String name = Tools.getEndpointName(sref, this.__getconfigs());
        List<String> itfnames = Tools.getItfNames(sref);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        try {
            if (itfnames.size() == 1) {
                properties.put("endpoint.interface.name", itfnames.get(0));
            }
            properties.put("endpoint.name", name);
            this.__getexporter().createEndpoint(service, service.getClass().getClassLoader(), properties);
        }
        catch (Exception e) {
            this.__getlogger().log(1, "Cannot create an endpoint for the service: " + String.valueOf(sref.getProperty("service.id")), (Throwable)e);
            return null;
        }
        try {
            HashMap<String, Object> optioProp = new HashMap<String, Object>(properties);
            optioProp.putAll(Tools.getServiceProperties(sref, BLACKLIST));
            String[] interfaces = itfnames.toArray(new String[itfnames.size()]);
            String id = this.__getidGenerator().generateRemoteId(sref, this.__getconfigs()[0]);
            EndpointDescriptionManager manager = new EndpointDescriptionManager.Builder(interfaces, this.__getconfigs(), id).properties(optioProp).build();
            manager.register(this.__getcontext());
            this.__getsidToEndpointDescription().put((Long)sref.getProperty("service.id"), manager);
        }
        catch (Exception e) {
            this.__getlogger().log(2, "Cannot publish the created endpoint for service: " + String.valueOf(sref.getProperty("service.id")), (Throwable)e);
        }
        return service;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        if (!this.__MmodifiedService$org_osgi_framework_ServiceReference$java_lang_Object) {
            this.__modifiedService(serviceReference, object);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifiedService$org_osgi_framework_ServiceReference$java_lang_Object", new Object[]{serviceReference, object});
            this.__modifiedService(serviceReference, object);
            this.__IM.onExit((Object)this, "modifiedService$org_osgi_framework_ServiceReference$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifiedService$org_osgi_framework_ServiceReference$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __modifiedService(ServiceReference sref, Object service) {
        try {
            long id = (Long)sref.getProperty("service.id");
            if (this.__getsidToEndpointDescription().containsKey(id)) {
                ((EndpointDescriptionManager)this.__getsidToEndpointDescription().get(id)).updateProperties(Tools.getServiceProperties(sref, BLACKLIST));
            }
        }
        catch (Exception e) {
            this.__getlogger().log(2, "Cannot update the endpoint properties for service: " + String.valueOf(sref.getProperty("service.id")), (Throwable)e);
        }
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        if (!this.__MremovedService$org_osgi_framework_ServiceReference$java_lang_Object) {
            this.__removedService(serviceReference, object);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removedService$org_osgi_framework_ServiceReference$java_lang_Object", new Object[]{serviceReference, object});
            this.__removedService(serviceReference, object);
            this.__IM.onExit((Object)this, "removedService$org_osgi_framework_ServiceReference$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removedService$org_osgi_framework_ServiceReference$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __removedService(ServiceReference sref, Object service) {
        try {
            long id = (Long)sref.getProperty("service.id");
            if (this.__getsidToEndpointDescription().containsKey(id)) {
                ((EndpointDescriptionManager)this.__getsidToEndpointDescription().remove(id)).unRegister();
            }
        }
        catch (Exception e) {
            this.__getlogger().log(2, "Cannot unpublished the endpoint for service: " + String.valueOf(sref.getProperty("service.id")), (Throwable)e);
        }
        try {
            String name = Tools.getEndpointName(sref, this.__getconfigs());
            this.__getexporter().destroyEndpoint(name);
        }
        catch (Exception e) {
            this.__getlogger().log(1, "Cannot destroy the endpoint for service: " + String.valueOf(sref.getProperty("service.id")), (Throwable)e);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configs")) {
                this.__Fconfigs = true;
            }
            if (set.contains("sidToEndpointDescription")) {
                this.__FsidToEndpointDescription = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("tracker")) {
                this.__Ftracker = true;
            }
            if (set.contains("exporter")) {
                this.__Fexporter = true;
            }
            if (set.contains("filter")) {
                this.__Ffilter = true;
            }
            if (set.contains("idGenerator")) {
                this.__FidGenerator = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference")) {
                this.__MbindEndpointFactory$org_ow2_chameleon_rose_server_EndpointFactory$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("addingService$org_osgi_framework_ServiceReference")) {
                this.__MaddingService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("modifiedService$org_osgi_framework_ServiceReference$java_lang_Object")) {
                this.__MmodifiedService$org_osgi_framework_ServiceReference$java_lang_Object = true;
            }
            if (set.contains("removedService$org_osgi_framework_ServiceReference$java_lang_Object")) {
                this.__MremovedService$org_osgi_framework_ServiceReference$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

