/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.chameria.launcher;

import com.trolltech.qt.core.QCoreApplication;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QIcon;
import de.akquinet.chameria.launcher.ChameRIA;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.ow2.chameleon.core.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static ChameRIA m_chameleon;

    private Launcher() {
    }

    public static void main(String[] args) throws Exception {
        String loc = System.getProperty("chameria.install.location");
        File root = null;
        root = loc != null ? new File(loc) : new File(System.getProperty("user.dir"));
        Launcher.printWelcomeBanner();
        m_chameleon = null;
        try {
            m_chameleon = Launcher.createChameleon(args);
        }
        catch (Exception e) {
            System.err.println("Cannot initalize Chameleon : " + e.getMessage());
            e.printStackTrace();
        }
        if (m_chameleon == null) {
            return;
        }
        Logger logger = LoggerFactory.getLogger((String)"Chameria-Launcher");
        Launcher.registerShutdownHook(m_chameleon);
        try {
            logger.info("Initiliazing QT");
            QApplication.setGraphicsSystem((String)"raster");
            QApplication.initialize((String[])new String[0]);
            File qt = new File(root, "qt");
            File plugins = new File(qt, "plugins");
            if (plugins.exists()) {
                QCoreApplication.addLibraryPath((String)plugins.getAbsolutePath());
            }
            logger.info("QT initialized");
            Launcher.configureApplication();
            logger.info("Application configured");
            Framework fmwk = m_chameleon.start(args);
            if (fmwk != null) {
                SplashScreen splash = SplashScreen.getSplashScreen();
                if (splash != null) {
                    splash.close();
                }
                QApplication.exec();
            }
            m_chameleon.stop();
            logger.info("Chameleon Stopped");
        }
        catch (BundleException e) {
            System.err.println("Cannot start Chameleon : " + e.getMessage());
        }
    }

    public static ChameRIA getChameleon() {
        return m_chameleon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureApplication() {
        File file = new File("chameria.props");
        if (file.exists()) {
            Properties props = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                props.load(is);
                String n = props.getProperty("application.name");
                if (n != null) {
                    QApplication.setApplicationName((String)n);
                } else {
                    QApplication.setApplicationName((String)"akquinet ChameRIA");
                }
                n = props.getProperty("application.version");
                if (n != null) {
                    QApplication.setApplicationVersion((String)n);
                }
                if ((n = props.getProperty("application.icon")) != null) {
                    QIcon icon = new QIcon(n);
                    QApplication.setWindowIcon((QIcon)icon);
                }
            }
            catch (Exception e) {
                System.err.println("Cannot read the application configuration " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        QApplication.setOrganizationName((String)"akquinet A.G.");
    }

    private static void printWelcomeBanner() {
        StringBuffer banner = new StringBuffer();
        banner.append("\n");
        banner.append("\t============================\n");
        banner.append("\t|                          |\n");
        banner.append("\t|   Welcome to ChameRIA    |\n");
        banner.append("\t|                          |\n");
        banner.append("\t============================\n");
        banner.append("\n");
        System.out.println(banner);
    }

    private static void printStoppedBanner() {
        System.out.println("\n");
        System.out.println("\t=========================");
        System.out.println("\t|   ChameRIA  stopped   |");
        System.out.println("\t=========================");
        System.out.println("\n");
    }

    public static ChameRIA createChameleon(String[] args) throws Exception {
        boolean debug = Launcher.isDebugModeEnabled(args);
        String core = Launcher.getCore(args);
        String app = Launcher.getApp(args);
        String runtime = Launcher.getRuntime(args);
        String fileinstall = Launcher.getDeployDirectory(args);
        String config = Launcher.getProps(args);
        if (config == null || !new File(config).exists()) {
            return new ChameRIA(core, debug, app, runtime, fileinstall, null);
        }
        return new ChameRIA(core, debug, app, runtime, fileinstall, config);
    }

    private static String getDeployDirectory(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains((String)arg, (String)"--deploy=")) continue;
            return arg.substring("--deploy=".length());
        }
        return null;
    }

    private static void registerShutdownHook(final ChameRIA chameleon) {
        Runtime runtime = Runtime.getRuntime();
        Runnable hook = new Runnable(){

            public void run() {
                try {
                    if (chameleon != null) {
                        chameleon.stop();
                        Launcher.printStoppedBanner();
                    }
                }
                catch (BundleException e) {
                    System.err.println("Cannot stop Chameleon correctly : " + e.getMessage());
                }
                catch (InterruptedException e) {
                    System.err.println("Unexpected Exception : " + e.getMessage());
                }
            }
        };
        runtime.addShutdownHook(new Thread(hook));
    }

    private static boolean isDebugModeEnabled(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equalsIgnoreCase("--debug")) continue;
            return true;
        }
        return false;
    }

    private static String getCore(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains((String)arg, (String)"--core=")) continue;
            return arg.substring("--core=".length());
        }
        return null;
    }

    private static String getApp(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains((String)arg, (String)"--app=")) continue;
            return arg.substring("--app=".length());
        }
        return null;
    }

    private static String getProps(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains((String)arg, (String)"--config=")) continue;
            return arg.substring("--config=".length());
        }
        return null;
    }

    private static String getRuntime(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains((String)arg, (String)"--runtime=")) continue;
            return arg.substring("--runtime=".length());
        }
        return null;
    }
}

