/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.core.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreActivator
implements BundleActivator {
    public static final String IPOJO = "org.apache.felix.ipojo-";
    public static final String CONFIG_ADMIN = "org.apache.felix.configadmin-";
    public static final String FILE_INSTALL = "org.apache.felix.fileinstall-";
    public static final String COMPENDIUM = "org.osgi.compendium-";
    public static final int COUNT = 4;
    private File directory;

    public CoreActivator(File dir) {
        this.directory = dir;
    }

    public void start(BundleContext bc) throws Exception {
        Bundle bundle;
        int i;
        Logger logger = LoggerFactory.getLogger("org.ow2.chameleon");
        File[] files = this.directory.listFiles();
        int foundcount = 0;
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (i = 0; i < files.length; ++i) {
            if (!this.match(files[i].getAbsolutePath())) continue;
            logger.info("Installing " + files[i].getName());
            bundle = bc.installBundle("reference:" + files[i].toURI().toURL().toExternalForm());
            bundles.add(bundle);
            ++foundcount;
        }
        if (foundcount < 4) {
            throw new Exception("Cannot install core bundles : only " + foundcount + " bundles found on " + 4);
        }
        for (i = 0; i < bundles.size(); ++i) {
            bundle = (Bundle)bundles.get(i);
            logger.info("Starting " + bundle.getSymbolicName());
            bundle.start();
        }
    }

    private boolean match(String absolutePath) {
        return StringUtils.contains(absolutePath, IPOJO) || StringUtils.contains(absolutePath, CONFIG_ADMIN) || StringUtils.contains(absolutePath, FILE_INSTALL) || StringUtils.contains(absolutePath, COMPENDIUM);
    }

    public void stop(BundleContext bc) throws Exception {
    }
}

