/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.chameria.webview;

import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QDropEvent;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.webkit.QWebSettings;
import com.trolltech.qt.webkit.QWebView;
import de.akquinet.chameria.webview.ChameriaWebView;
import de.akquinet.chameria.webview.WebViewFactory;
import java.io.File;
import java.util.List;

public class WebWindow
extends QMainWindow {
    private QWebView m_view;
    private String m_url;
    private WebViewFactory m_factory;

    protected void dropEvent(QDropEvent arg__1) {
        super.dropEvent(arg__1);
        arg__1.accept();
        List list = arg__1.mimeData().urls();
        for (QUrl url : list) {
            System.out.println(url.toString());
        }
    }

    public WebWindow(String url, WebViewFactory factory) {
        this(null, url, factory);
    }

    public WebWindow(QWidget parent, String url, WebViewFactory factory) {
        super(parent);
        this.m_factory = factory;
        this.m_view = new ChameriaWebView(this.m_factory);
        QWebSettings.globalSettings().setAttribute(QWebSettings.WebAttribute.DeveloperExtrasEnabled, factory.isInspectorEnabled());
        QWebSettings.globalSettings().setAttribute(QWebSettings.WebAttribute.LocalStorageDatabaseEnabled, factory.isLocalStorageEnabled());
        QWebSettings.globalSettings().setAttribute(QWebSettings.WebAttribute.OfflineStorageDatabaseEnabled, factory.isLocalStorageEnabled());
        if (factory.getDefaultFixedFontSize() != -1) {
            QWebSettings.globalSettings().setFontSize(QWebSettings.FontSize.DefaultFixedFontSize, factory.getDefaultFixedFontSize());
        }
        if (factory.getDefaultFontSize() != -1) {
            QWebSettings.globalSettings().setFontSize(QWebSettings.FontSize.DefaultFontSize, factory.getDefaultFontSize());
        }
        if (factory.isLocalStorageEnabled()) {
            File offline = new File(factory.getLocalStorageLocation());
            if (!offline.exists()) {
                offline.mkdir();
            }
            QWebSettings.setOfflineStoragePath((String)offline.getAbsolutePath());
        }
        this.m_url = url;
        this.setCentralWidget((QWidget)this.m_view);
        QApplication.invokeLater((Runnable)new Runnable(){

            public void run() {
                WebWindow.this.m_view.setRenderHints(new QPainter.RenderHint[]{QPainter.RenderHint.Antialiasing, QPainter.RenderHint.HighQualityAntialiasing, QPainter.RenderHint.SmoothPixmapTransform, QPainter.RenderHint.TextAntialiasing, QPainter.RenderHint.NonCosmeticDefaultPen});
                WebWindow.this.open();
                WebWindow.this.repaint();
            }
        });
        this.acceptDrops();
        this.show();
        this.raise();
        this.activateWindow();
    }

    protected void closeEvent(QCloseEvent ev) {
        ev.accept();
        System.exit(0);
    }

    public void open() {
        this.m_view.load(new QUrl(this.m_url));
    }

    public void open(String url) {
        this.m_url = url;
        this.open();
    }
}

