/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.osgi.framework.BundleException;
import org.ow2.chameleon.core.Chameleon;
import org.ow2.chameleon.core.StringUtils;

public final class Main {
    public static final int DEFAULT_ADMIN_PORT = 60900;

    private Main() {
    }

    private static void printWelcomeBanner() {
        StringBuffer banner = new StringBuffer();
        banner.append("\n");
        banner.append("\t============================\n");
        banner.append("\t|                          |\n");
        banner.append("\t|   Welcome to Chameleon   |\n");
        banner.append("\t|                          |\n");
        banner.append("\t============================\n");
        banner.append("\n");
        System.out.println(banner);
    }

    private static void printStartedBanner() {
        System.out.println("\n");
        System.out.println("\t=========================");
        System.out.println("\t|   Chameleon started   |");
        System.out.println("\t=========================");
        System.out.println("\n");
    }

    private static void printStoppedBanner() {
        System.out.println("\n");
        System.out.println("\t=========================");
        System.out.println("\t|   Chameleon stopped   |");
        System.out.println("\t=========================");
        System.out.println("\n");
    }

    public static void main(final String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--stop")) continue;
            Main.stop(args);
            return;
        }
        Main.printWelcomeBanner();
        Chameleon chameleon = null;
        try {
            chameleon = Main.createChameleon(args);
        }
        catch (Exception e) {
            System.err.println("Cannot initalize Chameleon : " + e.getMessage());
        }
        if (chameleon == null) {
            return;
        }
        Main.registerShutdownHook(chameleon);
        try {
            chameleon.start();
        }
        catch (BundleException e) {
            System.err.println("Cannot start Chameleon : " + e.getMessage());
        }
        Main.printStartedBanner();
        boolean admin = Main.isAdminEnabled(args);
        if (admin) {
            final Chameleon cham = chameleon;
            Runnable runnable = new Runnable(){

                public void run() {
                    Main.openAdminSocket(cham, args);
                }
            };
            new Thread(runnable).start();
        }
    }

    private static void stop(String[] args) {
        int port = 60900;
        try {
            String p = System.getProperty("chameleon.admin.port");
            if (p != null) {
                port = Integer.parseInt(p);
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("--chameleon.admin.port=")) continue;
                p = args[i].substring("--chameleon.admin.port=".length());
                port = Integer.parseInt(p);
            }
            Socket client = new Socket(InetAddress.getLocalHost(), port);
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(client.getOutputStream()), true);
            InputStream input = client.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            out.println("STOP");
            out.flush();
            reader.readLine();
            client.close();
        }
        catch (Exception e) {
            System.err.println("Cannot connect to the admin port (" + port + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openAdminSocket(Chameleon chameleon, String[] args) {
        int port = 60900;
        try {
            String p = System.getProperty("chameleon.admin.port");
            if (p != null) {
                port = Integer.parseInt(p);
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("--chameleon.admin.port=")) continue;
                p = args[i].substring("--chameleon.admin.port=".length());
                port = Integer.parseInt(p);
            }
            ServerSocket socket = new ServerSocket(port);
            while (true) {
                Socket client = socket.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(client.getOutputStream()), true);
                String str = reader.readLine();
                if (str != null && str.equals("STOP")) {
                    try {
                        chameleon.stop();
                        out.println("OK");
                    }
                    catch (Exception e) {
                        out.println("KO : " + e.getMessage());
                    }
                    finally {
                        if (socket != null) {
                            socket.close();
                            socket = null;
                        }
                    }
                    return;
                }
                out.println("KO : Unknown command");
            }
        }
        catch (IOException e) {
            System.err.println("Cannot start the admin socket on (" + port + ")");
            return;
        }
    }

    public static Chameleon createChameleon(String[] args) throws Exception {
        boolean debug = Main.isDebugModeEnabled(args);
        String core = Main.getCore(args);
        String app = Main.getApp(args);
        String runtime = Main.getRuntime(args);
        String fileinstall = Main.getDeployDirectory(args);
        String config = Main.getProps(args);
        String sys = Main.getSystemProps(args);
        return new Chameleon(core, debug, app, runtime, fileinstall, config, sys);
    }

    private static String getDeployDirectory(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--deploy=")) continue;
            return arg.substring("--deploy=".length());
        }
        return null;
    }

    private static void registerShutdownHook(final Chameleon chameleon) {
        Runtime runtime = Runtime.getRuntime();
        Runnable hook = new Runnable(){

            public void run() {
                try {
                    if (chameleon != null) {
                        chameleon.stop();
                        Main.printStoppedBanner();
                    }
                }
                catch (BundleException e) {
                    System.err.println("Cannot stop Chameleon correctly : " + e.getMessage());
                }
                catch (InterruptedException e) {
                    System.err.println("Unexpected Exception : " + e.getMessage());
                }
            }
        };
        runtime.addShutdownHook(new Thread(hook));
    }

    private static boolean isDebugModeEnabled(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equalsIgnoreCase("--debug")) continue;
            return true;
        }
        return false;
    }

    private static boolean isAdminEnabled(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equalsIgnoreCase("--admin=disabled")) continue;
            return false;
        }
        return true;
    }

    private static String getCore(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--core=")) continue;
            return arg.substring("--core=".length());
        }
        return null;
    }

    private static String getApp(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--app=")) continue;
            return arg.substring("--app=".length());
        }
        return null;
    }

    private static String getProps(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--config=")) continue;
            return arg.substring("--config=".length());
        }
        return null;
    }

    private static String getSystemProps(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--system=")) continue;
            return arg.substring("--system=".length());
        }
        return null;
    }

    private static String getRuntime(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!StringUtils.contains(arg, "--runtime=")) continue;
            return arg.substring("--runtime=".length());
        }
        return null;
    }
}

